/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.regex;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import net.byteseek.automata.Automata;
import net.byteseek.automata.regex.GlushkovRegexBuilder;
import net.byteseek.automata.regex.RegexBuilder;
import net.byteseek.compiler.AbstractCompiler;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.regex.ParseTreeTransitionFactory;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.parser.regex.RegexParser;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.ParseTreeUtils;
import net.byteseek.parser.tree.node.ByteNode;
import net.byteseek.parser.tree.node.ChildrenNode;

public final class RegexCompiler<T>
extends AbstractCompiler<Automata<T>, ParseTree> {
    private static final boolean NOT_YET_INVERTED = false;
    private final RegexBuilder<T, ParseTree> regexBuilder;

    public RegexCompiler() {
        this(null, null);
    }

    public RegexCompiler(RegexBuilder<T, ParseTree> regexBuilder) {
        this(null, regexBuilder);
    }

    public RegexCompiler(Parser<ParseTree> parser2) {
        this(parser2, null);
    }

    public RegexCompiler(Parser<ParseTree> parser2, RegexBuilder<T, ParseTree> regexBuilder) {
        super(parser2 == null ? new RegexParser() : parser2);
        this.regexBuilder = regexBuilder != null ? regexBuilder : new GlushkovRegexBuilder(new ParseTreeTransitionFactory());
    }

    @Override
    public Automata<T> compile(Collection<String> expressions) throws CompileException {
        ArrayList automataList = new ArrayList();
        for (String expression : expressions) {
            automataList.add(this.compile(expression));
        }
        return this.regexBuilder.buildAlternativesAutomata(automataList);
    }

    @Override
    protected Automata<T> doCompile(ParseTree ast) throws CompileException, ParseException {
        switch (ast.getParseTreeType()) {
            case BYTE: 
            case ALL_BITMASK: 
            case ANY_BITMASK: 
            case SET: 
            case RANGE: 
            case ANY: {
                return this.createTransitionAutomata(ast);
            }
            case STRING: {
                return this.createStringAutomata(ast);
            }
            case CASE_INSENSITIVE_STRING: {
                return this.createCaseInsensitiveStringAutomata(ast);
            }
            case SEQUENCE: {
                return this.createSequenceAutomata(ast);
            }
            case ALTERNATIVES: {
                return this.createAlternativesAutomata(ast);
            }
            case REPEAT: {
                return this.createRepeatedAutomata(ast);
            }
            case REPEAT_MIN_TO_MAX: {
                return this.createRepeatMinToMaxAutomata(ast);
            }
            case REPEAT_MIN_TO_MANY: {
                return this.createRepeatMinToManyAutomata(ast);
            }
            case ZERO_TO_MANY: {
                return this.createZeroToManyAutomata(ast);
            }
            case ONE_TO_MANY: {
                return this.createOneToManyAutomata(ast);
            }
            case OPTIONAL: {
                return this.createOptionalAutomata(ast);
            }
        }
        throw new CompileException(this.getTypeErrorMessage(ast));
    }

    private Automata<T> createTransitionAutomata(ParseTree ast) {
        return this.regexBuilder.buildTransitionAutomata(ast, false);
    }

    private Automata<T> createStringAutomata(ParseTree ast) throws ParseException {
        return this.regexBuilder.buildSequenceAutomata(this.getByteAutomataList(ast.getTextValue()));
    }

    private Automata<T> createCaseInsensitiveStringAutomata(ParseTree ast) throws ParseException {
        return this.regexBuilder.buildSequenceAutomata(this.getCaseInsensitiveAutomataList(ast.getTextValue()));
    }

    private Automata<T> createSequenceAutomata(ParseTree ast) throws ParseException, CompileException {
        return this.regexBuilder.buildSequenceAutomata(this.compileChildren(ast));
    }

    private Automata<T> createAlternativesAutomata(ParseTree ast) throws ParseException, CompileException {
        return this.regexBuilder.buildAlternativesAutomata(this.compileChildren(ast));
    }

    private Automata<T> createOptionalAutomata(ParseTree ast) throws CompileException, ParseException {
        return this.regexBuilder.buildOptionalAutomata(this.compileFirstChild(ast));
    }

    private Automata<T> createOneToManyAutomata(ParseTree ast) throws CompileException, ParseException {
        return this.regexBuilder.buildOneToManyAutomata(this.compileFirstChild(ast));
    }

    private Automata<T> createZeroToManyAutomata(ParseTree ast) throws CompileException, ParseException {
        return this.regexBuilder.buildZeroToManyAutomata(this.compileFirstChild(ast));
    }

    private Automata<T> createRepeatedAutomata(ParseTree ast) throws CompileException, ParseException {
        Automata<T> automata = this.doCompile(ParseTreeUtils.getLastChild(ast));
        int minRepeat = ParseTreeUtils.getFirstRepeatValue(ast);
        return this.regexBuilder.buildMinToMaxAutomata(minRepeat, minRepeat, automata);
    }

    private Automata<T> createRepeatMinToMaxAutomata(ParseTree ast) throws CompileException, ParseException {
        Automata<T> automata = this.doCompile(ParseTreeUtils.getLastChild(ast));
        int minRepeat = ParseTreeUtils.getFirstRepeatValue(ast);
        int maxRepeat = ParseTreeUtils.getSecondRepeatValue(ast);
        return this.regexBuilder.buildMinToMaxAutomata(minRepeat, maxRepeat, automata);
    }

    private Automata<T> createRepeatMinToManyAutomata(ParseTree ast) throws CompileException, ParseException {
        Automata<T> automata = this.doCompile(ParseTreeUtils.getLastChild(ast));
        int minRepeat = ParseTreeUtils.getFirstRepeatValue(ast);
        return this.regexBuilder.buildMinToManyAutomata(minRepeat, automata);
    }

    @Override
    protected ParseTree joinExpressions(List<ParseTree> expressions) throws ParseException, CompileException {
        return new ChildrenNode(ParseTreeType.ALTERNATIVES, expressions);
    }

    private Automata<T> compileFirstChild(ParseTree ast) throws CompileException, ParseException {
        return this.doCompile(ParseTreeUtils.getFirstChild(ast));
    }

    private List<Automata<T>> compileChildren(ParseTree ast) throws CompileException, ParseException {
        ArrayList<Automata<T>> automataList = new ArrayList<Automata<T>>();
        for (ParseTree child : ast) {
            automataList.add(this.doCompile(child));
        }
        return automataList;
    }

    private List<Automata<T>> getByteAutomataList(String fromString) {
        ArrayList<Automata<T>> automataList = new ArrayList<Automata<T>>(fromString.length());
        for (int i = 0; i < fromString.length(); ++i) {
            automataList.add(this.createTransitionAutomata(ByteNode.valueOf((byte)fromString.charAt(i))));
        }
        return automataList;
    }

    private List<Automata<T>> getCaseInsensitiveAutomataList(String fromString) {
        ArrayList<Automata<T>> automataList = new ArrayList<Automata<T>>(fromString.length());
        for (int i = 0; i < fromString.length(); ++i) {
            char character = fromString.charAt(i);
            byte upper = (byte)Character.toUpperCase(character);
            byte lower = (byte)Character.toLowerCase(character);
            if (lower == upper) {
                automataList.add(this.createTransitionAutomata(ByteNode.valueOf(lower)));
                continue;
            }
            ArrayList<ParseTree> caseLetterSet = new ArrayList<ParseTree>(2);
            caseLetterSet.add(ByteNode.valueOf(lower));
            caseLetterSet.add(ByteNode.valueOf(upper));
            ChildrenNode set = new ChildrenNode(ParseTreeType.SET, caseLetterSet);
            automataList.add(this.createTransitionAutomata(set));
        }
        return automataList;
    }

    private String getTypeErrorMessage(ParseTree ast) {
        ParseTreeType type = ast.getParseTreeType();
        return String.format("Unknown parse tree type %s", new Object[]{type});
    }
}

