/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler.matcher;

import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import net.byteseek.compiler.AbstractCompiler;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.matcher.MatcherCompilerUtils;
import net.byteseek.matcher.bytes.ByteMatcher;
import net.byteseek.matcher.bytes.ByteMatcherFactory;
import net.byteseek.matcher.bytes.OptimalByteMatcherFactory;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.parser.regex.RegexParser;
import net.byteseek.parser.tree.ParseTree;
import net.byteseek.parser.tree.ParseTreeType;
import net.byteseek.parser.tree.node.ChildrenNode;
import net.byteseek.utils.ByteUtils;

public class ByteMatcherCompiler
extends AbstractCompiler<ByteMatcher, ParseTree> {
    protected static final boolean NOT_INVERTED = false;
    protected static final boolean INVERTED = true;
    protected static ByteMatcherCompiler defaultCompiler;
    protected static ByteMatcherFactory defaultFactory;
    private final ByteMatcherFactory matcherFactory;

    public static ByteMatcher compileFrom(String expression) throws CompileException {
        defaultCompiler = new ByteMatcherCompiler();
        return (ByteMatcher)defaultCompiler.compile(expression);
    }

    public static ByteMatcher compileFrom(byte[] bytes) {
        defaultFactory = OptimalByteMatcherFactory.FACTORY;
        Set<Byte> byteSet = ByteUtils.toSet(bytes);
        return defaultFactory.create(byteSet, false);
    }

    public static ByteMatcher compileInvertedFrom(byte[] bytes) {
        defaultFactory = OptimalByteMatcherFactory.FACTORY;
        Set<Byte> byteSet = ByteUtils.toSet(bytes);
        return defaultFactory.create(byteSet, true);
    }

    public ByteMatcherCompiler() {
        this(null, null);
    }

    public ByteMatcherCompiler(ByteMatcherFactory factoryToUse) {
        this(null, factoryToUse);
    }

    public ByteMatcherCompiler(Parser<ParseTree> parser2) {
        this(parser2, null);
    }

    public ByteMatcherCompiler(Parser<ParseTree> parser2, ByteMatcherFactory factoryToUse) {
        super(parser2 == null ? new RegexParser() : parser2);
        this.matcherFactory = factoryToUse == null ? OptimalByteMatcherFactory.FACTORY : factoryToUse;
    }

    @Override
    public ByteMatcher compile(Collection<String> expressions) throws CompileException {
        LinkedHashSet<Byte> bytesToMatch = new LinkedHashSet<Byte>();
        for (String expression : expressions) {
            byte[] matchingBytes = ((ByteMatcher)this.compile(expression)).getMatchingBytes();
            bytesToMatch.addAll(ByteUtils.toList(matchingBytes));
        }
        return this.matcherFactory.create(bytesToMatch, false);
    }

    @Override
    protected ByteMatcher doCompile(ParseTree node) throws ParseException {
        switch (node.getParseTreeType()) {
            case BYTE: {
                return MatcherCompilerUtils.createByteMatcher(node);
            }
            case ANY: {
                return MatcherCompilerUtils.createAnyMatcher(node);
            }
            case ALL_BITMASK: {
                return MatcherCompilerUtils.createAllBitmaskMatcher(node);
            }
            case ANY_BITMASK: {
                return MatcherCompilerUtils.createAnyBitmaskMatcher(node);
            }
            case RANGE: {
                return MatcherCompilerUtils.createRangeMatcher(node);
            }
            case SET: {
                return MatcherCompilerUtils.createMatcherFromSet(node, this.matcherFactory);
            }
        }
        throw new ParseException(this.getTypeErrorMessage(node));
    }

    @Override
    protected ParseTree joinExpressions(List<ParseTree> expressions) throws ParseException, CompileException {
        return new ChildrenNode(ParseTreeType.SET, expressions, false);
    }

    private String getTypeErrorMessage(ParseTree node) {
        ParseTreeType type = node.getParseTreeType();
        return String.format("Unknown syntax tree node, type [%s]", new Object[]{type});
    }
}

