/*
 * Decompiled with CFR 0.152.
 */
package net.byteseek.compiler;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.byteseek.compiler.CompileException;
import net.byteseek.compiler.Compiler;
import net.byteseek.parser.ParseException;
import net.byteseek.parser.Parser;
import net.byteseek.utils.ArgUtils;

public abstract class AbstractCompiler<T, S>
implements Compiler<T> {
    private final Parser<S> parser;

    public AbstractCompiler(Parser<S> parser2) {
        ArgUtils.checkNullObject(parser2, "parser");
        this.parser = parser2;
    }

    @Override
    public T compile(String expression) throws CompileException {
        try {
            return this.compile(this.parser.parse(expression));
        }
        catch (ParseException pex) {
            throw new CompileException("A problem occurred parsing the expression: " + expression, pex);
        }
        catch (IllegalArgumentException compex) {
            throw new CompileException("An illegal argument occurred when compiling the expression: " + expression, compex);
        }
        catch (NullPointerException npe) {
            throw new CompileException("A null object occurred when compiling the expression: " + expression, npe);
        }
        catch (ArrayIndexOutOfBoundsException aie) {
            throw new CompileException("An attempt was made to access an array out of its bounds when compiling the expression: " + expression, aie);
        }
    }

    @Override
    public T compile(Collection<String> expressions) throws CompileException {
        ArrayList<S> parsedExpressions = new ArrayList<S>(expressions.size());
        String currentExpression = "";
        try {
            Iterator<String> iterator = expressions.iterator();
            while (iterator.hasNext()) {
                String expression;
                currentExpression = expression = iterator.next();
                parsedExpressions.add(this.parser.parse(expression));
            }
            Object joinedTrees = this.joinExpressions(parsedExpressions);
            return this.compile(joinedTrees);
        }
        catch (ParseException pex) {
            throw new CompileException("A problem occurred parsing the expression: " + currentExpression, pex);
        }
    }

    public T compile(S ast) throws CompileException {
        if (ast == null) {
            throw new CompileException("Null abstract syntax tree passed in.");
        }
        try {
            return this.doCompile(ast);
        }
        catch (IllegalArgumentException e) {
            throw new CompileException(e.getMessage());
        }
        catch (ParseException ex) {
            throw new CompileException(ex.getMessage());
        }
    }

    protected abstract T doCompile(S var1) throws ParseException, CompileException;

    protected abstract S joinExpressions(List<S> var1) throws ParseException, CompileException;
}

