/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.testsipgenerator;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.inout.SIPBuilder;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.data.FormatIdentification;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DigestType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileTime;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Formatter;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.CommandLineParser;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.LoggerFactory;

public class TestSipGeneratorApp {
    static final int ZERO_CONTENT = 0;
    static final int TEXT_CONTENT = 1;
    static final int RANDOM_CONTENT = 2;
    static Options options;
    static CommandLineParser parser;
    static CommandLine cmd;
    static int uniqNodeID;
    static int contentType;
    static int depth;
    static int number;
    static int size;
    static int bigNumber;
    static int bigSize;
    static String out;
    static String word;
    static List<String> generatedMetadatas;
    static Path onDiskStandardPath;
    static Path onDiskBigPath;
    static String standardFileDigest;
    static String bigFileDigest;

    static Options createOptions() {
        Options options = new Options();
        Option help = new Option("h", "help", false, "help");
        options.addOption(help);
        Option depth = new Option("d", "depth", true, "profondeur de l'arbre des ArchiveUnits (1 par d\u00e9faut, min 1, max 128)");
        depth.setArgName("num");
        options.addOption(depth);
        Option number = new Option("n", "number", true, "nombre d'objets de taille standard (0 par d\u00e9faut, min 0, max 1000000)");
        number.setArgName("num");
        options.addOption(number);
        Option size = new Option("s", "size", true, "taille des objets standards en ko (100ko par d\u00e9faut, min 1ko, max 1Go)");
        size.setArgName("num");
        options.addOption(size);
        Option bigNumber = new Option("N", "Number", true, "nombre d'objets de grande taille (0 par d\u00e9faut, min 0, max 100)");
        bigNumber.setArgName("num");
        options.addOption(bigNumber);
        Option bigSize = new Option("S", "Size", true, "taille des gros objets en Mo (1Go par d\u00e9faut, min 1Mo, max 1TO)");
        bigSize.setArgName("num");
        options.addOption(bigSize);
        Option random = new Option("r", "random", false, "g\u00e9n\u00e8re des contenus al\u00e9atoires (donc peu compressibles) dans les fichiers d'objets");
        options.addOption(random);
        Option text = new Option("t", "text", false, "g\u00e9n\u00e8re des contenus textuels (donc compressibles) dans les fichiers d'objets");
        options.addOption(text);
        Option zero = new Option("z", "zero", false, "met uniquement des z\u00e9ros dans les fichiers d'objets (contenu par d\u00e9faut)");
        options.addOption(zero);
        Option out = new Option("o", "out", true, "nom du fichier de sortie (out.sip par d\u00e9faut)");
        out.setArgName("FILE");
        options.addOption(out);
        Option word = new Option("w", "word", true, "mot utilis\u00e9 dans le titre des ArchiveUnits");
        word.setArgName("WORD");
        options.addOption(word);
        Option generatedMetadatas = new Option("gm", "generated-metadatas", true, "listes de metadonn\u00e9es par leur nom seda pr\u00e9sentes \u00e0 la racine de la balise <Content> des unit\u00e9s archivistiques \u00e0 g\u00e9n\u00e9rer automatiquement, s\u00e9par\u00e9es par des virgules. Seules les m\u00e9tadonn\u00e9es de type 'texte' sont prises en compte.");
        generatedMetadatas.setArgName("gm");
        options.addOption(generatedMetadatas);
        return options;
    }

    static void exitHelp(int exitCode) {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp("TestSipGenerator", "Generate populated test SIP", options, "", true);
        System.exit(exitCode);
    }

    static int getIntOrExit(String option) {
        int result = 0;
        try {
            result = Integer.parseInt(cmd.getOptionValue(option));
        }
        catch (NumberFormatException e) {
            System.out.println("Argument entier attendu pour l'option " + option);
            TestSipGeneratorApp.exitHelp(1);
        }
        return result;
    }

    private static void extractOptionsOrExit(String[] args) {
        String gms;
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("help")) {
            TestSipGeneratorApp.exitHelp(0);
        }
        if (cmd.hasOption("depth") && ((depth = TestSipGeneratorApp.getIntOrExit("depth")) < 1 || depth > 128)) {
            System.out.println("Argument hors des limites pour l'option depth");
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("number") && ((number = TestSipGeneratorApp.getIntOrExit("number")) < 0 || number > 1000000)) {
            System.out.println("Argument hors des limites pour l'option number");
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("size") && ((size = TestSipGeneratorApp.getIntOrExit("size")) < 1 || size > 0x40000000)) {
            System.out.println("Argument hors des limites pour l'option size");
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("Number") && ((bigNumber = TestSipGeneratorApp.getIntOrExit("Number")) < 0 || bigNumber > 100)) {
            System.out.println("Argument hors des limites pour l'option Number");
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("Size") && ((bigSize = TestSipGeneratorApp.getIntOrExit("Size")) < 1 || (long)bigSize > 0x40000000L)) {
            System.out.println("Argument hors des limites pour l'option Size");
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("out") && (out = cmd.getOptionValue("out")) == null) {
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("word") && (word = cmd.getOptionValue("word")) == null) {
            TestSipGeneratorApp.exitHelp(1);
        }
        if (cmd.hasOption("text")) {
            contentType = 1;
        }
        if (cmd.hasOption("random")) {
            contentType = 2;
        }
        if (cmd.hasOption("gm") && StringUtils.isNotBlank(gms = cmd.getOptionValue("gm"))) {
            for (String metadata : StringUtils.split(gms, ",")) {
                if (Content.metadataMap.containsKey(metadata) && Content.metadataMap.get(metadata).getMetadataClass().getSimpleName().equals(StringType.class.getSimpleName())) {
                    generatedMetadatas.add(metadata);
                    continue;
                }
                System.out.println("Invalid metadata will not be generated: " + metadata);
            }
        }
    }

    static String generateFile(Path onDiskPath, int blockNumber, int blockSize, int contentType) {
        MessageDigest messageDigest = null;
        try {
            messageDigest = MessageDigest.getInstance("SHA-512");
        }
        catch (NoSuchAlgorithmException var33) {
            System.out.println("Impossible de mobiliser l'algorithme de hashage SHA-512");
            System.exit(1);
        }
        try (FileOutputStream fos = new FileOutputStream(onDiskPath.toFile());){
            int i;
            byte[] object = new byte[blockSize];
            block21: for (i = 0; i < blockSize; ++i) {
                switch (contentType) {
                    case 0: {
                        object[i] = 0;
                        continue block21;
                    }
                    case 1: {
                        int letter = (int)(Math.random() * 31.0);
                        letter = letter > 25 ? 32 : 97 + letter;
                        object[i] = (byte)letter;
                        continue block21;
                    }
                    case 2: {
                        object[i] = (byte)(Math.random() * 256.0);
                    }
                }
            }
            for (i = 0; i < blockNumber; ++i) {
                fos.write(object);
                messageDigest.update(object, 0, blockSize);
            }
        }
        catch (IOException e) {
            System.out.println("Impossible de cr\u00e9er le fichier temporaire " + onDiskPath.toString());
        }
        Formatter formatter = new Formatter();
        try {
            for (byte b : messageDigest.digest()) {
                formatter.format("%02x", b);
            }
            String string = formatter.toString();
            formatter.close();
            return string;
        }
        catch (Throwable throwable) {
            try {
                try {
                    formatter.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Exception e) {
                System.out.println("Impossible d'encoder le hash du fichier [" + onDiskPath.toString() + "]->" + e.getMessage());
                System.exit(1);
                return null;
            }
        }
    }

    static int getUniqNodeID() {
        return ++uniqNodeID;
    }

    static void generateTree(SIPBuilder sb, String auName, int number, int bigNumber, int depth) throws SEDALibException {
        String childAuName;
        if (number == 0 && bigNumber == 0) {
            return;
        }
        if (depth == 0) {
            ArchiveUnit au;
            String childAuName2;
            String uniqueNodeId;
            int i;
            for (i = 0; i < number; ++i) {
                uniqueNodeId = Integer.toString(TestSipGeneratorApp.getUniqNodeID());
                childAuName2 = "Leaf" + uniqueNodeId;
                au = sb.addNewSubArchiveUnit(auName, childAuName2, "Item", word + " " + childAuName2, "Description " + childAuName2);
                for (String metadataName : generatedMetadatas) {
                    au.getContent().addNewMetadata(metadataName, metadataName + "_" + uniqueNodeId);
                }
                TestSipGeneratorApp.addKnownFileToArchiveUnit(au, onDiskStandardPath, standardFileDigest);
            }
            for (i = 0; i < bigNumber; ++i) {
                uniqueNodeId = Integer.toString(TestSipGeneratorApp.getUniqNodeID());
                childAuName2 = "BigLeaf" + uniqueNodeId;
                au = sb.addNewSubArchiveUnit(auName, childAuName2, "Item", word + " " + childAuName2, "Description " + childAuName2);
                for (String metadataName : generatedMetadatas) {
                    au.getContent().addNewMetadata(metadataName, metadataName + "_" + uniqueNodeId);
                }
                TestSipGeneratorApp.addKnownFileToArchiveUnit(au, onDiskBigPath, bigFileDigest);
            }
            return;
        }
        if (Math.floor((double)number / 2.0) > 0.0 || Math.floor((double)bigNumber / 2.0) > 0.0) {
            childAuName = "Node" + Integer.toString(TestSipGeneratorApp.getUniqNodeID());
            sb.addNewSubArchiveUnit(auName, childAuName, "RecordGrp", word + " " + childAuName, "Description " + childAuName);
            TestSipGeneratorApp.generateTree(sb, childAuName, (int)Math.floor((double)number / 2.0), (int)Math.floor((double)bigNumber / 2.0), depth - 1);
        }
        if ((double)number - Math.floor((double)number / 2.0) > 0.0 || (double)bigNumber - Math.floor((double)bigNumber / 2.0) > 0.0) {
            childAuName = "Node" + Integer.toString(TestSipGeneratorApp.getUniqNodeID());
            sb.addNewSubArchiveUnit(auName, childAuName, "RecordGrp", word + " " + childAuName, "Description " + childAuName);
            TestSipGeneratorApp.generateTree(sb, childAuName, (int)((double)number - Math.floor((double)number / 2.0)), (int)((double)bigNumber - Math.floor((double)bigNumber / 2.0)), depth - 1);
        }
    }

    static void addKnownFileToArchiveUnit(ArchiveUnit au, Path onDiskPath, String digest) throws SEDALibException {
        BinaryDataObject bdo = new BinaryDataObject(au.getDataObjectPackage(), onDiskPath, onDiskPath.getFileName().toString(), "BinaryMaster_1");
        TestSipGeneratorApp.putKnownTechnicalElements(bdo, digest);
        au.addDataObjectById(bdo.getInDataObjectPackageId());
    }

    static void putKnownTechnicalElements(BinaryDataObject bdo, String digest) throws SEDALibException {
        FileTime llastModified;
        long lsize;
        Object ir = null;
        String lfilename = null;
        try {
            lsize = Files.size(bdo.getOnDiskPath());
            lfilename = bdo.getOnDiskPath().getFileName().toString();
            llastModified = Files.getLastModifiedTime(bdo.getOnDiskPath(), new LinkOption[0]);
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de g\u00e9n\u00e9rer les infos techniques pour le fichier [" + bdo.getOnDiskPath().toString() + "]\n->" + e.getMessage());
        }
        bdo.addMetadata(new DigestType("MessageDigest", digest, "SHA-512"));
        bdo.addNewMetadata("Size", lsize);
        if (contentType == 1) {
            bdo.addMetadata(new FormatIdentification("Plain Text File", "text/plain", "x-fmt/111", null));
        } else {
            bdo.addNewMetadata("FormatIdentification", "Unknown", null, null, null);
        }
        FileInfo fileInfo = new FileInfo();
        fileInfo.addNewMetadata("Filename", lfilename);
        fileInfo.addNewMetadata("LastModified", llastModified.toString());
        bdo.addMetadata(fileInfo);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) {
        options = TestSipGeneratorApp.createOptions();
        TestSipGeneratorApp.extractOptionsOrExit(args);
        Path outPath = Paths.get(out, new String[0]).toAbsolutePath().normalize();
        Path dirPath = outPath.getParent();
        if (dirPath == null) {
            dirPath = Paths.get("/", new String[0]);
        }
        onDiskStandardPath = dirPath.resolve("standardfile.tmp");
        onDiskBigPath = dirPath.resolve("bigfile.tmp");
        standardFileDigest = TestSipGeneratorApp.generateFile(onDiskStandardPath, size, 1024, contentType);
        bigFileDigest = TestSipGeneratorApp.generateFile(onDiskBigPath, bigSize, 0x100000, contentType);
        SEDALibProgressLogger spl = new SEDALibProgressLogger(LoggerFactory.getLogger("fr/gouv/vitam/tools/testsipgenerator"), 30, null, 100);
        try (SIPBuilder sb = new SIPBuilder(outPath.toString(), spl);){
            sb.setAgencies("FRAN_NP_000001", "FRAN_NP_000010", "FRAN_NP_000015", "FRAN_NP_000019");
            sb.setArchivalAgreement("Accepte_les_objets_non_identifies");
            sb.createRootArchiveUnit("Root", "Subseries", "TestSIPRoot-" + word, "Racine du SIP de test g\u00e9n\u00e9r\u00e9 avec les arguments [" + String.join((CharSequence)" ", args) + "]");
            TestSipGeneratorApp.generateTree(sb, "Root", number, bigNumber, depth - 1);
            sb.generateSIP();
        }
        catch (SEDALibException e) {
            System.out.println("Erreur de traitement du SIP");
            e.printStackTrace();
            System.exit(1);
        }
        finally {
            try {
                Files.delete(onDiskStandardPath);
                Files.delete(onDiskBigPath);
            }
            catch (IOException e) {
                System.out.println("Impossible d'effacer les fichiers interm\u00e9diaires");
                e.printStackTrace();
                System.exit(1);
            }
        }
    }

    static {
        parser = new DefaultParser();
        cmd = null;
        uniqNodeID = 0;
        contentType = 0;
        depth = 1;
        number = 0;
        size = 100;
        bigNumber = 0;
        bigSize = 1024;
        out = "out.zip";
        word = "Titre";
        generatedMetadatas = new ArrayList<String>();
    }
}

