/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.xml;

import fr.gouv.vitam.tools.sedalib.core.seda.SedaContext;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.nio.charset.StandardCharsets;
import java.util.Scanner;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamReader;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamSource;
import javax.xml.validation.Schema;
import javax.xml.validation.SchemaFactory;
import javax.xml.validation.Validator;
import org.apache.xerces.util.XMLCatalogResolver;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

public class SEDAXMLValidator {
    private static final String SEDA_VITAM_VALIDATION_RESOURCE_2_1 = "seda2_1/seda-vitam-2.1-main.xsd";
    private static final String SEDA_VITAM_VALIDATION_RESOURCE_2_2 = "seda2_2/seda-vitam-2.2-main.xsd";
    private static final String SEDA_VITAM_VALIDATION_RESOURCE_2_3 = "seda2_3/seda-2.3-main.xsd";
    private static final String HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1 = "http://www.w3.org/XML/XMLSchema/v1.1";
    private static final String CATALOG_FILENAME = "xsd_validation/catalog.xml";
    private static final String RNG_FACTORY = "com.thaiopensource.relaxng.jaxp.XMLSyntaxSchemaFactory";
    private static final String RNG_PROPERTY_KEY = "javax.xml.validation.SchemaFactory:http://relaxng.org/ns/structure/1.0";

    public static Schema getSEDASchema() throws SEDALibException {
        switch (SedaContext.getVersion()) {
            case V2_1: {
                return SEDAXMLValidator.getSchemaFromXSDResource(SEDAXMLValidator.class.getClassLoader().getResource(SEDA_VITAM_VALIDATION_RESOURCE_2_1));
            }
            case V2_2: {
                return SEDAXMLValidator.getSchemaFromXSDResource(SEDAXMLValidator.class.getClassLoader().getResource(SEDA_VITAM_VALIDATION_RESOURCE_2_2));
            }
            case V2_3: {
                return SEDAXMLValidator.getSchemaFromXSDResource(SEDAXMLValidator.class.getClassLoader().getResource(SEDA_VITAM_VALIDATION_RESOURCE_2_3));
            }
        }
        throw new SEDALibException("Version [" + SedaContext.getVersion() + "] sans sch\u00e9ma", null);
    }

    public static Schema getSchemaFromXSDResource(URL xsdResource) throws SEDALibException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance(HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1);
            URL catalogUrl = SEDAXMLValidator.class.getClassLoader().getResource(CATALOG_FILENAME);
            factory.setResourceResolver(new XMLCatalogResolver(new String[]{catalogUrl.toString()}, false));
            return factory.newSchema(xsdResource);
        }
        catch (SAXException e) {
            throw new SEDALibException("Impossible de charger le sch\u00e9ma " + xsdResource, e);
        }
    }

    public Schema getSchemaFromXSDFile(String xsdFile) throws SEDALibException {
        try {
            SchemaFactory factory = SchemaFactory.newInstance(HTTP_WWW_W3_ORG_XML_XML_SCHEMA_V1_1);
            URL catalogUrl = this.getClass().getClassLoader().getResource(CATALOG_FILENAME);
            factory.setResourceResolver(new XMLCatalogResolver(new String[]{catalogUrl.toString()}, false));
            return factory.newSchema(new File(xsdFile));
        }
        catch (SAXException e) {
            throw new SEDALibException("Impossible de charger le sch\u00e9ma " + xsdFile, e);
        }
    }

    public Schema getSchemaFromRNGFile(String rngFile) throws SEDALibException {
        System.setProperty(RNG_PROPERTY_KEY, RNG_FACTORY);
        try {
            SchemaFactory factory = SchemaFactory.newInstance("http://relaxng.org/ns/structure/1.0");
            URL catalogUrl = this.getClass().getClassLoader().getResource(CATALOG_FILENAME);
            factory.setResourceResolver(new XMLCatalogResolver(new String[]{catalogUrl.toString()}, false));
            return factory.newSchema(new File(rngFile));
        }
        catch (SAXException e) {
            throw new SEDALibException("Impossible de charger le sch\u00e9ma " + rngFile, e);
        }
    }

    private String getContextualErrorMessage(String manifest, SAXParseException e) {
        String line = "";
        String inArchiveUnit = "";
        Scanner scanner2 = new Scanner(manifest);
        for (int i = 0; scanner2.hasNextLine() && i < e.getLineNumber(); ++i) {
            line = scanner2.nextLine();
            if (!line.trim().startsWith("<ArchiveUnit ")) continue;
            inArchiveUnit = line.trim();
        }
        String result = "Contexte de l'erreur: " + (inArchiveUnit.isEmpty() ? "hors AU" : inArchiveUnit) + "\nposition de l'erreur identifi\u00e9e: ligne " + e.getLineNumber() + ", colonne " + e.getColumnNumber() + "\nligne: " + line + "\nerreur brute: " + e.getMessage();
        scanner2.close();
        return result;
    }

    public boolean checkWithXSDSchema(String manifest, Schema xmlSchema) throws SEDALibException {
        XMLStreamReader xmlStreamReader = null;
        try {
            boolean bl;
            ByteArrayInputStream bais = new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8));
            try {
                XMLInputFactory xmlInputFactory = XMLInputFactory.newInstance();
                xmlInputFactory.setProperty("javax.xml.stream.isSupportingExternalEntities", Boolean.FALSE);
                xmlStreamReader = xmlInputFactory.createXMLStreamReader(bais, "UTF-8");
                Validator validator = xmlSchema.newValidator();
                validator.validate(new StAXSource(xmlStreamReader));
                bl = true;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        bais.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (IOException e) {
                    throw new SEDALibException("Erreur d'acc\u00e8s au flux XML", e);
                }
                catch (XMLStreamException e) {
                    throw new SEDALibException("Impossible d'ouvrir le flux XML", e);
                }
                catch (SAXParseException e) {
                    throw new SEDALibException("Le flux XML n'est pas conforme\n-> " + this.getContextualErrorMessage(manifest, e));
                }
                catch (SAXException e) {
                    throw new SEDALibException("Le flux XML n'est pas conforme", e);
                }
            }
            bais.close();
            return bl;
        }
        finally {
            if (xmlStreamReader != null) {
                try {
                    xmlStreamReader.close();
                }
                catch (XMLStreamException xMLStreamException) {}
            }
        }
    }

    public boolean checkWithRNGSchema(String manifest, Schema rngSchema) throws SEDALibException {
        boolean bl;
        ByteArrayInputStream bais = new ByteArrayInputStream(manifest.getBytes(StandardCharsets.UTF_8));
        try {
            Validator validator = rngSchema.newValidator();
            validator.validate(new StreamSource(bais));
            bl = true;
        }
        catch (Throwable throwable) {
            try {
                try {
                    bais.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (SAXParseException e) {
                throw new SEDALibException("Le flux XML n'est pas conforme\n-> " + this.getContextualErrorMessage(manifest, e));
            }
            catch (SAXException e) {
                throw new SEDALibException("Le flux XML n'est pas conforme", e);
            }
            catch (IOException e) {
                throw new SEDALibException("Erreur d'acc\u00e8s au flux XML", e);
            }
        }
        bais.close();
        return bl;
    }
}

