/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.xml;

import fr.gouv.vitam.tools.sedalib.utils.LocalDateTimeUtil;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.IndentXMLTool;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.HashMap;
import java.util.Map;
import java.util.Scanner;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import javax.xml.transform.TransformerFactoryConfigurationError;
import org.apache.commons.lang3.StringUtils;

public class SEDAXMLStreamWriter
implements AutoCloseable {
    public static final String dayTimePattern = "yyyy-MM-dd'T'HH:mm:ss";
    private static final String LINEFEED_CHAR = "\n";
    private static XMLOutputFactory xmlof;
    private static XMLOutputFactory xmlofFragments;
    private Writer rawWriter;
    private XMLStreamWriter xmlWriter;
    private int depth;
    private final Map<Integer, Boolean> hasChildElement;
    private String indentElement;
    private int indentLength;
    private boolean indentFlag;
    private boolean firstLineFlag;
    private int idCounter;

    public SEDAXMLStreamWriter(OutputStream os, int indentLength) throws SEDALibException {
        this(os, indentLength, false);
    }

    public SEDAXMLStreamWriter(OutputStream os, int indentLength, boolean isForElements) throws SEDALibException {
        try {
            this.rawWriter = new OutputStreamWriter(os, StandardCharsets.UTF_8);
            this.xmlWriter = isForElements ? xmlofFragments.createXMLStreamWriter(this.rawWriter) : xmlof.createXMLStreamWriter(this.rawWriter);
        }
        catch (Exception e) {
            throw new SEDALibException("Impossible d'ouvrir un flux d'\u00e9criture XML", e);
        }
        this.depth = 0;
        this.hasChildElement = new HashMap<Integer, Boolean>();
        this.indentElement = StringUtils.repeat(' ', indentLength);
        this.indentLength = indentLength;
        this.indentFlag = indentLength > 0;
        this.firstLineFlag = true;
        this.idCounter = 1;
    }

    void resetIdCounter() {
        this.idCounter = 1;
    }

    public void setXmlId(boolean prefix) throws XMLStreamException {
        if (prefix) {
            this.xmlWriter.writeAttribute("xml", "xml", "id", "ID" + Integer.toString(this.idCounter++));
        } else {
            this.xmlWriter.writeAttribute("id", "ID" + Integer.toString(this.idCounter++));
        }
    }

    public void writeElementValue(String element, String value) throws XMLStreamException {
        if (value == null) {
            this.writeEmptyIndent();
            this.xmlWriter.writeEmptyElement(element);
        } else {
            this.writeStartIndent();
            this.xmlWriter.writeStartElement(element);
            this.xmlWriter.writeCharacters(value);
            this.writeEndIndent();
            this.xmlWriter.writeEndElement();
        }
    }

    public void writeBooleanElementValue(String element, Boolean value) throws XMLStreamException {
        if (value == null) {
            this.writeEmptyIndent();
            this.xmlWriter.writeEmptyElement(element);
        } else {
            this.writeStartIndent();
            this.xmlWriter.writeStartElement(element);
            if (value.booleanValue()) {
                this.xmlWriter.writeCharacters("true");
            } else {
                this.xmlWriter.writeCharacters("false");
            }
            this.writeEndIndent();
            this.xmlWriter.writeEndElement();
        }
    }

    public void writeElementValueWithDefault(String element, String value, String def) throws XMLStreamException {
        if (value == null || value.isEmpty()) {
            this.writeElementValue(element, def);
        } else {
            this.writeElementValue(element, value);
        }
    }

    public void writeElementValueIfNotEmpty(String element, String value) throws XMLStreamException {
        if (value != null && !value.isEmpty()) {
            this.writeElementValue(element, value);
        }
    }

    public void writeElementValueIfNotEmpty(String element, Boolean value) throws XMLStreamException {
        if (value != null) {
            this.writeBooleanElementValue(element, value);
        }
    }

    public static String getStringFromDateTime(LocalDateTime dateTime) {
        if (dateTime == null) {
            dateTime = LocalDateTime.now();
        }
        return LocalDateTimeUtil.getFormattedDateTime(dateTime);
    }

    public static String getStringFromDate(LocalDate date) {
        LocalDate d = date == null ? LocalDate.now() : date;
        return d.format(DateTimeFormatter.ISO_DATE);
    }

    public void writeRawXMLBlockIfNotEmpty(String rawXml) throws XMLStreamException {
        if (rawXml != null && !rawXml.isEmpty()) {
            this.xmlWriter.writeCharacters("");
            this.xmlWriter.flush();
            try {
                Object identXml;
                if (this.indentFlag) {
                    try {
                        identXml = IndentXMLTool.getInstance(this.indentLength).indentString(rawXml);
                        Scanner s = new Scanner((String)identXml);
                        StringBuilder sb = new StringBuilder();
                        while (s.hasNextLine()) {
                            String line = s.nextLine();
                            if (line.trim().startsWith("<")) {
                                sb.append(StringUtils.repeat(this.indentElement, this.depth));
                            }
                            sb.append(line).append('\n');
                        }
                        s.close();
                        if (sb.length() > 1) {
                            sb.setLength(sb.length() - 1);
                        }
                        identXml = LINEFEED_CHAR + sb.toString();
                    }
                    catch (Exception e) {
                        identXml = LINEFEED_CHAR + rawXml;
                    }
                } else {
                    identXml = rawXml;
                }
                this.rawWriter.write((String)identXml);
                this.rawWriter.flush();
                if (this.indentFlag && this.depth > 0) {
                    this.hasChildElement.put(this.depth - 1, true);
                }
            }
            catch (IOException e) {
                throw new XMLStreamException("Erreur d'\u00e9criture d'un bloc Raw XML", e);
            }
        }
    }

    public XMLStreamWriter getXmlWriter() {
        return this.xmlWriter;
    }

    @Override
    public void close() throws XMLStreamException {
        this.xmlWriter.close();
    }

    public void flush() throws XMLStreamException {
        this.xmlWriter.flush();
    }

    public void writeAttribute(String localName, String value) throws XMLStreamException {
        this.xmlWriter.writeAttribute("", "", localName, value);
    }

    public void writeAttributeIfNotEmpty(String localName, String value) throws XMLStreamException {
        if (value != null && !value.isEmpty()) {
            this.writeAttribute(localName, value);
        }
    }

    public void writeAttribute(String prefix, String namespaceURI, String localName, String value) throws XMLStreamException {
        this.xmlWriter.writeAttribute(prefix, namespaceURI, localName, value);
    }

    public void writeCharacters(String text) throws XMLStreamException {
        this.xmlWriter.writeCharacters(text);
    }

    public void writeCharactersIfNotEmpty(String text) throws XMLStreamException {
        if (text != null && !text.isEmpty()) {
            this.xmlWriter.writeCharacters(text);
        }
    }

    public void writeComment(String data) throws XMLStreamException {
        this.xmlWriter.writeComment(data);
    }

    public void writeDefaultNamespace(String namespaceURI) throws XMLStreamException {
        this.xmlWriter.writeDefaultNamespace(namespaceURI);
    }

    public void writeEndDocument() throws XMLStreamException {
        this.xmlWriter.writeEndDocument();
    }

    public void writeEndElement() throws XMLStreamException {
        this.writeEndIndent();
        this.xmlWriter.writeEndElement();
    }

    public void writeNamespace(String prefix, String namespaceURI) throws XMLStreamException {
        this.xmlWriter.writeNamespace(prefix, namespaceURI);
    }

    public void writeStartDocument() throws XMLStreamException {
        this.xmlWriter.writeStartDocument();
    }

    public void writeStartElement(String localName) throws XMLStreamException {
        this.writeStartIndent();
        this.xmlWriter.writeStartElement(localName);
    }

    private void writeStartIndent() throws XMLStreamException {
        if (this.indentFlag) {
            if (this.depth > 0) {
                this.hasChildElement.put(this.depth - 1, true);
            }
            this.hasChildElement.put(this.depth, false);
            if (this.firstLineFlag) {
                this.firstLineFlag = false;
            } else {
                this.xmlWriter.writeCharacters(LINEFEED_CHAR);
            }
            this.xmlWriter.writeCharacters(StringUtils.repeat(this.indentElement, this.depth));
            ++this.depth;
        }
    }

    private void writeEmptyIndent() throws XMLStreamException {
        if (this.indentFlag) {
            if (this.depth > 0) {
                this.hasChildElement.put(this.depth - 1, true);
            }
            if (this.firstLineFlag) {
                this.firstLineFlag = false;
            } else {
                this.xmlWriter.writeCharacters(LINEFEED_CHAR);
            }
            this.xmlWriter.writeCharacters(StringUtils.repeat(this.indentElement, this.depth));
        }
    }

    private void writeEndIndent() throws XMLStreamException {
        if (this.indentFlag) {
            --this.depth;
            if (this.hasChildElement.get(this.depth).booleanValue()) {
                this.xmlWriter.writeCharacters(LINEFEED_CHAR);
                this.xmlWriter.writeCharacters(StringUtils.repeat(this.indentElement, this.depth));
            }
        }
    }

    static {
        try {
            xmlof = XMLOutputFactory.newInstance();
            xmlofFragments = XMLOutputFactory.newInstance();
            xmlofFragments.setProperty("com.ctc.wstx.outputValidateStructure", false);
        }
        catch (TransformerFactoryConfigurationError e) {
            System.err.println("Erreur fatale, impossible de cr\u00e9er les outils de manipulation Xml et/ou Droid");
            System.exit(1);
        }
    }
}

