/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.xml;

import com.ctc.wstx.api.WstxInputProperties;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.StringWriter;
import java.nio.charset.StandardCharsets;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.util.Optional;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLEventWriter;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.codehaus.stax2.XMLInputFactory2;
import org.codehaus.stax2.XMLOutputFactory2;

public class SEDAXMLEventReader
implements AutoCloseable {
    private static XMLInputFactory xmlif;
    private static XMLInputFactory xmlifFragments;
    private static XMLOutputFactory xmlof;
    private static XMLOutputFactory xmlofFragments;
    public XMLEventReader xmlReader;

    public static String extractNamedElement(String elementName, String xmlString) {
        String result = null;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xmlString.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            XMLEvent event = xmlReader.nextUsefullEvent();
            while (true) {
                if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(elementName)) {
                    event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        result = event.asCharacters().getData();
                    }
                    break;
                }
                event = xmlReader.nextUsefullEvent();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        return result;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String extractFragments(String elementName, String xmlData) {
        StringWriter sw = new StringWriter();
        try {
            XMLEventWriter xw;
            int count;
            XMLEvent event;
            SEDAXMLEventReader xmlReader;
            block20: {
                ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8));
                xmlReader = new SEDAXMLEventReader(bais, true);
                event = xmlReader.nextUsefullEvent();
                while (true) {
                    if (event.isStartElement() && event.asStartElement().getName().getLocalPart().equals(elementName)) {
                        count = 1;
                        xw = xmlofFragments.createXMLEventWriter(sw);
                        break block20;
                    }
                    event = xmlReader.nextUsefullEvent();
                }
                finally {
                    xmlReader.close();
                }
                finally {
                    bais.close();
                }
            }
            while (xmlReader.xmlReader.hasNext()) {
                event = xmlReader.xmlReader.nextEvent();
                if (event.isStartElement() && ((StartElement)event).getName().getLocalPart().equals(elementName)) {
                    ++count;
                } else if (event.isEndElement() && ((EndElement)event).getName().getLocalPart().equals(elementName) && --count == 0) break;
                xw.add(event);
            }
            if (xw != null) {
                xw.close();
            }
            String string = sw.toString();
            return string;
        }
        catch (Exception e) {
            return null;
        }
    }

    public SEDAXMLEventReader(InputStream is) throws SEDALibException {
        this(is, false);
    }

    public SEDAXMLEventReader(InputStream is, boolean isForElements) throws SEDALibException {
        InputStreamReader readerFIS = null;
        try {
            readerFIS = new InputStreamReader(is, StandardCharsets.UTF_8);
            this.xmlReader = isForElements ? xmlifFragments.createXMLEventReader(readerFIS) : xmlif.createXMLEventReader(readerFIS);
        }
        catch (Exception e) {
            if (readerFIS != null) {
                try {
                    readerFIS.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SEDALibException("Impossible d'ouvrir un flux de lecture XML", e);
        }
    }

    @Override
    public void close() throws XMLStreamException {
        this.xmlReader.close();
    }

    public static LocalDateTime getDateTimeFromString(String datetimeString) throws DateTimeParseException {
        LocalDateTime ldt;
        try {
            ldt = LocalDateTime.parse(datetimeString, DateTimeFormatter.ISO_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            ldt = LocalDate.parse(datetimeString, DateTimeFormatter.ISO_DATE).atStartOfDay();
        }
        return ldt;
    }

    public static LocalDate getDateFromString(String dateString) throws DateTimeParseException {
        return LocalDate.parse(dateString, DateTimeFormatter.ISO_DATE);
    }

    public String peekName() throws XMLStreamException {
        XMLEvent event = this.peekUsefullEvent();
        if (!event.isStartElement()) {
            return null;
        }
        return event.asStartElement().getName().getLocalPart();
    }

    public XMLEvent peekUsefullEvent() throws XMLStreamException {
        XMLEvent result = this.xmlReader.peek();
        while (result.getEventType() == 5 || result.isCharacters() && result.asCharacters().isWhiteSpace()) {
            this.xmlReader.nextEvent();
            result = this.xmlReader.peek();
        }
        return result;
    }

    public String peekAttribute(String attribute) throws XMLStreamException {
        Attribute a;
        XMLEvent peek = this.peekUsefullEvent();
        String result = null;
        if (peek.isStartElement() && (a = peek.asStartElement().getAttributeByName(new QName(attribute))) != null) {
            result = a.getValue();
        }
        return result;
    }

    public String peekAttribute(String namespace, String attribute) throws XMLStreamException {
        Attribute a;
        XMLEvent peek = this.peekUsefullEvent();
        String result = null;
        if (peek.isStartElement() && (a = peek.asStartElement().getAttributeByName(new QName(namespace, attribute))) != null) {
            result = a.getValue();
        }
        return result;
    }

    public XMLEvent nextUsefullEvent() throws XMLStreamException {
        XMLEvent result = this.xmlReader.nextEvent();
        while (result.getEventType() == 5 || result.isCharacters() && result.asCharacters().isWhiteSpace()) {
            result = this.xmlReader.nextEvent();
        }
        return result;
    }

    public boolean nextBlockIfNamed(String tag) throws XMLStreamException {
        XMLEvent peek = this.peekUsefullEvent();
        if (!peek.isStartElement()) {
            return false;
        }
        if (!tag.equals(peek.asStartElement().getName().getLocalPart())) {
            return false;
        }
        this.nextUsefullEvent();
        return true;
    }

    public boolean peekBlockIfNamed(String tag) throws XMLStreamException {
        XMLEvent peek = this.peekUsefullEvent();
        if (!peek.isStartElement()) {
            return false;
        }
        return tag.equals(peek.asStartElement().getName().getLocalPart());
    }

    public String peekAttributeBlockIfNamed(String tag, String attribute) throws XMLStreamException {
        XMLEvent peek = this.peekUsefullEvent();
        if (!peek.isStartElement()) {
            return null;
        }
        if (!tag.equals(peek.asStartElement().getName().getLocalPart())) {
            return null;
        }
        QName qName = new QName(attribute);
        StartElement startElement = peek.asStartElement();
        Attribute attr = startElement.getAttributeByName(qName);
        return Optional.ofNullable(attr).map(Attribute::getValue).orElse(null);
    }

    public void endBlockNamed(String tag) throws XMLStreamException, SEDALibException {
        XMLEvent event = this.nextUsefullEvent();
        if (!event.isEndElement()) {
            throw new SEDALibException("El\u00e9ment " + tag + " mal termin\u00e9");
        }
        if (!tag.equals(event.asEndElement().getName().getLocalPart())) {
            throw new SEDALibException("El\u00e9ment " + tag + " mal termin\u00e9");
        }
    }

    public String nextValueIfNamed(String tag) throws XMLStreamException, SEDALibException {
        String result = null;
        if (this.nextBlockIfNamed(tag)) {
            XMLEvent event = this.nextUsefullEvent();
            if (event.isCharacters()) {
                result = event.asCharacters().getData();
                event = this.nextUsefullEvent();
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(tag)) {
                throw new SEDALibException("El\u00e9ment " + tag + " mal form\u00e9");
            }
            if (result == null) {
                result = "";
            }
        }
        return result;
    }

    public LocalDateTime nextDateValueIfNamed(String tag) throws XMLStreamException, SEDALibException {
        String tmp = null;
        LocalDateTime result = null;
        if (this.nextBlockIfNamed(tag)) {
            XMLEvent event = this.nextUsefullEvent();
            if (event.isCharacters()) {
                tmp = event.asCharacters().getData();
                event = this.nextUsefullEvent();
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(tag) || tmp == null) {
                throw new SEDALibException("El\u00e9ment date " + tag + " mal form\u00e9");
            }
            try {
                result = SEDAXMLEventReader.getDateTimeFromString(tmp);
            }
            catch (DateTimeParseException e) {
                throw new SEDALibException("Valeur non interpr\u00e9table [" + tmp + "] dans l'\u00e9l\u00e9ment date " + tag, e);
            }
        }
        return result;
    }

    public Boolean nextBooleanValueIfNamed(String tag) throws XMLStreamException, SEDALibException {
        String tmp = null;
        Boolean result = null;
        if (this.nextBlockIfNamed(tag)) {
            XMLEvent event = this.nextUsefullEvent();
            if (event.isCharacters()) {
                tmp = event.asCharacters().getData();
                event = this.nextUsefullEvent();
            }
            if (!event.isEndElement() || !event.asEndElement().getName().getLocalPart().equals(tag) || tmp == null) {
                throw new SEDALibException("El\u00e9ment bool\u00e9en " + tag + " mal form\u00e9");
            }
            switch (tmp) {
                case "true": 
                case "1": {
                    result = true;
                    break;
                }
                case "false": 
                case "0": {
                    result = false;
                    break;
                }
                default: {
                    throw new SEDALibException("Valeur interdite [" + tmp + "] dans l'\u00e9l\u00e9ment bool\u00e9en " + tag);
                }
            }
        }
        return result;
    }

    public String nextMandatoryValue(String tag) throws XMLStreamException, SEDALibException {
        if (!this.peekBlockIfNamed(tag)) {
            throw new SEDALibException("Element " + tag + " non trouv\u00e9");
        }
        return this.nextValueIfNamed(tag);
    }

    public String nextBlockAsStringIfNamed(String tag) throws XMLStreamException {
        XMLEvent event = this.peekUsefullEvent();
        if (event.isStartElement() && tag.equals(event.asStartElement().getName().getLocalPart())) {
            int count = 0;
            StringWriter sw = new StringWriter();
            XMLEventWriter xw = xmlof.createXMLEventWriter(sw);
            while (this.xmlReader.hasNext()) {
                event = this.xmlReader.nextEvent();
                xw.add(event);
                if (event.isStartElement() && ((StartElement)event).getName().getLocalPart().equals(tag)) {
                    ++count;
                    continue;
                }
                if (!event.isEndElement() || !((EndElement)event).getName().getLocalPart().equals(tag) || --count != 0) continue;
            }
            if (xw != null) {
                xw.close();
            }
            return sw.toString();
        }
        return null;
    }

    public String nextMandatoryBlockAsString(String tag) throws XMLStreamException, SEDALibException {
        if (!this.peekBlockIfNamed(tag)) {
            throw new SEDALibException("El\u00e9ment " + tag + " non trouv\u00e9");
        }
        return this.nextBlockAsStringIfNamed(tag);
    }

    static {
        try {
            xmlif = XMLInputFactory.newInstance();
            xmlifFragments = XMLInputFactory2.newInstance();
            xmlifFragments.setProperty("com.ctc.wstx.fragmentMode", WstxInputProperties.PARSING_MODE_FRAGMENT);
            xmlof = XMLOutputFactory.newInstance();
            xmlofFragments = XMLOutputFactory2.newInstance();
            xmlofFragments.setProperty("com.ctc.wstx.outputValidateStructure", false);
        }
        catch (Exception e) {
            System.err.println("Erreur fatale, impossible de cr\u00e9er les outils de manipulation Xml et/ou Droid");
            System.exit(1);
        }
    }
}

