/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.xml;

import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Scanner;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.xpath.XPath;
import javax.xml.xpath.XPathConstants;
import javax.xml.xpath.XPathExpressionException;
import javax.xml.xpath.XPathFactory;
import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class IndentXMLTool {
    public static final int STANDARD_INDENT = 2;
    DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
    TransformerFactory tf = TransformerFactory.newInstance();
    Transformer appTransformer;
    XPathFactory xpf;
    int indentLength;
    String indentElement;
    static IndentXMLTool instance;

    private IndentXMLTool(int indentLength) {
        this.tf.setAttribute("indent-number", 2);
        try {
            this.appTransformer = this.tf.newTransformer();
            this.appTransformer.setOutputProperty("encoding", "UTF-8");
            this.appTransformer.setOutputProperty("omit-xml-declaration", "yes");
            if (indentLength > 0) {
                this.appTransformer.setOutputProperty("indent", "yes");
                this.appTransformer.setOutputProperty("{http://xml.apache.org/xslt}indent-amount", Integer.toString(indentLength));
            }
        }
        catch (Exception e) {
            this.appTransformer = null;
        }
        this.xpf = XPathFactory.newInstance();
        this.indentLength = indentLength;
        this.indentElement = StringUtils.repeat(" ", indentLength);
    }

    public static IndentXMLTool getInstance(int indentLength) {
        if (instance == null || IndentXMLTool.instance.indentLength != indentLength) {
            instance = new IndentXMLTool(indentLength);
        }
        return instance;
    }

    public String indentString(String xml) throws SEDALibException {
        if ((xml = xml.trim()).isEmpty()) {
            return "";
        }
        if (this.appTransformer == null) {
            return xml;
        }
        try {
            DocumentBuilder appDocumentBuilder = this.dbf.newDocumentBuilder();
            Document doc = appDocumentBuilder.parse(new InputSource(new StringReader("<INDENT>" + xml + "</INDENT>")));
            XPath xPath = this.xpf.newXPath();
            NodeList nodeList = (NodeList)xPath.evaluate("//text()[normalize-space()='']", doc, XPathConstants.NODESET);
            for (int i = 0; i < nodeList.getLength(); ++i) {
                Node node = nodeList.item(i);
                node.getParentNode().removeChild(node);
            }
            StringWriter stringWriter = new StringWriter();
            StreamResult streamResult = new StreamResult(stringWriter);
            this.appTransformer.transform(new DOMSource(doc), streamResult);
            String result = stringWriter.toString();
            result = result.substring(0, result.lastIndexOf("</INDENT>") - 1).substring(9);
            while (result.startsWith("\n")) {
                result = result.substring(1);
            }
            StringBuilder sb = new StringBuilder();
            try (Scanner s = new Scanner(result);){
                while (s.hasNextLine()) {
                    String tmp = s.nextLine();
                    if (tmp.startsWith(this.indentElement) && tmp.trim().startsWith("<")) {
                        tmp = tmp.substring(this.indentLength);
                    }
                    sb.append(tmp).append('\n');
                }
            }
            if (sb.length() > 1) {
                sb.setLength(sb.length() - 1);
            }
            return sb.toString();
        }
        catch (IOException | ParserConfigurationException | TransformerException | XPathExpressionException | SAXException e) {
            throw new SEDALibException("XML mal form\u00e9", e);
        }
    }
}

