/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.utils;

import java.io.ByteArrayOutputStream;
import java.io.PrintStream;
import java.text.DecimalFormat;
import java.time.Instant;
import org.slf4j.Logger;
import org.slf4j.Marker;
import org.slf4j.MarkerFactory;

public class SEDALibProgressLogger {
    public static final int GLOBAL = 10;
    public static final Marker GLOBAL_MARKER = MarkerFactory.getMarker("GLOBAL");
    public static final int STEP = 20;
    public static final Marker STEP_MARKER = MarkerFactory.getMarker("STEP");
    public static final int OBJECTS_GROUP = 30;
    public static final Marker OBJECTS_GROUP_MARKER = MarkerFactory.getMarker("OBJECTS_GROUP");
    public static final int OBJECTS = 40;
    public static final Marker OBJECTS_MARKER = MarkerFactory.getMarker("OBJECTS");
    public static final int OBJECTS_WARNINGS = 50;
    public static final Marker OBJECTS_WARNINGS_MARKER = MarkerFactory.getMarker("OBJECTS_WARNINGS");
    private ProgressLogFunc progressLogFunc;
    private Logger logger;
    private int step;
    private int stepDuration;
    private long previousStepEpochSeconds;
    private int progressLogLevel;
    private int progressFuncLogLevel;
    private int progressFuncStep;
    private boolean debugFlag;

    public SEDALibProgressLogger(Logger logger, int progressLogLevel) {
        this.progressLogFunc = null;
        this.logger = logger;
        this.step = Integer.MAX_VALUE;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = this.step;
        this.stepDuration = Integer.MAX_VALUE;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.debugFlag = false;
    }

    public SEDALibProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = step;
        this.stepDuration = Integer.MAX_VALUE;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.debugFlag = false;
    }

    public SEDALibProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step, int stepDuration) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressLogLevel;
        this.progressFuncStep = step;
        this.stepDuration = stepDuration;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.debugFlag = false;
    }

    public SEDALibProgressLogger(Logger logger, int progressLogLevel, ProgressLogFunc progressConsumer, int step, int stepDuration, int progressFuncLogLevel, int progressFuncStep) {
        this.progressLogFunc = progressConsumer;
        this.logger = logger;
        this.step = step;
        this.progressLogLevel = progressLogLevel;
        this.progressFuncLogLevel = progressFuncLogLevel;
        this.progressFuncStep = progressFuncStep;
        this.stepDuration = stepDuration;
        this.previousStepEpochSeconds = Instant.now().getEpochSecond();
        this.debugFlag = false;
    }

    public void setDebugFlag(boolean debugFlag) {
        this.debugFlag = debugFlag;
    }

    public boolean getDebugFlag() {
        return this.debugFlag;
    }

    public static String getMessagesStackString(Throwable e) {
        String result = "-> " + e.getMessage();
        if (e.getCause() instanceof Exception) {
            result = result + "\n" + SEDALibProgressLogger.getMessagesStackString(e.getCause());
        }
        return result;
    }

    private static String getJavaStackString(Throwable e) {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        PrintStream ps = new PrintStream(baos);
        e.printStackTrace(ps);
        return baos.toString();
    }

    public static String getAllJavaStackString(Throwable e) {
        Object result = SEDALibProgressLogger.getJavaStackString(e);
        if (e.getCause() instanceof Exception) {
            result = (String)result + "\n------------------------------------\n" + SEDALibProgressLogger.getJavaStackString(e.getCause());
        }
        return result;
    }

    public static void doProgressLogWithoutInterruption(SEDALibProgressLogger spl, int level, String log, Throwable e) {
        if (spl != null && level <= spl.progressLogLevel) {
            if (e != null) {
                log = (String)log + "\n" + SEDALibProgressLogger.getMessagesStackString(e);
            }
            if (spl.progressLogFunc != null && level <= spl.progressFuncLogLevel) {
                spl.progressLogFunc.doProgressLog(-1, (String)log);
            }
            if (e != null && spl.debugFlag) {
                log = (String)log + "\n" + SEDALibProgressLogger.getAllJavaStackString(e);
            }
            spl.log(level, (String)log);
        }
    }

    public static void doProgressLogIfDebug(SEDALibProgressLogger spl, String log, Throwable e) {
        if (spl != null && spl.debugFlag) {
            SEDALibProgressLogger.doProgressLogWithoutInterruption(spl, 10, log, e);
        }
    }

    public static void doProgressLog(SEDALibProgressLogger spl, int level, String log, Exception e) throws InterruptedException {
        if (spl != null) {
            SEDALibProgressLogger.doProgressLogWithoutInterruption(spl, level, log, e);
            Thread.sleep(1L);
        }
    }

    public static void doProgressLogIfStep(SEDALibProgressLogger spl, int level, int count, String log) throws InterruptedException {
        if (spl != null && level <= spl.progressLogLevel) {
            long nowEpochSeconds = Instant.now().getEpochSecond();
            if ((long)spl.stepDuration < nowEpochSeconds - spl.previousStepEpochSeconds) {
                if (spl.progressLogFunc != null && level <= spl.progressFuncLogLevel) {
                    spl.progressLogFunc.doProgressLog(count, (count % spl.progressFuncStep == 0 ? "" : " * ") + log);
                }
                spl.log(level, log);
                Thread.sleep(1L);
                spl.previousStepEpochSeconds = nowEpochSeconds;
                return;
            }
            if (count % spl.step == 0) {
                spl.log(level, log);
            }
            if (spl.progressLogFunc != null && count % spl.progressFuncStep == 0) {
                spl.progressLogFunc.doProgressLog(count, log);
                Thread.sleep(1L);
            }
        }
    }

    public static String readableFileSize(long size) {
        if (size <= 0L) {
            return "0";
        }
        String[] units = new String[]{"B", "kB", "MB", "GB", "TB"};
        int digitGroups = (int)(Math.log10(size) / Math.log10(1024.0));
        return new DecimalFormat("#,##0.#").format((double)size / Math.pow(1024.0, digitGroups)) + " " + units[digitGroups];
    }

    private Marker getMarker(int level) {
        switch (level) {
            case 10: {
                return GLOBAL_MARKER;
            }
            case 20: {
                return STEP_MARKER;
            }
            case 30: {
                return OBJECTS_GROUP_MARKER;
            }
            case 40: {
                return OBJECTS_MARKER;
            }
            case 50: {
                return OBJECTS_WARNINGS_MARKER;
            }
        }
        return GLOBAL_MARKER;
    }

    private void log(int level, String message) {
        if (level <= this.progressLogLevel && this.logger != null) {
            this.logger.info(this.getMarker(level), message);
        }
    }

    @FunctionalInterface
    public static interface ProgressLogFunc {
        public void doProgressLog(int var1, String var2);
    }
}

