/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.utils;

import java.nio.file.attribute.FileTime;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;

public final class LocalDateTimeUtil {
    private static final DateTimeFormatter ZONED_DATE_TIME_FORMAT = DateTimeFormatter.ofPattern("yyyy-MM-dd'T'HH:mm[:ss][.SSS][zz]");
    private static final DateTimeFormatter SLASHED_DATE = DateTimeFormatter.ofPattern("dd/MM/yyyy");

    static LocalDateTime parseDateTime(String dateTime) {
        LocalDateTime ldt;
        try {
            ldt = LocalDateTime.parse(dateTime, DateTimeFormatter.ISO_LOCAL_DATE_TIME);
        }
        catch (DateTimeParseException e) {
            try {
                ldt = LocalDateTime.parse(dateTime, ZONED_DATE_TIME_FORMAT);
            }
            catch (DateTimeParseException ex) {
                try {
                    ldt = LocalDate.parse(dateTime, DateTimeFormatter.ISO_DATE).atTime(0, 0, 0, 0);
                }
                catch (DateTimeParseException exc) {
                    ldt = LocalDate.parse(dateTime, SLASHED_DATE).atTime(0, 0, 0, 0);
                }
            }
        }
        return ldt;
    }

    public static String getFormattedDateTime(String dateTime) {
        LocalDateTime ldt = LocalDateTimeUtil.parseDateTime(dateTime);
        return LocalDateTimeUtil.getFormattedDateTime(ldt);
    }

    public static String getFormattedDateTime(LocalDateTime date) {
        return date.format(ZONED_DATE_TIME_FORMAT);
    }

    public static String getFormattedDateTime(FileTime fileTime) {
        LocalDateTime ldt = LocalDateTime.ofInstant(fileTime.toInstant(), ZoneId.systemDefault());
        return LocalDateTimeUtil.getFormattedDateTime(ldt);
    }
}

