/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.utils;

import fr.gouv.vitam.tools.sedalib.droid.DroidIdentifier;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;

public class CompressUtility {
    private static final String MODULE = "sedalib: ";
    public static final String ZIP = "application/zip";
    public static final String TAR = "application/x-tar";
    public static final String XGZIP = "application/x-gzip";
    public static final String GZIP = "application/gzip";
    public static final String BZIP2 = "application/x-bzip2";
    private String encoding;
    private SEDALibProgressLogger sedaLibProgressLogger;
    private Path compressedFilePath;
    private Path uncompressedFolderPath;

    public CompressUtility(Path compressedFilePath, Path uncompressedFolderPath, String encoding, SEDALibProgressLogger sedaLibProgressLogger) {
        this.compressedFilePath = compressedFilePath;
        this.uncompressedFolderPath = uncompressedFolderPath;
        this.encoding = encoding;
        this.sedaLibProgressLogger = sedaLibProgressLogger;
    }

    public static boolean isKnownCompressedMimeType(String mimeType) {
        if (mimeType == null) {
            return false;
        }
        switch (mimeType) {
            case "application/zip": 
            case "application/x-tar": 
            case "application/x-gzip": 
            case "application/gzip": 
            case "application/x-bzip2": {
                return true;
            }
        }
        return false;
    }

    private ArchiveInputStream createArchiveInputStream(Path compressedFilePath) throws SEDALibException, InterruptedException {
        String mimeType;
        FileInputStream fis = null;
        ArchiveInputStream ais = null;
        try {
            IdentificationResult ir = DroidIdentifier.getInstance().getIdentificationResult(compressedFilePath);
            mimeType = ir.getMimeType();
        }
        catch (SEDALibException e) {
            throw new SEDALibException("sedalib: impossible de faire l'identification de format Droid pour le fichier compress\u00e9 [" + compressedFilePath + "]", e);
        }
        try {
            fis = new FileInputStream(compressedFilePath.toFile());
            switch (mimeType) {
                case "application/zip": {
                    ais = new ZipArchiveInputStream(fis, this.encoding);
                    break;
                }
                case "application/x-gzip": 
                case "application/gzip": {
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(fis), this.encoding);
                    break;
                }
                case "application/x-bzip2": {
                    ais = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(fis), this.encoding);
                    break;
                }
                default: {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: format " + mimeType + " de compression inconnu, essai d'utilisation du format tar.", null);
                }
                case "application/x-tar": {
                    ais = new TarArchiveInputStream((InputStream)fis, this.encoding);
                    break;
                }
            }
        }
        catch (IOException e) {
            throw new SEDALibException("sedalib: impossible d'ouvrir le fichier compress\u00e9 [" + compressedFilePath + "]", e);
        }
        return ais;
    }

    public void unCompress() throws SEDALibException, InterruptedException {
        int counter = 0;
        try (ArchiveInputStream archiveInputStream = this.createArchiveInputStream(this.compressedFilePath);){
            Object entry;
            this.uncompressedFolderPath = this.uncompressedFolderPath.toAbsolutePath().normalize();
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                Path target;
                Path parent;
                if (!archiveInputStream.canReadEntryData((ArchiveEntry)entry)) continue;
                String entryName = entry.getName();
                if (entryName.contains("?")) {
                    entryName = entryName.replace("?", "_");
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "Le nom du fichier [" + entryName + "] a un probl\u00e8me d'encodage, le(s) carat\u00e8re(s) probl\u00e9matique \u00e0 \u00e9t\u00e9 rempalc\u00e9 par _ ", null);
                }
                if ((parent = (target = this.uncompressedFolderPath.resolve(entryName)).getParent()) != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 40, "sedalib: d\u00e9compresse le fichier [" + entryName + "]", null);
                    Files.copy(archiveInputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++counter, MODULE + counter + " fichiers extraits");
                    continue;
                }
                if (Files.exists(target, new LinkOption[0])) continue;
                Files.createDirectories(target, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible d'extraire le fichier compress\u00e9 [" + this.compressedFilePath + "]", e);
        }
    }
}

