/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.process;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.Document;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentContainer;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentPack;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.FileObject;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.RecordGrp;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.SubDocument;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.management.Management;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.CompressUtility;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Map;

public class DeCompactor {
    private static final String MODULE = "sedalib: ";
    private static final String TITLE = "Title";
    private DataObjectPackage dataObjectPackage = null;
    private String containerRecordGrpXMLData;
    private ArchiveUnit decompactedRootArchiveUnit;
    private Map<String, ArchiveUnit> treeNodeNameArchiveUnitMap;
    private long expectedDocumentNumber;
    private long expectedFileObjectNumber;
    private long cumulatedPackExpectedDocumentNumber;
    private long cumulatedPackExpectedFileObjectNumber;
    private int archiveUnitCounter;
    private int binaryDataObjectCounter;
    private ArchiveUnit archiveUnit;
    private Path workDirectoryPath;
    private Instant start;
    private Instant end;
    private final SEDALibProgressLogger sedaLibProgressLogger;

    private DeCompactor(SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.decompactedRootArchiveUnit = null;
        this.treeNodeNameArchiveUnitMap = new HashMap<String, ArchiveUnit>();
        this.archiveUnitCounter = 0;
        this.binaryDataObjectCounter = 0;
    }

    public DeCompactor(ArchiveUnit archiveUnit, String workDirectoryName, SEDALibProgressLogger sedaLibProgressLogger) {
        this(sedaLibProgressLogger);
        this.archiveUnit = archiveUnit;
        this.workDirectoryPath = Paths.get(workDirectoryName, new String[0]).toAbsolutePath();
        this.dataObjectPackage = archiveUnit.getDataObjectPackage();
    }

    private RecordGrp extractInformationAndRecordGrpFromDocumentContainer(ArchiveUnit archiveUnit) throws SEDALibException {
        RecordGrp recordGrp = null;
        this.expectedDocumentNumber = 0L;
        this.expectedFileObjectNumber = 0L;
        DocumentContainer documentContainer = (DocumentContainer)archiveUnit.getContent().getFirstNamedMetadata("DocumentContainer");
        if (documentContainer == null) {
            throw new SEDALibException("sedalib: pas de DocumentContainer dans l'ArchiveUnit");
        }
        block10: for (SEDAMetadata sm : documentContainer.getMetadataList()) {
            switch (sm.getXmlElementName()) {
                case "DocumentsCount": {
                    this.expectedDocumentNumber = ((IntegerType)sm).getValue();
                    continue block10;
                }
                case "FileObjectsCount": {
                    this.expectedFileObjectNumber = ((IntegerType)sm).getValue();
                    continue block10;
                }
                case "RecordGrp": {
                    recordGrp = (RecordGrp)sm;
                    continue block10;
                }
            }
            throw new SEDALibException("sedalib:  metadonn\u00e9e [" + sm.getXmlElementName() + "] inattendue dans le DocumentContainer [" + archiveUnit.getInDataObjectPackageId() + "]", null);
        }
        if (recordGrp == null) {
            throw new SEDALibException("sedalib: pas de RecordGrp dans le DocumentContainer de l'ArchiveUnit [" + archiveUnit.getInDataObjectPackageId() + "]", null);
        }
        return recordGrp;
    }

    private ArchiveUnit constructArchiveUnitTree(RecordGrp recordGrp) throws SEDALibException, InterruptedException {
        String nodeName = null;
        ArchiveUnit result = new ArchiveUnit(this.dataObjectPackage);
        block12: for (SEDAMetadata sm : recordGrp.getMetadataList()) {
            switch (sm.getXmlElementName()) {
                case "RecordGrpID": {
                    nodeName = ((StringType)sm).getValue();
                    continue block12;
                }
                case "Management": {
                    result.setManagement((Management)sm);
                    continue block12;
                }
                case "Content": {
                    result.setContent((Content)sm);
                    continue block12;
                }
                case "RecordGrp": {
                    result.addChildArchiveUnit(this.constructArchiveUnitTree((RecordGrp)sm));
                    continue block12;
                }
            }
            throw new SEDALibException("sedalib:  metadonn\u00e9e [" + sm.getXmlElementName() + "] inattendue dans un RecordGrp");
        }
        if (nodeName == null) {
            throw new SEDALibException("sedalib:  manque le nom d'un noeud RecordGrp");
        }
        this.treeNodeNameArchiveUnitMap.put(nodeName, result);
        int counter = this.dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, MODULE + counter + " ArchiveUnit decompact\u00e9es");
        return result;
    }

    private Path extractInformationAndArchiveUnitsFromDocumentPack(ArchiveUnit archiveUnit) throws SEDALibException, InterruptedException {
        RecordGrp recordGrp = null;
        ArrayList<Document> documentList = new ArrayList<Document>();
        long packExpectedDocumentNumber = 0L;
        long packExpectedFileObjectNumber = 0L;
        DocumentPack documentPack = (DocumentPack)archiveUnit.getContent().getFirstNamedMetadata("DocumentPack");
        if (documentPack == null) {
            throw new SEDALibException("sedalib: pas de DocumentPack dans l'ArchiveUnit");
        }
        block12: for (SEDAMetadata sm : documentPack.getMetadataList()) {
            switch (sm.getXmlElementName()) {
                case "DocumentsCount": {
                    packExpectedDocumentNumber = ((IntegerType)sm).getValue();
                    continue block12;
                }
                case "FileObjectsCount": {
                    packExpectedFileObjectNumber = ((IntegerType)sm).getValue();
                    continue block12;
                }
                case "RecordGrp": {
                    recordGrp = (RecordGrp)sm;
                    if (recordGrp.toString().equals(this.containerRecordGrpXMLData)) continue block12;
                    throw new SEDALibException("sedalib:  le RecordGrp du DocumentPack [" + archiveUnit.getInDataObjectPackageId() + "] est inconsistant avec celui du DocumentContainer");
                }
                case "Document": {
                    documentList.add((Document)sm);
                    continue block12;
                }
            }
            throw new SEDALibException("sedalib:  metadonn\u00e9e [" + sm.getXmlElementName() + "] inattendue dans le DocumentPack [" + archiveUnit.getInDataObjectPackageId() + "]", null);
        }
        if (recordGrp == null) {
            throw new SEDALibException("sedalib: pas de RecordGrp dans le DocumentPack de l'ArchiveUnit");
        }
        if ((long)documentList.size() != packExpectedDocumentNumber) {
            SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: le nombre de Documents est incoh\u00e9rent [pr\u00e9vus " + packExpectedDocumentNumber + " trouv\u00e9s " + documentList.size() + "] dans le DocumentPack [" + archiveUnit.getInDataObjectPackageId() + "]", null);
        }
        if (archiveUnit.getContent().getSimpleMetadata(TITLE) == null) {
            throw new SEDALibException("sedalib: pas de Title dans l'ArchiveUnit [" + archiveUnit.getInDataObjectPackageId() + "]");
        }
        Path documentDirPath = this.workDirectoryPath.resolve(archiveUnit.getContent().getSimpleMetadata(TITLE) + "-" + archiveUnit.getInDataObjectPackageId());
        for (Document document : documentList) {
            this.extractArchiveUnitsFromDocument(document, documentDirPath);
        }
        this.cumulatedPackExpectedDocumentNumber += packExpectedDocumentNumber;
        this.cumulatedPackExpectedFileObjectNumber += packExpectedFileObjectNumber;
        return documentDirPath;
    }

    public void extractArchiveUnitsFromDocument(Document document, Path documentDirPath) throws SEDALibException {
        ArchiveUnit treeArchiveUnit;
        String recordGrpID = null;
        ArchiveUnit newArchiveUnit = new ArchiveUnit(this.dataObjectPackage);
        ++this.archiveUnitCounter;
        DataObjectGroup dataObjectGroup = new DataObjectGroup(this.dataObjectPackage, null);
        block14: for (SEDAMetadata sm : document.getMetadataList()) {
            switch (sm.getXmlElementName()) {
                case "RecordGrpID": {
                    recordGrpID = ((StringType)sm).getValue();
                    continue block14;
                }
                case "Content": {
                    newArchiveUnit.setContent((Content)sm);
                    continue block14;
                }
                case "Management": {
                    newArchiveUnit.setManagement((Management)sm);
                    continue block14;
                }
                case "FileObject": {
                    BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage);
                    bdo.setMetadataList(((FileObject)sm).getMetadataList());
                    StringType uri = (StringType)((FileObject)sm).getFirstNamedMetadata("Uri");
                    if (uri != null) {
                        bdo.setOnDiskPath(documentDirPath.resolve(uri.getValue()));
                    }
                    dataObjectGroup.addDataObject(bdo);
                    ++this.binaryDataObjectCounter;
                    continue block14;
                }
                case "SubDocument": {
                    newArchiveUnit.addChildArchiveUnit(this.extractArchiveUnitsFromSubDocument((SubDocument)sm, documentDirPath));
                    continue block14;
                }
            }
            throw new SEDALibException("sedalib:  metadonn\u00e9e [" + sm.getXmlElementName() + "] inattendue dans le Document");
        }
        if (recordGrpID == null) {
            throw new SEDALibException("sedalib:  le document [" + document.getSimpleMetadata(TITLE) + "] n'a pas de lien avec l'arbre de positionnement");
        }
        if (!dataObjectGroup.getBinaryDataObjectList().isEmpty()) {
            newArchiveUnit.addDataObjectById(dataObjectGroup.getInDataObjectPackageId());
        }
        if ((treeArchiveUnit = this.treeNodeNameArchiveUnitMap.get(recordGrpID)) == null) {
            throw new SEDALibException("sedalib: mauvaise r\u00e9f\u00e9rence \u00e0 l'arbre de positionnement du document [" + document.getSimpleMetadata(TITLE) + "]");
        }
        treeArchiveUnit.addChildArchiveUnit(newArchiveUnit);
    }

    public ArchiveUnit extractArchiveUnitsFromSubDocument(SubDocument subDocument, Path documentDirPath) throws SEDALibException {
        ArchiveUnit newArchiveUnit = new ArchiveUnit(this.dataObjectPackage);
        ++this.archiveUnitCounter;
        DataObjectGroup dataObjectGroup = new DataObjectGroup(this.dataObjectPackage, null);
        block12: for (SEDAMetadata sm : subDocument.getMetadataList()) {
            switch (sm.getXmlElementName()) {
                case "Content": {
                    newArchiveUnit.setContent((Content)sm);
                    continue block12;
                }
                case "Management": {
                    newArchiveUnit.setManagement((Management)sm);
                    continue block12;
                }
                case "FileObject": {
                    BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage);
                    bdo.setMetadataList(((FileObject)sm).getMetadataList());
                    StringType uri = (StringType)((FileObject)sm).getFirstNamedMetadata("Uri");
                    if (uri != null) {
                        bdo.setOnDiskPath(documentDirPath.resolve(uri.getValue()));
                    }
                    dataObjectGroup.addDataObject(bdo);
                    ++this.binaryDataObjectCounter;
                    continue block12;
                }
                case "SubDocument": {
                    newArchiveUnit.addChildArchiveUnit(this.extractArchiveUnitsFromSubDocument((SubDocument)sm, documentDirPath));
                    continue block12;
                }
            }
            throw new SEDALibException("sedalib:  metadonn\u00e9e [" + sm.getXmlElementName() + "] inattendue dans le Document");
        }
        if (!dataObjectGroup.getBinaryDataObjectList().isEmpty()) {
            newArchiveUnit.addDataObjectById(dataObjectGroup.getInDataObjectPackageId());
        }
        return newArchiveUnit;
    }

    public ArchiveUnit doDeCompact() throws SEDALibException, InterruptedException {
        try {
            Files.createDirectories(this.workDirectoryPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire de d\u00e9compression des conteneurs [" + this.workDirectoryPath + "] impossible\n->" + e.getMessage());
        }
        Date d = new Date();
        this.start = Instant.now();
        String log = "D\u00e9but du decompactage de l'ArchiveUnit [" + this.archiveUnit.getInDataObjectPackageId() + "]\n";
        log = log + " avec export des fichiers dans le r\u00e9pertoire [" + this.workDirectoryPath + "]\n";
        log = log + " date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, log, null);
        this.archiveUnitCounter = 0;
        this.binaryDataObjectCounter = 0;
        this.cumulatedPackExpectedDocumentNumber = 0L;
        this.cumulatedPackExpectedFileObjectNumber = 0L;
        this.dataObjectPackage.resetInOutCounter();
        RecordGrp tree = this.extractInformationAndRecordGrpFromDocumentContainer(this.archiveUnit);
        this.containerRecordGrpXMLData = tree.toString();
        this.decompactedRootArchiveUnit = this.constructArchiveUnitTree(tree);
        this.containerRecordGrpXMLData = tree.toString();
        for (ArchiveUnit packAU : this.archiveUnit.getChildrenAuList().getArchiveUnitList()) {
            Path packDirPath = this.extractInformationAndArchiveUnitsFromDocumentPack(packAU);
            if (packAU.getTheDataObjectGroup() == null || packAU.getTheDataObjectGroup().getBinaryDataObjectList().isEmpty()) {
                throw new SEDALibException("sedalib: pas de fichier \u00e0 d\u00e9compresser dans l'ArchiveUnit du DocumentPack [" + packAU.getInDataObjectPackageId() + "]");
            }
            CompressUtility compressUtility = new CompressUtility(packAU.getTheDataObjectGroup().getBinaryDataObjectList().get(0).getOnDiskPath(), packDirPath, "UTF-8", this.sedaLibProgressLogger);
            compressUtility.unCompress();
        }
        if (this.cumulatedPackExpectedDocumentNumber != this.expectedDocumentNumber) {
            SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib:  Erreur: le nombre de documents d\u00e9compact\u00e9s n'est pas celui pr\u00e9vu dans le DocumentContainer", null);
        }
        if (this.cumulatedPackExpectedFileObjectNumber != this.expectedFileObjectNumber) {
            SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib:  Erreur: le nombre de fichiers d\u00e9compact\u00e9s n'est pas celui pr\u00e9vu dans le DocumentContainer", null);
        }
        this.dataObjectPackage.replaceArchiveUnitBy(this.archiveUnit, this.decompactedRootArchiveUnit);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: compactage d'une ArchiveUnit termin\u00e9e.", null);
        this.end = Instant.now();
        return this.decompactedRootArchiveUnit;
    }

    public String getSummary() {
        String result = "Decompactage de l'ArchiveUnit [" + this.archiveUnit.getInDataObjectPackageId() + "]\n";
        result = result + "  avec " + this.expectedDocumentNumber + " documents et " + this.expectedFileObjectNumber + " fichiers\n";
        result = result + "  d\u00e9velopp\u00e9 en " + this.archiveUnitCounter + " ArchiveUnit(s) et " + this.binaryDataObjectCounter + " BinaryDataObjects\n";
        if (this.start != null && this.end != null) {
            result = result + "effectu\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

