/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.process;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.Document;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentContainer;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentPack;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.FileObject;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.RecordGrp;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.SubDocument;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.TextType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.compress.archivers.tar.TarArchiveEntry;
import org.apache.commons.compress.archivers.tar.TarArchiveOutputStream;
import org.apache.commons.io.IOUtils;

public class Compactor {
    private static final String MODULE = "sedalib: ";
    private static final String EXPORTED_DOCUMENTS = " documents export\u00e9s";
    private static final String DESCRIPTION_LEVEL = "DescriptionLevel";
    private static final String TITLE = "Title";
    private DataObjectPackage dataObjectPackage = null;
    private RecordGrp rootRecordGrp;
    private List<Document> documentsList;
    private Map<Document, List<CompactedFile>> compactedFileListMap;
    private List<String> documentObjectVersionFilter;
    private Map<String, Integer> documentContentMetadataFilter;
    private List<String> subDocumentObjectVersionFilter;
    private Map<String, Integer> subDocumentContentMetadataFilter;
    private int packMaxDocumentNumber;
    private int packDocumentsMaxMetadataSize;
    private boolean deflatedFlag;
    private int treenodeCounter;
    private int documentCounter;
    private int localSubDocumentCounter;
    private int totalSubDocumentCounter;
    private int fileCounter;
    private int treenodeWithDroppedNotDesciptiveMetadata;
    private int treenodeWithDroppedFile;
    private int leafWithDroppedFile;
    private int droppedMetadataCounted;
    private int truncatedMetadataCounted;
    private int packCounter;
    private ArchiveUnit archiveUnit;
    private String workDirectoryName;
    private Instant start;
    private Instant end;
    private final SEDALibProgressLogger sedaLibProgressLogger;

    private Compactor(SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.documentObjectVersionFilter = null;
        this.documentContentMetadataFilter = null;
        this.subDocumentObjectVersionFilter = null;
        this.subDocumentContentMetadataFilter = null;
        this.rootRecordGrp = null;
        this.documentsList = null;
        this.compactedFileListMap = null;
        this.treenodeCounter = 0;
        this.documentCounter = 0;
        this.fileCounter = 0;
        this.localSubDocumentCounter = 0;
        this.totalSubDocumentCounter = 0;
        this.leafWithDroppedFile = 0;
        this.droppedMetadataCounted = 0;
        this.truncatedMetadataCounted = 0;
        this.packCounter = 0;
        this.deflatedFlag = false;
    }

    public Compactor(ArchiveUnit archiveUnit, String workDirectoryName, SEDALibProgressLogger sedaLibProgressLogger) {
        this(sedaLibProgressLogger);
        this.archiveUnit = archiveUnit;
        this.workDirectoryName = workDirectoryName;
        this.dataObjectPackage = archiveUnit.getDataObjectPackage();
    }

    public void setCompactedDocumentPackLimit(int packDocumentsMaxMetadataSize, int packMaxDocumentNumber) {
        this.packDocumentsMaxMetadataSize = packDocumentsMaxMetadataSize;
        this.packMaxDocumentNumber = packMaxDocumentNumber;
    }

    public void setObjectVersionFilters(List<String> documentObjectVersionFilter, List<String> subDocumentObjectVersionFilter) {
        this.documentObjectVersionFilter = documentObjectVersionFilter;
        this.subDocumentObjectVersionFilter = subDocumentObjectVersionFilter;
    }

    public void setMetadataFilters(Map<String, Integer> documentContentMetadataFilter, Map<String, Integer> subDocumentContentMetadataFilter) {
        this.documentContentMetadataFilter = documentContentMetadataFilter;
        this.subDocumentContentMetadataFilter = subDocumentContentMetadataFilter;
    }

    public boolean isDeflatedFlag() {
        return this.deflatedFlag;
    }

    public void setDeflatedFlag(boolean deflatedFlag) {
        this.deflatedFlag = deflatedFlag;
    }

    private static String getExtension(String fileName) {
        if (fileName == null) {
            return "";
        }
        int i = fileName.lastIndexOf(46);
        return i < 0 ? "" : fileName.substring(i + 1);
    }

    private static String getExtendedCompactedFileName(String radical, Path onDiskPath) {
        String extension = Compactor.getExtension(onDiskPath.getFileName().toString());
        if (!extension.isEmpty()) {
            return radical + "." + extension;
        }
        return radical;
    }

    private SEDAMetadata truncateTextType(SEDAMetadata sm, int limit) throws SEDALibException {
        if (sm instanceof TextType && ((TextType)sm).getValue().length() > limit) {
            sm = new TextType(sm.getXmlElementName(), ((TextType)sm).getValue().substring(0, limit), ((TextType)sm).getLang());
            ++this.truncatedMetadataCounted;
        }
        if (sm instanceof StringType) {
            if (((StringType)sm).getValue().length() > limit) {
                sm = new TextType(sm.getXmlElementName(), ((StringType)sm).getValue().substring(0, limit));
                ++this.truncatedMetadataCounted;
            }
        } else {
            throw new SEDALibException("Tentative pendant le compactage de troncature d'une m\u00e9tadonn\u00e9e [" + sm.getXmlElementName() + "] qui n'est pas de type TextType ou StringType");
        }
        return sm;
    }

    private Content copyAllSEDAMetadata(Content originContent, Content destContent) {
        destContent.getMetadataList().addAll(originContent.getMetadataList());
        return destContent;
    }

    private Content filterContentMetadata(boolean documentFlag, Content originContent) throws SEDALibException {
        Map<String, Integer> contentMetadataFilter;
        Content resultContent = new Content();
        Map<String, Integer> map = contentMetadataFilter = documentFlag ? this.documentContentMetadataFilter : this.subDocumentContentMetadataFilter;
        if (contentMetadataFilter == null) {
            this.copyAllSEDAMetadata(originContent, resultContent);
        } else {
            for (SEDAMetadata sm : originContent.getMetadataList()) {
                Integer limit = contentMetadataFilter.get(sm.getXmlElementName());
                if (limit != null) {
                    if (limit == 0) {
                        resultContent.getMetadataList().add(sm);
                        continue;
                    }
                    resultContent.getMetadataList().add(this.truncateTextType(sm, limit));
                    continue;
                }
                ++this.droppedMetadataCounted;
            }
        }
        return resultContent;
    }

    private SubDocument getCompactedSubDocumentArchiveUnit(ArchiveUnit au, String parentAuURI, List<CompactedFile> compactedFilesList) throws SEDALibException {
        SubDocument subDocument = new SubDocument(this.filterContentMetadata(false, au.getContent()));
        String auURI = parentAuURI + File.separator + "SubDocument" + this.localSubDocumentCounter;
        ++this.localSubDocumentCounter;
        if (au.getTheDataObjectGroup() != null) {
            for (BinaryDataObject bdo : au.getTheDataObjectGroup().getBinaryDataObjectList()) {
                StringType dataObjectVersion = bdo.getMetadataDataObjectVersion();
                String radical = dataObjectVersion.getValue().split("_")[0];
                if (this.subDocumentObjectVersionFilter.contains(radical)) {
                    String compactedFileURI = Compactor.getExtendedCompactedFileName(auURI + "-" + dataObjectVersion.getValue(), bdo.getOnDiskPath());
                    subDocument.addMetadata(new FileObject(bdo, compactedFileURI));
                    compactedFilesList.add(new CompactedFile(compactedFileURI, bdo.getOnDiskPath()));
                    continue;
                }
                ++this.leafWithDroppedFile;
            }
        }
        for (ArchiveUnit auChild : au.getChildrenAuList().getArchiveUnitList()) {
            subDocument.addMetadata(this.getCompactedSubDocumentArchiveUnit(auChild, auURI, compactedFilesList));
        }
        ++this.totalSubDocumentCounter;
        return subDocument;
    }

    private Document getCompactedDocumentArchiveUnit(ArchiveUnit au, RecordGrp parentRecordGrp) throws SEDALibException {
        ArrayList<CompactedFile> compactedFileList = new ArrayList<CompactedFile>();
        String parentRecordGrpID = parentRecordGrp.getSimpleMetadata("RecordGrpID");
        Document document = new Document(parentRecordGrpID, this.filterContentMetadata(true, au.getContent()));
        String auURI = parentRecordGrpID + "-Document" + this.documentCounter;
        if (au.getTheDataObjectGroup() != null) {
            for (BinaryDataObject bdo : au.getTheDataObjectGroup().getBinaryDataObjectList()) {
                StringType dataObjectVersion = bdo.getMetadataDataObjectVersion();
                String radical = dataObjectVersion.getValue().split("_")[0];
                if (this.documentObjectVersionFilter.contains(radical)) {
                    String compactedFileURI = Compactor.getExtendedCompactedFileName(auURI + "-" + dataObjectVersion.getValue(), bdo.getOnDiskPath());
                    document.addMetadata(new FileObject(bdo, compactedFileURI));
                    compactedFileList.add(new CompactedFile(compactedFileURI, bdo.getOnDiskPath()));
                    continue;
                }
                ++this.leafWithDroppedFile;
            }
        }
        this.localSubDocumentCounter = 1;
        for (ArchiveUnit auChild : au.getChildrenAuList().getArchiveUnitList()) {
            document.addMetadata(this.getCompactedSubDocumentArchiveUnit(auChild, auURI, compactedFileList));
        }
        ++this.documentCounter;
        this.compactedFileListMap.put(document, compactedFileList);
        this.fileCounter += compactedFileList.size();
        return document;
    }

    private RecordGrp addTreeNodeChild(ArchiveUnit au, RecordGrp parentRecordGrp) throws SEDALibException {
        RecordGrp curRecordGrp = new RecordGrp("Node" + this.treenodeCounter, au.getContent(), au.getManagement());
        if (parentRecordGrp == null) {
            this.rootRecordGrp = curRecordGrp;
        } else {
            parentRecordGrp.addMetadata(curRecordGrp);
        }
        if (!au.getDataObjectRefList().getDataObjectList().isEmpty()) {
            ++this.treenodeWithDroppedFile;
        }
        return curRecordGrp;
    }

    private void recurseCompactArchiveUnit(ArchiveUnit au, RecordGrp parentRecordGrp) throws SEDALibException, InterruptedException {
        if (this.dataObjectPackage.isTouchedInDataObjectPackageId(au.getInDataObjectPackageId())) {
            return;
        }
        this.dataObjectPackage.addTouchedInDataObjectPackageId(au.getInDataObjectPackageId());
        String descriptionLevel = au.getContent().getSimpleMetadata(DESCRIPTION_LEVEL);
        if (!"Item".equals(descriptionLevel)) {
            ++this.treenodeCounter;
            RecordGrp curRecordGrp = this.addTreeNodeChild(au, parentRecordGrp);
            if (au.getManagement() != null || au.getArchiveUnitProfile() != null) {
                ++this.treenodeWithDroppedNotDesciptiveMetadata;
            }
            for (ArchiveUnit auChild : au.getChildrenAuList().getArchiveUnitList()) {
                this.recurseCompactArchiveUnit(auChild, curRecordGrp);
            }
        } else {
            this.documentsList.add(this.getCompactedDocumentArchiveUnit(au, parentRecordGrp));
        }
        int counter = this.dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, MODULE + counter + " ArchiveUnit compact\u00e9es");
    }

    private Path createDocumentPackArchiveFile(int packCount, List<CompactedFile> compactedFileList) throws SEDALibException {
        Path archiveFile;
        block28: {
            archiveFile = Paths.get(this.workDirectoryName, new String[0]).toAbsolutePath().resolve("Document" + packCount + (this.deflatedFlag ? ".zip" : ".tar"));
            if (this.deflatedFlag) {
                try (ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(archiveFile.toString()));){
                    for (CompactedFile compactedFile : compactedFileList) {
                        ZipEntry e = new ZipEntry(compactedFile.compactedFilename);
                        zipout.putNextEntry(e);
                        try (FileInputStream fis = new FileInputStream(compactedFile.onDiskPath.toFile());){
                            IOUtils.copy((InputStream)fis, (OutputStream)zipout);
                        }
                        zipout.closeEntry();
                    }
                    break block28;
                }
                catch (IOException e) {
                    throw new SEDALibException("Echec de l'export du fichier du paquet de documents [" + archiveFile + "]", e);
                }
            }
            try (TarArchiveOutputStream tarOut = new TarArchiveOutputStream(new FileOutputStream(archiveFile.toString()));){
                for (CompactedFile compactedFile : compactedFileList) {
                    TarArchiveEntry e = new TarArchiveEntry(compactedFile.onDiskPath.toFile(), compactedFile.compactedFilename);
                    tarOut.putArchiveEntry(e);
                    try (FileInputStream fis = new FileInputStream(compactedFile.onDiskPath.toFile());){
                        IOUtils.copy((InputStream)fis, (OutputStream)tarOut);
                    }
                    tarOut.closeArchiveEntry();
                }
            }
            catch (IOException e) {
                throw new SEDALibException("Echec de l'export du fichier du paquet de documents [" + archiveFile + "]", e);
            }
        }
        return archiveFile;
    }

    private void addDocumentPackArchiveUnit(ArchiveUnit rootContainerAU, DocumentPack documentPack, int documentCount, List<CompactedFile> compactedFileList, int packCount) throws SEDALibException, InterruptedException {
        documentPack.addNewMetadata("DocumentsCount", documentCount);
        documentPack.addNewMetadata("FileObjectsCount", compactedFileList.size());
        Path documentPackFilePath = this.createDocumentPackArchiveFile(packCount, compactedFileList);
        ArchiveUnit packAu = new ArchiveUnit(this.dataObjectPackage);
        Content curContent = new Content();
        curContent.addNewMetadata(DESCRIPTION_LEVEL, "Item");
        curContent.addNewMetadata(TITLE, "DocumentPack" + packCount);
        curContent.addMetadata(documentPack);
        packAu.setContent(curContent);
        DataObjectGroup dog = new DataObjectGroup(this.dataObjectPackage, null);
        BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage, documentPackFilePath, documentPackFilePath.getFileName().toString(), "BinaryMaster_1");
        bdo.extractTechnicalElements(null);
        dog.addDataObject(bdo);
        packAu.addDataObjectById(dog.getInDataObjectPackageId());
        rootContainerAU.addChildArchiveUnit(packAu);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, "  Paquet n\u00b0" + packCount + " finalis\u00e9", null);
    }

    public ArchiveUnit doCompact() throws SEDALibException, InterruptedException {
        Path exportPath = Paths.get(this.workDirectoryName, new String[0]).toAbsolutePath();
        try {
            Files.createDirectories(exportPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire de cr\u00e9ation des conteneurs [" + exportPath + "] impossible\n->" + e.getMessage());
        }
        Date d = new Date();
        this.start = Instant.now();
        String log = "D\u00e9but du compactage de l'ArchiveUnit [" + this.archiveUnit.getInDataObjectPackageId() + "]\n";
        log = log + " avec export des conteneurs dans le r\u00e9pertoire [" + exportPath + "]\n";
        log = log + " date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, log, null);
        this.documentsList = new ArrayList<Document>();
        this.compactedFileListMap = new HashMap<Document, List<CompactedFile>>();
        this.dataObjectPackage.resetTouchedInDataObjectPackageIdMap();
        this.dataObjectPackage.resetInOutCounter();
        if (this.archiveUnit.getContent().getSimpleMetadata(DESCRIPTION_LEVEL).equals("Item")) {
            throw new SEDALibException("Impossible de compacter l'ArchiveUnit \u00e0 la racine est un Item");
        }
        this.recurseCompactArchiveUnit(this.archiveUnit, null);
        ArchiveUnit rootContainerAU = new ArchiveUnit(this.dataObjectPackage);
        Content curContent = new Content();
        curContent.addNewMetadata(DESCRIPTION_LEVEL, "RecordGrp");
        curContent.addNewMetadata(TITLE, this.archiveUnit.getContent().getSimpleMetadata(TITLE));
        DocumentContainer documentContainer = new DocumentContainer(this.documentCounter, this.fileCounter, this.rootRecordGrp);
        curContent.addMetadata(documentContainer);
        rootContainerAU.setContent(curContent);
        DocumentPack documentPack = new DocumentPack(this.rootRecordGrp);
        int documentCount = 0;
        int totalDocumentCount = 0;
        int metadataSize = documentPack.toString().length() + 100;
        this.packCounter = 1;
        ArrayList<CompactedFile> compactedFileList = new ArrayList<CompactedFile>();
        for (Document doc : this.documentsList) {
            String xmlString = doc.toString();
            if ((metadataSize = (int)((long)metadataSize + ((long)xmlString.length() + xmlString.lines().count() * 4L))) > this.packDocumentsMaxMetadataSize && documentCount != 0 || documentCount >= this.packMaxDocumentNumber) {
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, MODULE + totalDocumentCount + EXPORTED_DOCUMENTS, null);
                this.addDocumentPackArchiveUnit(rootContainerAU, documentPack, documentCount, compactedFileList, this.packCounter);
                documentPack = new DocumentPack(this.rootRecordGrp);
                documentCount = 0;
                compactedFileList.clear();
                metadataSize = documentPack.toString().length() + 100;
                ++this.packCounter;
            }
            documentPack.addMetadata(doc);
            compactedFileList.addAll((Collection<CompactedFile>)this.compactedFileListMap.get(doc));
            ++documentCount;
            SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++totalDocumentCount, MODULE + totalDocumentCount + EXPORTED_DOCUMENTS);
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, MODULE + totalDocumentCount + EXPORTED_DOCUMENTS, null);
        this.addDocumentPackArchiveUnit(rootContainerAU, documentPack, documentCount, compactedFileList, this.packCounter);
        this.dataObjectPackage.replaceArchiveUnitBy(this.archiveUnit, rootContainerAU);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: compactage d'une ArchiveUnit termin\u00e9e.", null);
        this.end = Instant.now();
        return rootContainerAU;
    }

    public String getSummary() {
        String result = "Compactage de l'ArchiveUnit [" + this.archiveUnit.getInDataObjectPackageId() + "]\n";
        result = result + "  avec " + this.treenodeCounter + " noeuds dans l'arbre de classement, ";
        result = result + this.documentCounter + " documents et ";
        result = result + this.totalSubDocumentCounter + " sous-documents\n";
        result = result + "  dans " + this.packCounter + " paquets de documents\n";
        if (this.treenodeWithDroppedNotDesciptiveMetadata + this.treenodeWithDroppedFile + this.leafWithDroppedFile > 0) {
            result = result + "  avec\n";
        }
        if (this.treenodeWithDroppedNotDesciptiveMetadata != 0) {
            result = result + "  - " + this.treenodeWithDroppedNotDesciptiveMetadata + " noeuds dans l'arbre de classement dont des m\u00e9tadonn\u00e9es non descriptives ont \u00e9t\u00e9 \u00e9limin\u00e9es\n";
        }
        if (this.treenodeWithDroppedFile != 0) {
            result = result + "  - " + this.treenodeWithDroppedFile + " noeuds dans l'arbre de classement dont des objets ont \u00e9t\u00e9 \u00e9limin\u00e9s\n";
        }
        if (this.leafWithDroppedFile != 0) {
            result = result + "  - " + this.leafWithDroppedFile + " documents ou sous-documents dont des objets ont \u00e9t\u00e9 \u00e9limin\u00e9s\n";
        }
        if (this.droppedMetadataCounted != 0) {
            result = result + "  - " + this.droppedMetadataCounted + " metadonn\u00e9es de premier rang qui ont \u00e9t\u00e9 \u00e9limin\u00e9s\n";
        }
        if (this.truncatedMetadataCounted != 0) {
            result = result + "  - " + this.truncatedMetadataCounted + " metadonn\u00e9es de premier rang qui ont \u00e9t\u00e9 tronqu\u00e9es\n";
        }
        if (this.start != null && this.end != null) {
            result = result + "effectu\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }

    static class CompactedFile {
        String compactedFilename;
        Path onDiskPath;

        CompactedFile(String compactedFilename, Path onDiskPath) {
            this.compactedFilename = compactedFilename;
            this.onDiskPath = onDiskPath;
        }
    }
}

