/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class TextType
extends NamedTypeMetadata {
    private String value;
    private String lang;

    public TextType() {
        this(null, null, null);
    }

    public TextType(String elementName) {
        this(elementName, null, null);
    }

    public TextType(String elementName, String value) {
        this(elementName, value, null);
    }

    public TextType(String elementName, String value, String lang) {
        super(elementName);
        this.value = value;
        this.lang = lang;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartElement(this.elementName);
            if (this.lang != null) {
                xmlWriter.writeAttribute("xml:lang", this.lang);
            }
            xmlWriter.writeCharactersIfNotEmpty(this.value);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type TextType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.value != null) {
            result.put("", this.value);
            if (this.lang != null) {
                result.put("attr", "xml:lang=\"" + this.lang + "\"");
            }
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block6: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    this.lang = xmlReader.peekAttribute("http://www.w3.org/XML/1998/namespace", "lang");
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        this.value = event.asCharacters().getData();
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = "";
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block6;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type TextType", e);
            }
        }
        return true;
    }

    public String getLang() {
        return this.lang;
    }

    @Override
    @JsonIgnore(value=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

