/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.content.Rule;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.RuleMetadataKind;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.xml.stream.XMLStreamException;

public abstract class RuleType
extends ComplexListType {
    public static final String RULE_TAG = "Rule";
    public static final String PREVENTINHERITANCE_TAG = "PreventInheritance";
    public static final String REFNONRULEID_TAG = "RefNonRuleId";
    public static final String FINALACTION_TAG = "FinalAction";

    public RuleType(String elementName) {
        super(elementName);
    }

    public RuleType(String elementName, String rule, LocalDate startDate) throws SEDALibException {
        super(elementName);
        this.addNewMetadata(RULE_TAG, rule, startDate);
    }

    public void addRule(String rule) throws SEDALibException {
        this.addNewMetadata(RULE_TAG, rule, null);
    }

    public void addRule(String rule, LocalDate startDate) throws SEDALibException {
        this.addNewMetadata(RULE_TAG, rule, startDate);
    }

    public void setPreventInheritance(boolean preventInheritance) throws SEDALibException {
        this.addNewMetadata(PREVENTINHERITANCE_TAG, preventInheritance);
    }

    public void addRefNonRuleId(String rule) throws SEDALibException {
        this.addNewMetadata(REFNONRULEID_TAG, rule);
    }

    public void setFinalAction(String finalAction) throws SEDALibException {
        List<String> finalValues = this.getFinalActionList();
        if (finalValues == null) {
            throw new SEDALibException("Le type de r\u00e8gle [" + this.elementName + "] n'a pas de FinalAction");
        }
        if (!finalValues.contains(finalAction)) {
            throw new SEDALibException("Le type de r\u00e8gle [" + this.elementName + "] n'accepte pas la FinalAction [" + finalAction + "]");
        }
        this.addNewMetadata(FINALACTION_TAG, finalAction);
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String previousXMLElementName = null;
        int count = 0;
        int ruleElementCount = -1;
        for (SEDAMetadata sm : this.metadataList) {
            Object addedName;
            LinkedHashMap<String, String> smCsvList;
            if (sm instanceof Rule) {
                smCsvList = ((Rule)sm).toCsvList(++ruleElementCount);
                result.putAll(smCsvList);
                continue;
            }
            if (this.getRuleMetadataKindList().contains(sm.getXmlElementName())) {
                smCsvList = sm.toCsvList();
                addedName = sm.getXmlElementName() + "." + ruleElementCount;
                smCsvList.forEach((arg_0, arg_1) -> RuleType.lambda$toCsvList$0(result, (String)addedName, arg_0, arg_1));
                continue;
            }
            if (!sm.getXmlElementName().equals(previousXMLElementName)) {
                previousXMLElementName = sm.getXmlElementName();
                count = 0;
            } else {
                ++count;
            }
            addedName = this.isAMultiValuedMetadata(sm.getXmlElementName()) ? sm.getXmlElementName() + "." + count : sm.getXmlElementName();
            smCsvList = sm.toCsvList();
            smCsvList.forEach((arg_0, arg_1) -> RuleType.lambda$toCsvList$1(result, (String)addedName, arg_0, arg_1));
        }
        return result;
    }

    public List<String> getFinalActionList() {
        return null;
    }

    @Override
    public void addMetadata(SEDAMetadata sedaMetadata) throws SEDALibException {
        boolean manyFlag;
        int addOrderIndex = this.indexOfMetadata(sedaMetadata.getXmlElementName());
        int i = 0;
        boolean setFlag = false;
        if (addOrderIndex == -1) {
            if (this.isNotExpandable()) {
                throw new SEDALibException("Impossible d'\u00e9tendre le sch\u00e9ma avec des m\u00e9tadonn\u00e9es non pr\u00e9vues [" + this.elementName + "]");
            }
            manyFlag = true;
            boolean noBeforeEqual = true;
            for (SEDAMetadata sm : this.metadataList) {
                if (sm.getXmlElementName().equals(sedaMetadata.getXmlElementName()) && noBeforeEqual) {
                    noBeforeEqual = false;
                }
                if (sm.getXmlElementName().equals(sedaMetadata.getXmlElementName()) || noBeforeEqual) {
                    ++i;
                    continue;
                }
                break;
            }
        } else {
            manyFlag = this.getMetadataMap().get(sedaMetadata.getXmlElementName()).isMany();
            int lastRuleIndex = this.findLastRuleIndex();
            for (SEDAMetadata sm : this.metadataList.subList(lastRuleIndex, this.metadataList.size())) {
                if (this.getMetadataMap().get(sm.getXmlElementName()) instanceof RuleMetadataKind) {
                    ++i;
                    continue;
                }
                int curOrderIndex = this.indexOfMetadata(sm.getXmlElementName());
                if (!manyFlag && curOrderIndex == addOrderIndex) {
                    setFlag = true;
                    break;
                }
                if (curOrderIndex == -1 || curOrderIndex > addOrderIndex) break;
                ++i;
            }
            i += lastRuleIndex;
        }
        if (manyFlag) {
            this.metadataList.add(i, sedaMetadata);
        } else if (setFlag) {
            this.metadataList.set(i, sedaMetadata);
        } else {
            this.metadataList.add(i, sedaMetadata);
        }
    }

    private int findLastRuleIndex() {
        for (int i = this.metadataList.size(); i > 0; --i) {
            SEDAMetadata item = (SEDAMetadata)this.metadataList.get(i - 1);
            if (!item.getXmlElementName().equals(RULE_TAG)) continue;
            return i;
        }
        return 0;
    }

    public List<String> getRuleMetadataKindList() throws SEDALibException {
        return this.getMetadataMap().entrySet().stream().filter(e -> e.getValue() instanceof RuleMetadataKind).map(Map.Entry::getKey).collect(Collectors.toList());
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            if (xmlReader.nextBlockIfNamed(this.elementName)) {
                String tmp = xmlReader.peekName();
                while (tmp != null) {
                    Class<Object> metadataClass;
                    ComplexListMetadataKind mi = this.getMetadataMap().get(tmp);
                    if (mi == null) {
                        if (this.isNotExpandable()) {
                            throw new SEDALibException("Impossible d'\u00e9tendre le sch\u00e9ma avec des m\u00e9tadonn\u00e9es non pr\u00e9vues [" + tmp + "]");
                        }
                        metadataClass = AnyXMLType.class;
                    } else {
                        metadataClass = mi.getMetadataClass();
                    }
                    SEDAMetadata sm = SEDAMetadata.fromSedaXml(xmlReader, metadataClass);
                    this.addMetadata(sm);
                    tmp = xmlReader.peekName();
                }
            } else {
                return false;
            }
            xmlReader.endBlockNamed(this.elementName);
        }
        catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment [" + this.elementName + "]", e);
        }
        return true;
    }

    private static /* synthetic */ void lambda$toCsvList$1(LinkedHashMap result, String addedName, String key, String value) {
        result.put(addedName + (String)(key.isEmpty() ? "" : "." + key), value);
    }

    private static /* synthetic */ void lambda$toCsvList$0(LinkedHashMap result, String addedName, String key, String value) {
        result.put(addedName + (String)(key.isEmpty() ? "" : "." + key), value);
    }
}

