/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class IntegerType
extends NamedTypeMetadata {
    private Long value;

    public IntegerType() {
        this(null, (Long)null);
    }

    public IntegerType(String elementName) {
        this(elementName, (Long)null);
    }

    public IntegerType(String elementName, Long value) {
        super(elementName);
        this.value = value;
    }

    public IntegerType(String elementName, int value) {
        super(elementName);
        this.value = value;
    }

    public IntegerType(String elementName, Object[] args) throws SEDALibException {
        super(elementName);
        if (args.length != 1 || !(args[0] instanceof Integer)) {
            throw new SEDALibException("Mauvais constructeur de l'\u00e9l\u00e9ment [" + elementName + "]");
        }
        this.value = (Long)args[0];
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeElementValue(this.elementName, this.value == null ? "" : Long.toString(this.value));
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type IntegerType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("", this.value == null ? "" : Long.toString(this.value));
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block5: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (!event.isCharacters()) {
                        throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type IntegerType qui est vide");
                    }
                    String tmp = event.asCharacters().getData();
                    this.value = tmp == null || tmp.isEmpty() ? null : Long.valueOf(Long.parseLong(tmp));
                    event = xmlReader.nextUsefullEvent();
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block5;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type IntegerType", e);
            }
        }
        return true;
    }

    @Override
    @JsonIgnore(value=false)
    public Long getValue() {
        return this.value;
    }

    public void setValue(Long value) {
        this.value = value;
    }
}

