/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.EnumTypeConstants;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class EnumType
extends NamedTypeMetadata {
    private String value;
    private String enumValues;

    public EnumType() throws SEDALibException {
        this(null, null);
    }

    public EnumType(String elementName) throws SEDALibException {
        this(elementName, null);
    }

    public EnumType(String elementName, String value) throws SEDALibException {
        super(elementName);
        List<String> enumValues = EnumTypeConstants.enumListMap.get(elementName);
        if (enumValues == null) {
            throw new SEDALibException("Type Enum\u00e9r\u00e9 [" + elementName + "] inconnu");
        }
        if (value == null) {
            this.value = "";
        } else if (value.isEmpty() || enumValues.contains(value)) {
            this.value = value;
        } else {
            throw new SEDALibException("Valeur interdite [" + value + "] dans un \u00e9l\u00e9ment [" + elementName + "]");
        }
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeElementValue(this.elementName, this.value);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type KeywordType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("", this.value);
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block8: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        this.value = event.asCharacters().getData();
                        List<String> enumValues = EnumTypeConstants.enumListMap.get(this.elementName);
                        if (enumValues == null) {
                            throw new SEDALibException("Type Enum\u00e9r\u00e9 [" + this.elementName + "] inconnu");
                        }
                        if (!enumValues.contains(this.value)) {
                            throw new SEDALibException("Valeur interdite dans un \u00e9l\u00e9ment [" + this.elementName + "]");
                        }
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = "";
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block8;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type KeywordType", e);
            }
        }
        return true;
    }

    @Override
    @JsonIgnore(value=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) throws SEDALibException {
        List<String> enumValues = EnumTypeConstants.enumListMap.get(this.elementName);
        if (enumValues == null) {
            throw new SEDALibException("Type Enum\u00e9r\u00e9 [" + this.elementName + "] inconnu");
        }
        if (value == null) {
            this.value = "";
        } else if (value.isEmpty() || enumValues.contains(value)) {
            this.value = value;
        } else {
            throw new SEDALibException("Valeur interdite dans un \u00e9l\u00e9ment [" + this.elementName + "]");
        }
    }
}

