/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class DigestType
extends NamedTypeMetadata {
    private String value;
    private String algorithm;

    public DigestType() {
        this(null, null, null);
    }

    public DigestType(String elementName) {
        this(elementName, null, null);
    }

    public DigestType(String elementName, String value) {
        this(elementName, value, null);
    }

    public DigestType(String elementName, String value, String algorithm) {
        super(elementName);
        this.value = value;
        this.algorithm = algorithm;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartElement(this.elementName);
            if (this.algorithm != null) {
                xmlWriter.writeAttribute("algorithm", this.algorithm);
            }
            xmlWriter.writeCharactersIfNotEmpty(this.value);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type DigestType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.value != null) {
            result.put("", this.value);
            if (this.algorithm != null) {
                result.put("attr", "algorithm=\"" + this.algorithm + "\"");
            }
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block6: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    this.algorithm = xmlReader.peekAttribute("algorithm");
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        this.value = event.asCharacters().getData();
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = "";
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block6;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type DigestType", e);
            }
        }
        return true;
    }

    public String getAlgorithm() {
        return this.algorithm;
    }

    @Override
    @JsonIgnore(value=false)
    public String getValue() {
        return this.value;
    }

    public void setValue(String value) {
        this.value = value;
    }

    public void setAlgorithm(String algorithm) {
        this.algorithm = algorithm;
    }
}

