/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class DateType
extends NamedTypeMetadata {
    private LocalDate value;

    public DateType() {
        this(null, (LocalDate)null);
    }

    public DateType(String elementName) {
        this(elementName, (LocalDate)null);
    }

    public DateType(String elementName, LocalDate value) {
        super(elementName);
        this.value = value;
    }

    public DateType(String elementName, String dateString) throws SEDALibException {
        super(elementName);
        try {
            this.value = SEDAXMLEventReader.getDateFromString(dateString);
        }
        catch (DateTimeParseException e) {
            throw new SEDALibException("Probl\u00e8me de formatage de date \u00e0 la cr\u00e9ation d'un \u00e9l\u00e9ment [" + elementName + "]");
        }
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            if (this.value == null) {
                xmlWriter.writeElementValue(this.elementName, null);
            } else {
                xmlWriter.writeElementValue(this.elementName, SEDAXMLStreamWriter.getStringFromDate(this.value));
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type DateTimeType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.value != null) {
            result.put("", SEDAXMLStreamWriter.getStringFromDate(this.value));
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block8: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    this.elementName = event.asStartElement().getName().getLocalPart();
                    event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        String tmpDate = event.asCharacters().getData();
                        try {
                            this.value = SEDAXMLEventReader.getDateFromString(tmpDate);
                        }
                        catch (DateTimeParseException e) {
                            throw new SEDALibException("La date est mal format\u00e9e", e);
                        }
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = null;
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block8;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type DateTimeType", e);
            }
        }
        return true;
    }

    @Override
    @JsonIgnore(value=false)
    public LocalDate getValue() {
        return this.value;
    }

    public void setValue(LocalDate value) {
        this.value = value;
    }
}

