/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonGetter;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSetter;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.MonthDay;
import java.time.OffsetDateTime;
import java.time.Year;
import java.time.YearMonth;
import java.time.ZoneId;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeParseException;
import java.time.temporal.TemporalAccessor;
import java.util.LinkedHashMap;
import java.util.regex.Pattern;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class DateTimeType
extends NamedTypeMetadata {
    @JsonIgnore
    private TemporalAccessor temporalValue;
    private DateTimeFormatType formatType;
    private static final Pattern OFFSET_DATE_TIME_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(:\\d{2}(\\.\\d{1,9})?)?([+-]\\d{2}:\\d{2}|Z)$");
    private static final Pattern DATE_TIME_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}T\\d{2}:\\d{2}(:\\d{2}(\\.\\d{1,9})?)?$");
    private static final Pattern DATE_PATTERN = Pattern.compile("^\\d{4}-\\d{2}-\\d{2}$");
    private static final Pattern G_YEAR_PATTERN = Pattern.compile("^\\d{4}$");
    private static final Pattern G_YEAR_MONTH_PATTERN = Pattern.compile("^\\d{4}-\\d{2}$");
    private static final Pattern G_MONTH_PATTERN = Pattern.compile("^--\\d{2}$");
    private static final Pattern G_MONTH_DAY_PATTERN = Pattern.compile("^--\\d{2}-\\d{2}$");
    private static final Pattern G_DAY_PATTERN = Pattern.compile("^---\\d{2}$");

    public DateTimeType() {
        this(null, (String)null);
    }

    public DateTimeType(String elementName) {
        this(elementName, (String)null);
    }

    public DateTimeType(String elementName, OffsetDateTime value) {
        super(elementName);
        this.temporalValue = value;
        this.formatType = DateTimeFormatType.OFFSET_DATE_TIME;
    }

    public DateTimeType(String elementName, LocalDateTime value) {
        super(elementName);
        this.temporalValue = value;
        this.formatType = DateTimeFormatType.DATE_TIME;
    }

    public DateTimeType(String elementName, LocalDate dateValue) {
        super(elementName);
        this.temporalValue = dateValue;
        this.formatType = DateTimeFormatType.DATE;
    }

    public DateTimeType(String elementName, String dateString) {
        super(elementName);
        if (dateString == null || dateString.isEmpty()) {
            this.temporalValue = null;
            this.formatType = null;
        } else {
            this.parseDateString(dateString);
        }
    }

    private void parseDateString(String dateString) {
        block10: {
            try {
                if (OFFSET_DATE_TIME_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = OffsetDateTime.parse(dateString);
                    this.formatType = DateTimeFormatType.OFFSET_DATE_TIME;
                    break block10;
                }
                if (DATE_TIME_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = LocalDateTime.parse(dateString);
                    this.formatType = DateTimeFormatType.DATE_TIME;
                    break block10;
                }
                if (DATE_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = LocalDate.parse(dateString);
                    this.formatType = DateTimeFormatType.DATE;
                    break block10;
                }
                if (G_YEAR_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = Year.parse(dateString);
                    this.formatType = DateTimeFormatType.G_YEAR;
                    break block10;
                }
                if (G_YEAR_MONTH_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = YearMonth.parse(dateString);
                    this.formatType = DateTimeFormatType.G_YEAR_MONTH;
                    break block10;
                }
                if (G_MONTH_DAY_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = MonthDay.parse(dateString);
                    this.formatType = DateTimeFormatType.G_MONTH_DAY;
                    break block10;
                }
                if (G_MONTH_PATTERN.matcher(dateString).matches()) {
                    this.temporalValue = MonthDay.parse(dateString + "-01");
                    this.formatType = DateTimeFormatType.G_MONTH;
                    break block10;
                }
                if (G_DAY_PATTERN.matcher(dateString).matches()) {
                    int day = Integer.parseInt(dateString.substring(3));
                    this.temporalValue = LocalDate.of(2000, 1, day);
                    this.formatType = DateTimeFormatType.G_DAY;
                    break block10;
                }
                throw new SEDALibException("Unrecognized date format: " + dateString);
            }
            catch (SEDALibException | DateTimeParseException e) {
                throw new RuntimeException("Error parsing date: " + dateString, e);
            }
        }
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            if (this.temporalValue == null) {
                xmlWriter.writeElementValue(this.elementName, null);
                return;
            }
            DateTimeFormatter formatter = this.getFormatter();
            xmlWriter.writeElementValue(this.elementName, formatter.format(this.temporalValue));
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("XML writing error in DateTimeType [" + this.elementName + "]", e);
        }
    }

    private DateTimeFormatter getFormatter() throws SEDALibException {
        switch (this.formatType) {
            case OFFSET_DATE_TIME: {
                return DateTimeFormatter.ISO_OFFSET_DATE_TIME;
            }
            case DATE_TIME: {
                return DateTimeFormatter.ISO_LOCAL_DATE_TIME;
            }
            case DATE: {
                return DateTimeFormatter.ISO_LOCAL_DATE;
            }
            case G_YEAR: {
                return DateTimeFormatter.ofPattern("uuuu");
            }
            case G_YEAR_MONTH: {
                return DateTimeFormatter.ofPattern("uuuu-MM");
            }
            case G_MONTH: {
                return DateTimeFormatter.ofPattern("'--'MM");
            }
            case G_MONTH_DAY: {
                return DateTimeFormatter.ofPattern("'--'MM-dd");
            }
            case G_DAY: {
                return DateTimeFormatter.ofPattern("'---'dd");
            }
        }
        throw new SEDALibException("Date type not handled: " + this.formatType);
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String valueStr = this.temporalValue != null ? this.getFormatter().format(this.temporalValue) : "";
        result.put("", valueStr);
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            if (!xmlReader.peekBlockIfNamed(this.elementName)) {
                return false;
            }
            XMLEvent event = xmlReader.nextUsefullEvent();
            this.elementName = event.asStartElement().getName().getLocalPart();
            event = xmlReader.nextUsefullEvent();
            if (event.isCharacters()) {
                this.parseDateString(event.asCharacters().getData());
                event = xmlReader.nextUsefullEvent();
            } else {
                this.temporalValue = null;
                this.formatType = null;
            }
            if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                throw new SEDALibException("Element " + this.elementName + " not properly terminated");
            }
            return true;
        }
        catch (Exception e) {
            throw new SEDALibException("XML reading error in DateTimeType", e);
        }
    }

    @JsonIgnore
    public TemporalAccessor getTemporalValue() {
        return this.temporalValue;
    }

    @JsonIgnore
    public DateTimeFormatType getFormatTypeEnum() {
        return this.formatType;
    }

    @JsonIgnore
    @JsonGetter(value="dateTimeFormat")
    public String getFormatType() {
        return this.formatType == null ? "" : this.formatType.name();
    }

    @JsonGetter(value="dateTimeString")
    public String getDateTimeString() {
        if (this.temporalValue == null) {
            return "";
        }
        try {
            return this.getFormatter().format(this.temporalValue);
        }
        catch (SEDALibException e) {
            return "";
        }
    }

    @JsonSetter(value="dateTimeString")
    public void setDateTimeString(String dateTimeString) {
        if (dateTimeString == null || dateTimeString.trim().isEmpty()) {
            this.temporalValue = null;
            this.formatType = null;
        } else {
            this.parseDateString(dateTimeString);
        }
    }

    @JsonIgnore
    public String getUtcDateTimeString() {
        if (this.temporalValue == null) {
            return "";
        }
        if (this.formatType == DateTimeFormatType.G_YEAR || this.formatType == DateTimeFormatType.G_YEAR_MONTH || this.formatType == DateTimeFormatType.G_MONTH || this.formatType == DateTimeFormatType.G_MONTH_DAY || this.formatType == DateTimeFormatType.G_DAY) {
            return "";
        }
        try {
            OffsetDateTime utcDateTime;
            if (this.temporalValue instanceof OffsetDateTime) {
                utcDateTime = ((OffsetDateTime)this.temporalValue).withOffsetSameInstant(ZoneOffset.UTC);
            } else if (this.temporalValue instanceof LocalDateTime) {
                utcDateTime = ((LocalDateTime)this.temporalValue).atZone(ZoneId.systemDefault()).withZoneSameInstant(ZoneOffset.UTC).toOffsetDateTime();
            } else if (this.temporalValue instanceof LocalDate) {
                utcDateTime = ((LocalDate)this.temporalValue).atStartOfDay(ZoneOffset.UTC).toOffsetDateTime();
            } else {
                return "";
            }
            return DateTimeFormatter.ISO_OFFSET_DATE_TIME.format(utcDateTime);
        }
        catch (Exception e) {
            return "";
        }
    }

    @JsonIgnore
    public LocalDateTime toLocalDateTime() {
        if (this.temporalValue == null) {
            return null;
        }
        if (this.formatType == DateTimeFormatType.G_YEAR || this.formatType == DateTimeFormatType.G_YEAR_MONTH || this.formatType == DateTimeFormatType.G_MONTH || this.formatType == DateTimeFormatType.G_MONTH_DAY || this.formatType == DateTimeFormatType.G_DAY) {
            return null;
        }
        try {
            switch (this.formatType) {
                case OFFSET_DATE_TIME: {
                    return ((OffsetDateTime)this.temporalValue).atZoneSameInstant(ZoneId.systemDefault()).toLocalDateTime();
                }
                case DATE_TIME: {
                    return (LocalDateTime)this.temporalValue;
                }
                case DATE: {
                    return ((LocalDate)this.temporalValue).atStartOfDay();
                }
            }
            return null;
        }
        catch (Exception e) {
            return null;
        }
    }

    public static enum DateTimeFormatType {
        OFFSET_DATE_TIME,
        DATE_TIME,
        DATE,
        G_YEAR,
        G_YEAR_MONTH,
        G_MONTH,
        G_MONTH_DAY,
        G_DAY;

    }
}

