/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListInterface;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public abstract class ComplexListType
extends NamedTypeMetadata
implements ComplexListInterface {
    protected static Map<Class<?>, Map<SedaVersion, Map<String, ComplexListMetadataKind>>> subTypeMetadataMapsMap = new HashMap();
    protected static Map<Class<?>, Map<SedaVersion, Boolean>> subTypeNotExpandablesMap = new HashMap();
    protected List<SEDAMetadata> metadataList = new ArrayList<SEDAMetadata>();

    @Override
    public List<SEDAMetadata> getMetadataList() {
        return this.metadataList;
    }

    @Override
    public void setMetadataList(List<SEDAMetadata> metadataList) {
        this.metadataList = metadataList;
    }

    protected ComplexListType(String elementName) {
        super(elementName);
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartElement(this.getXmlElementName());
            this.toSedaXmlMetadataList(xmlWriter);
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        return ComplexListInterface.super.toCsvList();
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            if (!xmlReader.nextBlockIfNamed(this.elementName)) {
                return false;
            }
            this.fillFromSedaXmlMetadataList(xmlReader);
            xmlReader.endBlockNamed(this.elementName);
        }
        catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment [" + this.elementName + "]", e);
        }
        return true;
    }

    @Override
    @JsonIgnore
    public boolean isNotExpandable() {
        return ComplexListInterface.isNotExpandable(this.getClass());
    }

    @Override
    @JsonIgnore
    public LinkedHashMap<String, ComplexListMetadataKind> getMetadataMap() throws SEDALibException {
        return (LinkedHashMap)ComplexListInterface.getMetadataMap(this.getClass());
    }

    @JsonIgnore
    public static LinkedHashMap<String, ComplexListMetadataKind> getMetadataMap(Class<?> clazz) throws SEDALibException {
        return (LinkedHashMap)ComplexListInterface.getMetadataMap(clazz);
    }
}

