/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import fr.gouv.vitam.tools.sedalib.core.seda.SedaContext;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DateTimeType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.EnumType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.TextType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public interface ComplexListInterface {
    private static List<Field> getFieldsWithAnnotationComplexListMetadataMap(Class<?> targetClass) {
        ArrayList<Field> result = new ArrayList<Field>();
        for (Field field : targetClass.getDeclaredFields()) {
            if (!field.isAnnotationPresent(ComplexListMetadataMap.class)) continue;
            result.add(field);
        }
        return result;
    }

    private static List<SedaVersion> getSedaVersions(ComplexListMetadataMap annotation) {
        SedaVersion[] explicit = annotation.sedaVersion();
        return explicit.length == 0 ? Arrays.asList(SedaVersion.values()) : Arrays.asList(explicit);
    }

    public static void initMetadataMaps(Class<?> targetClass, Map<SedaVersion, Map<String, ComplexListMetadataKind>> versionedMetadataDefinitions, Map<SedaVersion, Boolean> versionedNotExpandableFlags) {
        try {
            List<Field> annotatedFields = ComplexListInterface.getFieldsWithAnnotationComplexListMetadataMap(targetClass);
            for (Field field : annotatedFields) {
                ComplexListMetadataMap ann = field.getAnnotation(ComplexListMetadataMap.class);
                LinkedHashMap map = (LinkedHashMap)field.get(null);
                boolean isExpandable = ann.isExpandable();
                for (SedaVersion version2 : ComplexListInterface.getSedaVersions(ann)) {
                    versionedMetadataDefinitions.put(version2, map);
                    versionedNotExpandableFlags.put(version2, !isExpandable);
                }
            }
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Erreur d'initialisation des metadata pour la classe " + targetClass.getName(), e);
        }
    }

    public static Map<SedaVersion, Map<String, ComplexListMetadataKind>> metadataDefinitions(Class<?> clazz) {
        LinkedHashMap<SedaVersion, Map<String, ComplexListMetadataKind>> versionedMetadataDefinitions = new LinkedHashMap<SedaVersion, Map<String, ComplexListMetadataKind>>();
        try {
            List<Field> annotatedFields = ComplexListInterface.getFieldsWithAnnotationComplexListMetadataMap(clazz);
            for (Field field : annotatedFields) {
                ComplexListMetadataMap ann = field.getAnnotation(ComplexListMetadataMap.class);
                LinkedHashMap map = (LinkedHashMap)field.get(null);
                for (SedaVersion version2 : ComplexListInterface.getSedaVersions(ann)) {
                    versionedMetadataDefinitions.put(version2, map);
                }
            }
        }
        catch (ClassCastException | ReflectiveOperationException e) {
            throw new RuntimeException("Erreur d'initialisation des metadata pour la classe " + clazz.getName(), e);
        }
        return versionedMetadataDefinitions;
    }

    public static Map<SedaVersion, Boolean> notExpandableFlags(Class<?> clazz) {
        LinkedHashMap<SedaVersion, Boolean> versionedNotExpandableFlags = new LinkedHashMap<SedaVersion, Boolean>();
        try {
            List<Field> annotatedFields = ComplexListInterface.getFieldsWithAnnotationComplexListMetadataMap(clazz);
            for (Field field : annotatedFields) {
                ComplexListMetadataMap ann = field.getAnnotation(ComplexListMetadataMap.class);
                for (SedaVersion version2 : ComplexListInterface.getSedaVersions(ann)) {
                    versionedNotExpandableFlags.put(version2, !ann.isExpandable());
                }
            }
        }
        catch (ClassCastException e) {
            throw new RuntimeException("Erreur d'initialisation des metadata pour la classe " + clazz.getName(), e);
        }
        return versionedNotExpandableFlags;
    }

    public static Map<String, ComplexListMetadataKind> getMetadataMap(Class<?> complexListTypeMetadataClass) throws SEDALibException {
        Map<SedaVersion, Map<String, ComplexListMetadataKind>> metadataDefinitions = ComplexListInterface.metadataDefinitions(complexListTypeMetadataClass);
        if (metadataDefinitions.containsKey((Object)SedaContext.getVersion())) {
            return metadataDefinitions.get((Object)SedaContext.getVersion());
        }
        return metadataDefinitions.values().stream().findFirst().orElseThrow(() -> {
            String errorMessage = "Le type " + complexListTypeMetadataClass.getName() + " ne dispose pas de d\u00e9finitions seda versionn\u00e9e";
            return new SEDALibException(errorMessage);
        });
    }

    public static Boolean isNotExpandable(Class<?> complexListTypeMetadataClass) {
        Map<SedaVersion, Boolean> notExpandableFlags = ComplexListInterface.notExpandableFlags(complexListTypeMetadataClass);
        if (notExpandableFlags.containsKey((Object)SedaContext.getVersion())) {
            return notExpandableFlags.get((Object)SedaContext.getVersion());
        }
        return false;
    }

    public LinkedHashMap<String, ComplexListMetadataKind> getMetadataMap() throws SEDALibException;

    public boolean isNotExpandable();

    public List<SEDAMetadata> getMetadataList();

    public void setMetadataList(List<SEDAMetadata> var1);

    public String getXmlElementName();

    private static Class<?> wrapPrimitives(Class<?> type) {
        if (!type.isPrimitive()) {
            return type;
        }
        if (type == Integer.TYPE) {
            return Integer.class;
        }
        if (type == Long.TYPE) {
            return Long.class;
        }
        if (type == Double.TYPE) {
            return Double.class;
        }
        if (type == Float.TYPE) {
            return Float.class;
        }
        if (type == Boolean.TYPE) {
            return Boolean.class;
        }
        if (type == Character.TYPE) {
            return Character.class;
        }
        if (type == Byte.TYPE) {
            return Byte.class;
        }
        if (type == Short.TYPE) {
            return Short.class;
        }
        return type;
    }

    private static boolean areArgsCompatible(Object[] args, Class<?>[] paramTypes) {
        if (args.length != paramTypes.length) {
            return false;
        }
        for (int i = 0; i < args.length; ++i) {
            Object arg = args[i];
            Class<?> expectedType = paramTypes[i];
            if (!(arg == null ? expectedType.isPrimitive() : !ComplexListInterface.wrapPrimitives(expectedType).isAssignableFrom(arg.getClass()))) continue;
            return false;
        }
        return true;
    }

    private static Constructor<?> getCompatibleConstructor(Class<?> clazz, Object[] args) {
        Constructor<?>[] constructors;
        for (Constructor<?> constructor : constructors = clazz.getConstructors()) {
            if (!ComplexListInterface.areArgsCompatible(args, constructor.getParameterTypes())) continue;
            return constructor;
        }
        return null;
    }

    private static Object[] prepareConstructorArgs(boolean isNamedType, String elementName, Object[] originalArgs) {
        if (!isNamedType) {
            return originalArgs;
        }
        Object[] prefixed = new Object[originalArgs.length + 1];
        prefixed[0] = elementName;
        System.arraycopy(originalArgs, 0, prefixed, 1, originalArgs.length);
        return prefixed;
    }

    private static SEDAMetadata getClassMemberConstructedFromArgs(Class<?> metadataClass, String elementName, Object[] args) throws SEDALibException, IllegalAccessException, InvocationTargetException, InstantiationException {
        SEDAMetadata sm;
        boolean isNamedType = metadataClass.getName().contains(".namedtype.");
        Object[] constructorArgs = ComplexListInterface.prepareConstructorArgs(isNamedType, elementName, args);
        Constructor<?> compatibleCtor = ComplexListInterface.getCompatibleConstructor(metadataClass, constructorArgs);
        if (compatibleCtor == null) {
            try {
                if (isNamedType) {
                    sm = (SEDAMetadata)metadataClass.getConstructor(String.class, Object[].class).newInstance(elementName, args);
                }
                sm = (SEDAMetadata)metadataClass.getConstructor(Object[].class).newInstance(new Object[]{args});
            }
            catch (NoSuchMethodException e) {
                throw new SEDALibException("Pas de constructeur de l'\u00e9l\u00e9ment [" + elementName + "]", e);
            }
        } else {
            return (SEDAMetadata)compatibleCtor.newInstance(constructorArgs);
        }
        return sm;
    }

    default public SEDAMetadata newSEDAMetadata(String elementName, Object[] args) throws SEDALibException {
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        if (metadataMap == null) {
            throw new SEDALibException("Impossible de construire l'\u00e9l\u00e9ment [" + elementName + "] en " + SedaContext.getVersion(), null);
        }
        ComplexListMetadataKind metadataKind = metadataMap.get(elementName);
        try {
            Class metadataClass = metadataKind != null ? metadataKind.getMetadataClass() : AnyXMLType.class;
            SEDAMetadata metadata = ComplexListInterface.getClassMemberConstructedFromArgs(metadataClass, elementName, args);
            if (metadata == null) {
                throw new SEDALibException("Impossible de construire l'\u00e9l\u00e9ment [" + elementName + "]");
            }
            return metadata;
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | SecurityException e) {
            throw new SEDALibException("Impossible de construire l'\u00e9l\u00e9ment [" + elementName + "]", e);
        }
        catch (InvocationTargetException te) {
            throw new SEDALibException("Impossible de construire l'\u00e9l\u00e9ment [" + elementName + "]", te.getCause());
        }
    }

    default public int indexOfMetadata(String elementName) throws SEDALibException {
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        int index = 0;
        for (String key : metadataMap.keySet()) {
            if (key.equals(elementName)) {
                return index;
            }
            ++index;
        }
        return -1;
    }

    default public void addNewMetadata(String elementName, Object ... args) throws SEDALibException {
        if (args.length > 0) {
            try {
                SEDAMetadata sm = this.newSEDAMetadata(elementName, args);
                this.addMetadata(sm);
            }
            catch (SEDALibException e) {
                throw new SEDALibException("Impossible d'ajouter l'\u00e9l\u00e9ment [" + elementName + "] au type compos\u00e9 [" + this.getXmlElementName() + "] en " + SedaContext.getVersion(), e);
            }
        }
    }

    private InsertionInfo computeInsertionInfoForKnownType(int newIndex, boolean isMany) throws SEDALibException {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        int index = 0;
        boolean replaceExisting = false;
        for (SEDAMetadata item : metadataList) {
            int currentIndex = this.indexOfMetadata(item.getXmlElementName());
            if (!isMany && currentIndex == newIndex) {
                replaceExisting = true;
                break;
            }
            if (currentIndex == -1 || currentIndex > newIndex) break;
            ++index;
        }
        return new InsertionInfo(index, replaceExisting);
    }

    private InsertionInfo computeInsertionInfoForUnknownType(String xmlName, boolean notExpandable) throws SEDALibException {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        if (notExpandable) {
            throw new SEDALibException("Impossible d'\u00e9tendre le sch\u00e9ma avec des m\u00e9tadonn\u00e9es non pr\u00e9vues [" + xmlName + "]");
        }
        int index = 0;
        boolean seen = false;
        for (SEDAMetadata item : metadataList) {
            String name = item.getXmlElementName();
            if (name.equals(xmlName)) {
                seen = true;
            } else if (seen) break;
            ++index;
        }
        return new InsertionInfo(index, false);
    }

    default public void addMetadata(SEDAMetadata metadata) throws SEDALibException {
        InsertionInfo info;
        if (metadata == null) {
            return;
        }
        List<SEDAMetadata> metadataList = this.getMetadataList();
        boolean notExpandable = this.isNotExpandable();
        String xmlName = metadata.getXmlElementName();
        int newIndex = this.indexOfMetadata(xmlName);
        InsertionInfo insertionInfo = info = newIndex == -1 ? this.computeInsertionInfoForUnknownType(xmlName, notExpandable) : this.computeInsertionInfoForKnownType(newIndex, this.isAMultiValuedMetadata(xmlName));
        if (info.replaceExisting) {
            metadataList.set(info.insertionIndex, metadata);
        } else {
            metadataList.add(info.insertionIndex, metadata);
        }
    }

    default public boolean isMetadataLacking(String elementName) {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        for (SEDAMetadata sm : metadataList) {
            if (!sm.getXmlElementName().equals(elementName)) continue;
            return false;
        }
        return true;
    }

    default public void toSedaXmlMetadataList(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        for (SEDAMetadata sm : metadataList) {
            sm.toSedaXml(xmlWriter);
        }
    }

    default public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String previousXMLElementName = null;
        int count = 0;
        for (SEDAMetadata sm : metadataList) {
            if (!sm.getXmlElementName().equals(previousXMLElementName)) {
                previousXMLElementName = sm.getXmlElementName();
                count = 0;
            } else {
                ++count;
            }
            Object addedName = this.isAMultiValuedMetadata(sm.getXmlElementName()) ? sm.getXmlElementName() + "." + count : sm.getXmlElementName();
            LinkedHashMap<String, String> smCsvList = sm.toCsvList();
            for (Map.Entry<String, String> e : smCsvList.entrySet()) {
                result.put((String)addedName + (String)(e.getKey().isEmpty() ? "" : "." + e.getKey()), e.getValue());
            }
        }
        return result;
    }

    default public boolean fillFromSedaXmlMetadataList(SEDAXMLEventReader xmlReader) throws SEDALibException {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        boolean isNotExpandable = this.isNotExpandable();
        try {
            String tmp = xmlReader.peekName();
            while (tmp != null) {
                Class<Object> metadataClass;
                ComplexListMetadataKind mi = metadataMap.get(tmp);
                if (mi == null) {
                    if (isNotExpandable) {
                        throw new SEDALibException("Impossible d'\u00e9tendre le sch\u00e9ma avec des m\u00e9tadonn\u00e9es non pr\u00e9vues [" + tmp + "]");
                    }
                    metadataClass = AnyXMLType.class;
                } else {
                    metadataClass = mi.getMetadataClass();
                }
                SEDAMetadata sm = SEDAMetadata.fromSedaXml(xmlReader, metadataClass);
                this.addMetadata(sm);
                tmp = xmlReader.peekName();
            }
        }
        catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment compos\u00e9", e);
        }
        return true;
    }

    private static Class<?> resolveMetadataClass(String name, Map<String, ComplexListMetadataKind> metadataMap, boolean notExpandable) throws SEDALibException {
        ComplexListMetadataKind kind = metadataMap.get(name);
        if (kind != null) {
            return kind.getMetadataClass();
        }
        if (notExpandable) {
            throw new SEDALibException("Impossible d'\u00e9tendre le sch\u00e9ma avec des m\u00e9tadonn\u00e9es non pr\u00e9vues [" + name + "]");
        }
        return AnyXMLType.class;
    }

    default public void addSedaXmlFragments(String xmlData) throws SEDALibException {
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        boolean isNotExpandable = this.isNotExpandable();
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            String elementName = xmlReader.peekName();
            while (elementName != null) {
                Class<?> metadataClass = ComplexListInterface.resolveMetadataClass(elementName, metadataMap, isNotExpandable);
                SEDAMetadata metadata = SEDAMetadata.fromSedaXml(xmlReader, metadataClass);
                this.addMetadata(metadata);
                elementName = xmlReader.peekName();
            }
        }
        catch (SEDALibException | IOException | IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML de fragments d'un \u00e9l\u00e9ment compos\u00e9", e);
        }
    }

    default public SEDAMetadata getFirstNamedMetadata(String elementName) {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        for (SEDAMetadata sm : metadataList) {
            if (!elementName.equals(sm.getXmlElementName())) continue;
            return sm;
        }
        return null;
    }

    default public boolean removeFirstNamedMetadata(String elementName) {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        for (int i = 0; i < metadataList.size(); ++i) {
            if (!elementName.equals(metadataList.get(i).getXmlElementName())) continue;
            metadataList.remove(i);
            return true;
        }
        return false;
    }

    default public String getSimpleMetadata(String metadataName) {
        List<SEDAMetadata> metadataList = this.getMetadataList();
        String langText = null;
        for (SEDAMetadata sm : metadataList) {
            if (!sm.getXmlElementName().equals(metadataName)) continue;
            if (sm instanceof StringType) {
                return ((StringType)sm).getValue();
            }
            if (sm instanceof TextType && ((TextType)sm).getLang() == null) {
                return ((TextType)sm).getValue();
            }
            if (sm instanceof TextType && ((TextType)sm).getLang().equals("fr")) {
                langText = ((TextType)sm).getValue();
                continue;
            }
            if (sm instanceof EnumType) {
                return ((EnumType)sm).getValue();
            }
            if (!(sm instanceof DateTimeType)) continue;
            return ((DateTimeType)sm).getDateTimeString();
        }
        return langText;
    }

    default public boolean isAMultiValuedMetadata(String metadataName) throws SEDALibException {
        LinkedHashMap<String, ComplexListMetadataKind> metadataMap = this.getMetadataMap();
        ComplexListMetadataKind clmk = metadataMap.get(metadataName);
        if (clmk == null) {
            return true;
        }
        return clmk.isMany();
    }

    public static class InsertionInfo {
        final int insertionIndex;
        final boolean replaceExisting;

        InsertionInfo(int insertionIndex, boolean replaceExisting) {
            this.insertionIndex = insertionIndex;
            this.replaceExisting = replaceExisting;
        }
    }
}

