/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class BooleanType
extends NamedTypeMetadata {
    private Boolean value;

    public BooleanType() {
        this(null, null);
    }

    public BooleanType(String elementName) {
        this(elementName, null);
    }

    public BooleanType(String elementName, Boolean value) {
        super(elementName);
        this.value = value;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        String tmp = null;
        try {
            if (this.value != null) {
                tmp = this.value.toString();
            }
            xmlWriter.writeElementValue(this.elementName, tmp);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type BooleanType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        String tmp = null;
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        tmp = this.value != null ? this.value.toString() : "";
        result.put("", tmp);
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block10: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        String tmp = event.asCharacters().getData();
                        if (tmp.equals("true")) {
                            this.value = true;
                        } else if (tmp.equals("false")) {
                            this.value = false;
                        } else {
                            throw new SEDALibException(tmp + " n'est pas une valeur autoris\u00e9e");
                        }
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = null;
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block10;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type BooleanType", e);
            }
        }
        return true;
    }

    @Override
    @JsonIgnore(value=false)
    public Boolean getValue() {
        return this.value;
    }

    public void setValue(Boolean value) {
        this.value = value;
    }
}

