/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class AnyXMLType
extends NamedTypeMetadata {
    private String rawXml;

    public AnyXMLType() {
        this(null, null);
    }

    public AnyXMLType(String elementName) {
        this(elementName, null);
    }

    public AnyXMLType(String elementName, String rawXml) {
        super(elementName);
        this.rawXml = rawXml;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeRawXMLBlockIfNotEmpty(this.rawXml);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type AnyXMLType [" + this.getXmlElementName() + "]", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("", this.rawXml);
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            XMLEvent event = xmlReader.peekUsefullEvent();
            this.elementName = event.asStartElement().getName().getLocalPart();
            this.rawXml = xmlReader.nextBlockAsStringIfNamed(this.elementName);
        }
        catch (IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type AnyXMLType", e);
        }
        return true;
    }

    public String getRawXml() {
        return this.rawXml;
    }

    public void setRawXml(String rawXml) {
        this.rawXml = rawXml;
    }
}

