/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.namedtype;

import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class AnyXMLListType
extends ComplexListType {
    @ComplexListMetadataMap(isExpandable=true)
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public AnyXMLListType() {
        super(null);
    }

    public AnyXMLListType(String elementName) {
        super(elementName);
    }

    public AnyXMLListType(String elementName, String rawXmlList) throws SEDALibException {
        super(elementName);
        try (ByteArrayInputStream bais = new ByteArrayInputStream(rawXmlList.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            String tmp = xmlReader.peekName();
            while (tmp != null) {
                SEDAMetadata sm = SEDAMetadata.fromSedaXml(xmlReader, AnyXMLType.class);
                this.addMetadata(sm);
                tmp = xmlReader.peekName();
            }
            XMLEvent event = xmlReader.xmlReader.peek();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Il y a des champs ill\u00e9gaux");
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de [" + elementName + "]", e);
        }
    }
}

