/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.management;

import fr.gouv.vitam.tools.sedalib.metadata.content.Rule;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.BooleanType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DateType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.RuleMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.RuleType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.time.LocalDate;
import java.util.LinkedHashMap;
import java.util.Map;

public class HoldRule
extends RuleType {
    static final String HOLDRULE_TAG = "HoldRule";
    static final String HOLDENDDATE_TAG = "HoldEndDate";
    static final String HOLDOWNER_TAG = "HoldOwner";
    static final String HOLDREASSESSINGDATE_TAG = "HoldReassessingDate";
    static final String HOLDREASON_TAG = "HoldReason";
    static final String HOLDPREVENTREARRANGEMENT_TAG = "PreventRearrangement";
    @ComplexListMetadataMap(isExpandable=true)
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public HoldRule() {
        super(HOLDRULE_TAG);
    }

    public HoldRule(String rule, LocalDate startDate) throws SEDALibException {
        super(HOLDRULE_TAG, rule, startDate);
    }

    public HoldRule(String rule, LocalDate startDate, Map<String, Object> otherMetadata) throws SEDALibException {
        super(HOLDRULE_TAG, rule, startDate);
        for (Map.Entry<String, Object> entry : otherMetadata.entrySet()) {
            this.addNewMetadata(entry.getKey(), entry.getValue());
        }
    }

    public void addHoldEndDate(LocalDate holdEndDate) throws SEDALibException {
        this.addNewMetadata(HOLDENDDATE_TAG, holdEndDate);
    }

    public void addHoldOwner(String holdOwner) throws SEDALibException {
        this.addNewMetadata(HOLDOWNER_TAG, holdOwner);
    }

    public void addHoldReassessingDate(LocalDate holdReassessingDate) throws SEDALibException {
        this.addNewMetadata(HOLDREASSESSINGDATE_TAG, holdReassessingDate);
    }

    public void addHoldReason(String holdReason) throws SEDALibException {
        this.addNewMetadata(HOLDREASON_TAG, holdReason);
    }

    public void addPreventRearrangement(boolean preventRearrangement) throws SEDALibException {
        this.addNewMetadata(HOLDPREVENTREARRANGEMENT_TAG, preventRearrangement);
    }

    static {
        metadataMap.put("Rule", new ComplexListMetadataKind(Rule.class, true));
        metadataMap.put(HOLDENDDATE_TAG, new RuleMetadataKind(DateType.class, true));
        metadataMap.put(HOLDOWNER_TAG, new RuleMetadataKind(StringType.class, true));
        metadataMap.put(HOLDREASSESSINGDATE_TAG, new RuleMetadataKind(DateType.class, true));
        metadataMap.put(HOLDREASON_TAG, new RuleMetadataKind(StringType.class, true));
        metadataMap.put(HOLDPREVENTREARRANGEMENT_TAG, new RuleMetadataKind(BooleanType.class, true));
        metadataMap.put("PreventInheritance", new ComplexListMetadataKind(BooleanType.class, false));
        metadataMap.put("RefNonRuleId", new ComplexListMetadataKind(StringType.class, true));
    }
}

