/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.data;

import com.fasterxml.jackson.annotation.JsonIgnore;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class Weight
extends NamedTypeMetadata {
    public static final List<String> enumValues = Arrays.asList("microgram", "MC", "milligram", "MGM", "gram", "GRM", "kilogram", "KGM");
    private Double value;
    private String unit;

    public Weight() throws SEDALibException {
        this(null, null);
    }

    public Weight(Double value) throws SEDALibException {
        this(value, null);
    }

    public Weight(Double value, String unit) throws SEDALibException {
        super("Weight");
        this.value = value;
        if (unit != null && !enumValues.contains(unit)) {
            throw new SEDALibException("[" + unit + "] n'est pas une unit\u00e9 de mesure lin\u00e9raire");
        }
        this.unit = unit;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartElement(this.elementName);
            if (this.unit != null) {
                xmlWriter.writeAttribute("unit", this.unit);
            }
            if (this.value != null) {
                xmlWriter.writeCharactersIfNotEmpty(Double.toString(this.value));
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type Weight", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.value != null) {
            result.put("", this.value.toString());
            if (this.unit != null) {
                result.put("attr", "unit=\"" + this.unit + "\"");
            }
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block6: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    this.unit = xmlReader.peekAttribute("unit");
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (event.isCharacters()) {
                        this.value = Double.parseDouble(event.asCharacters().getData());
                        event = xmlReader.nextUsefullEvent();
                    } else {
                        this.value = null;
                    }
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block6;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type Weight", e);
            }
        }
        return true;
    }

    public String getUnit() {
        return this.unit;
    }

    @Override
    @JsonIgnore(value=false)
    public Double getValue() {
        return this.value;
    }

    public void setValue(Double value) {
        this.value = value;
    }

    public void setUnit(String unit) throws SEDALibException {
        if (unit != null && !enumValues.contains(unit)) {
            throw new SEDALibException("[" + unit + "] n'est pas une unit\u00e9 de mesure de poids");
        }
        this.unit = unit;
    }
}

