/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.data;

import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;

public class Relationship
extends NamedTypeMetadata {
    private String target;
    private String type;

    public Relationship() {
        this(null, null);
    }

    public Relationship(String target) {
        this(target, null);
    }

    public Relationship(String target, String type) {
        super("Relationship");
        this.target = target;
        this.type = type;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeStartElement(this.elementName);
            if (this.target != null) {
                xmlWriter.writeAttribute("xml:target", this.target);
            }
            if (this.type != null) {
                xmlWriter.writeAttribute("xml:type", this.type);
            }
            xmlWriter.writeEndElement();
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de type Relationship", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        if (this.target != null) {
            result.put("attr", "xml:target=\"" + this.target + "\"");
        }
        if (this.type != null) {
            result.put("attr", "xml:type=\"" + this.type + "\"");
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        block4: {
            try {
                if (xmlReader.peekBlockIfNamed(this.elementName)) {
                    this.target = xmlReader.peekAttribute("http://www.w3.org/XML/1998/namespace", "target");
                    this.type = xmlReader.peekAttribute("http://www.w3.org/XML/1998/namespace", "type");
                    xmlReader.nextUsefullEvent();
                    XMLEvent event = xmlReader.nextUsefullEvent();
                    if (!event.isEndElement() || !this.elementName.equals(event.asEndElement().getName().getLocalPart())) {
                        throw new SEDALibException("El\u00e9ment " + this.elementName + " mal termin\u00e9");
                    }
                    break block4;
                }
                return false;
            }
            catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
                throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type TextType", e);
            }
        }
        return true;
    }

    public String getTarget() {
        return this.target;
    }

    public String getType() {
        return this.type;
    }

    public void setTarget(String target) {
        this.target = target;
    }

    public void setType(String type) {
        this.type = type;
    }
}

