/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.content;

import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.metadata.content.AdditionalProof;
import fr.gouv.vitam.tools.sedalib.metadata.content.SignatureDescription;
import fr.gouv.vitam.tools.sedalib.metadata.content.TimestampingInformation;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.EnumType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.SIPInternalIDType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class SigningInformation
extends ComplexListType {
    @ComplexListMetadataMap(sedaVersion={SedaVersion.V2_3})
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public SigningInformation() {
        super("SigningInformation");
    }

    public SigningInformation(String signingRole, String sipInternalID, String signerFirstName, String signerBirthName, LocalDateTime signingTime, String signerIdentifier, String signingType) throws SEDALibException {
        super("SigningInformation");
        if (signingRole != null) {
            this.addNewMetadata("SigningRole", signingRole);
        }
        if (sipInternalID != null) {
            this.addNewMetadata("SignedDocumentReferenceId", sipInternalID);
        }
        if (signerFirstName != null || signerBirthName != null || signingTime != null || signerIdentifier != null || signingType != null) {
            this.addNewMetadata("SignatureDescription", signerFirstName, signerBirthName, signingTime, signerIdentifier, null, null, signingType);
        }
        if (signingTime != null) {
            this.addNewMetadata("TimestampingInformation", signingTime, null);
        }
    }

    static {
        metadataMap.put("SigningRole", new ComplexListMetadataKind(EnumType.class, true));
        metadataMap.put("DetachedSigningRole", new ComplexListMetadataKind(EnumType.class, true));
        metadataMap.put("SignedDocumentReferenceId", new ComplexListMetadataKind(SIPInternalIDType.class, true));
        metadataMap.put("SignatureDescription", new ComplexListMetadataKind(SignatureDescription.class, true));
        metadataMap.put("TimestampingInformation", new ComplexListMetadataKind(TimestampingInformation.class, true));
        metadataMap.put("AdditionalProof", new ComplexListMetadataKind(AdditionalProof.class, false));
        metadataMap.put("Extended", new ComplexListMetadataKind(AnyXMLListType.class, false));
    }
}

