/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.content;

import fr.gouv.vitam.tools.sedalib.metadata.content.Signer;
import fr.gouv.vitam.tools.sedalib.metadata.content.Validator;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.time.LocalDateTime;
import java.util.LinkedHashMap;
import java.util.Map;

public class SignatureDescription
extends ComplexListType {
    @ComplexListMetadataMap
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public SignatureDescription() {
        super("SignatureDescription");
    }

    public SignatureDescription(String signerFirstName, String signerBirthName, LocalDateTime signingTime, String signerIdentifier, String validatorCorpname, LocalDateTime validationTime, String signingType) throws SEDALibException {
        super("SignatureDescription");
        Object signer = null;
        Object validator = null;
        if (signerFirstName != null || signerBirthName != null || signingTime != null && signerIdentifier != null) {
            this.addNewMetadata("Signer", signerFirstName, signerBirthName, signingTime, signerIdentifier);
        }
        if (validatorCorpname != null || validationTime != null) {
            this.addNewMetadata("Validator", validatorCorpname, validationTime);
        }
        if (signingType != null) {
            this.addNewMetadata("SigningType", signingType);
        }
    }

    static {
        metadataMap.put("Signer", new ComplexListMetadataKind(Signer.class, false));
        metadataMap.put("Validator", new ComplexListMetadataKind(Validator.class, false));
        metadataMap.put("SigningType", new ComplexListMetadataKind(StringType.class, false));
    }
}

