/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.content;

import fr.gouv.vitam.tools.sedalib.metadata.namedtype.NamedTypeMetadata;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.time.LocalDate;
import java.time.format.DateTimeParseException;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;

public class Rule
extends NamedTypeMetadata {
    private String ruleID;
    private LocalDate startDate;

    public Rule() {
        this(null, null);
    }

    public Rule(String ruleID, LocalDate startDate) {
        super("Rule");
        this.ruleID = ruleID;
        this.startDate = startDate;
    }

    @Override
    public void toSedaXml(SEDAXMLStreamWriter xmlWriter) throws SEDALibException {
        try {
            xmlWriter.writeElementValue("Rule", this.ruleID);
            if (this.startDate != null) {
                xmlWriter.writeElementValue("StartDate", SEDAXMLStreamWriter.getStringFromDate(this.startDate));
            }
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur d'\u00e9criture XML dans un \u00e9l\u00e9ment de r\u00e8gle dans RuleType", e);
        }
    }

    @Override
    public LinkedHashMap<String, String> toCsvList() throws SEDALibException {
        throw new SEDALibException("M\u00e9thode d'\u00e9criture des Csv inadapt\u00e9e pour un RuleElement");
    }

    public LinkedHashMap<String, String> toCsvList(int i) throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        result.put("Rule." + i, this.ruleID);
        if (this.startDate != null) {
            result.put("StartDate." + i, SEDAXMLStreamWriter.getStringFromDate(this.startDate));
        }
        return result;
    }

    @Override
    public boolean fillFromSedaXml(SEDAXMLEventReader xmlReader) throws SEDALibException {
        try {
            LocalDate curStartDate;
            String tmp = xmlReader.nextValueIfNamed("Rule");
            if (tmp != null) {
                String tmpDate = xmlReader.nextValueIfNamed("StartDate");
                if (tmpDate == null) {
                    curStartDate = null;
                } else {
                    try {
                        curStartDate = SEDAXMLEventReader.getDateFromString(tmpDate);
                    }
                    catch (DateTimeParseException e) {
                        throw new SEDALibException("La date est mal format\u00e9e", e);
                    }
                }
            } else {
                return false;
            }
            this.ruleID = tmp;
            this.startDate = curStartDate;
        }
        catch (SEDALibException | IllegalArgumentException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de r\u00e8gle dans RuleType", e);
        }
        return true;
    }

    public String getRuleID() {
        return this.ruleID;
    }

    public void setRuleID(String ruleID) {
        this.ruleID = ruleID;
    }

    public LocalDate getStartDate() {
        return this.startDate;
    }

    public void setStartDate(LocalDate startDate) {
        this.startDate = startDate;
    }
}

