/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.content;

import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.util.LinkedHashMap;
import java.util.Map;

public class Gps
extends ComplexListType {
    @ComplexListMetadataMap
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public Gps() {
        super("Gps");
    }

    public Gps(String gpsVersionID, int gpsAltitude, String gpsLatitude, String gpsLongitude, String gpsDateStamp) throws SEDALibException {
        this();
        if (gpsVersionID != null) {
            this.addNewMetadata("GpsVersionID", gpsVersionID);
        }
        if (gpsAltitude != -100000) {
            if (gpsAltitude < 0) {
                this.addNewMetadata("GpsAltitudeRef", "1");
            } else {
                this.addNewMetadata("GpsAltitudeRef", "0");
            }
            this.addNewMetadata("GpsAltitude", Math.abs(gpsAltitude));
        }
        if (gpsLatitude.startsWith("-")) {
            gpsLatitude = gpsLatitude.substring(1);
            this.addNewMetadata("GpsLatitudeRef", "S");
        } else {
            this.addNewMetadata("GpsLatitudeRef", "N");
        }
        this.addNewMetadata("GpsLatitude", gpsLatitude);
        if (gpsLongitude.startsWith("-")) {
            gpsLongitude = gpsLongitude.substring(1);
            this.addNewMetadata("GpsLongitudeRef", "O");
        } else {
            this.addNewMetadata("GpsLongitudeRef", "E");
        }
        this.addNewMetadata("GpsLongitude", gpsLongitude);
        if (gpsDateStamp != null) {
            this.addNewMetadata("GpsDateStamp", gpsDateStamp);
        }
    }

    static {
        metadataMap.put("GpsVersionID", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsAltitude", new ComplexListMetadataKind(IntegerType.class, false));
        metadataMap.put("GpsAltitudeRef", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsLatitude", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsLatitudeRef", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsLongitude", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsLongitudeRef", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("GpsDateStamp", new ComplexListMetadataKind(StringType.class, false));
    }
}

