/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata.content;

import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentContainer;
import fr.gouv.vitam.tools.sedalib.metadata.compacted.DocumentPack;
import fr.gouv.vitam.tools.sedalib.metadata.content.Coverage;
import fr.gouv.vitam.tools.sedalib.metadata.content.CustodialHistory;
import fr.gouv.vitam.tools.sedalib.metadata.content.Event;
import fr.gouv.vitam.tools.sedalib.metadata.content.Gps;
import fr.gouv.vitam.tools.sedalib.metadata.content.Keyword;
import fr.gouv.vitam.tools.sedalib.metadata.content.PersistentIdentifier;
import fr.gouv.vitam.tools.sedalib.metadata.content.RelatedObjectReference;
import fr.gouv.vitam.tools.sedalib.metadata.content.Signature;
import fr.gouv.vitam.tools.sedalib.metadata.content.SigningInformation;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AgencyType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AgentType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DateTimeType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.EnumType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.TextType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class Content
extends ComplexListType {
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_1})
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_2})
    public static final Map<String, ComplexListMetadataKind> metadataMap_v2;
    @ComplexListMetadataMap(isExpandable=true, sedaVersion={SedaVersion.V2_3})
    public static final Map<String, ComplexListMetadataKind> metadataMap_v3;

    public Content() {
        super("Content");
    }

    public String filteredToString(List<String> keptMetadataList) {
        String result;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
             SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2);){
            xmlWriter.writeStartElement(this.elementName);
            for (SEDAMetadata sm : this.metadataList) {
                if (!keptMetadataList.contains(sm.getXmlElementName())) continue;
                sm.toSedaXml(xmlWriter);
            }
            xmlWriter.writeEndElement();
            xmlWriter.flush();
            result = baos.toString(StandardCharsets.UTF_8);
            if (result.startsWith("\n")) {
                result = result.substring(1);
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            result = super.toString();
        }
        return result;
    }

    public LinkedHashMap<String, String> externToCsvList(List<String> keptMetadataList) throws SEDALibException {
        LinkedHashMap<String, String> result = new LinkedHashMap<String, String>();
        String previousXMLElementName = null;
        int count = 0;
        for (SEDAMetadata sm : this.metadataList) {
            if (keptMetadataList != null && !keptMetadataList.contains(sm.getXmlElementName())) continue;
            if (!sm.getXmlElementName().equals(previousXMLElementName)) {
                previousXMLElementName = sm.getXmlElementName();
                count = 0;
            } else {
                ++count;
            }
            Object addedName = this.isAMultiValuedMetadata(sm.getXmlElementName()) ? sm.getXmlElementName() + "." + count : sm.getXmlElementName();
            LinkedHashMap<String, String> smCsvList = sm.toCsvList();
            smCsvList.entrySet().stream().forEach(arg_0 -> Content.lambda$externToCsvList$0(result, (String)addedName, arg_0));
        }
        return result;
    }

    private static /* synthetic */ void lambda$externToCsvList$0(LinkedHashMap result, String addedName, Map.Entry e) {
        result.put("Content." + addedName + (String)(((String)e.getKey()).isEmpty() ? "" : "." + (String)e.getKey()), (String)e.getValue());
    }

    static {
        metadataMap.put("DescriptionLevel", new ComplexListMetadataKind(EnumType.class, false));
        metadataMap.put("Title", new ComplexListMetadataKind(TextType.class, true));
        metadataMap.put("FilePlanPosition", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("SystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("OriginatingSystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("ArchivalAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("OriginatingAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("TransferringAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("Description", new ComplexListMetadataKind(TextType.class, true));
        metadataMap.put("CustodialHistory", new ComplexListMetadataKind(CustodialHistory.class, false));
        metadataMap.put("Type", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("DocumentType", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("Language", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("DescriptionLanguage", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("Status", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("Version", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("Tag", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("Keyword", new ComplexListMetadataKind(Keyword.class, true));
        metadataMap.put("Coverage", new ComplexListMetadataKind(Coverage.class, false));
        metadataMap.put("OriginatingAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap.put("SubmissionAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap.put("AuthorizedAgent", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Writer", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Addressee", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Recipient", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Transmitter", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Sender", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap.put("Source", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("RelatedObjectReference", new ComplexListMetadataKind(RelatedObjectReference.class, false));
        metadataMap.put("CreatedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("TransactedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("AcquiredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("SentDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("ReceivedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("RegisteredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("StartDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("EndDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap.put("Event", new ComplexListMetadataKind(Event.class, true));
        metadataMap.put("Signature", new ComplexListMetadataKind(Signature.class, true));
        metadataMap.put("Gps", new ComplexListMetadataKind(Gps.class, false));
        metadataMap.put("OriginatingSystemIdReplyTo", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("TextContent", new ComplexListMetadataKind(StringType.class, true));
        metadataMap.put("DocumentContainer", new ComplexListMetadataKind(DocumentContainer.class, false));
        metadataMap.put("DocumentPack", new ComplexListMetadataKind(DocumentPack.class, false));
        metadataMap_v2 = new LinkedHashMap<String, ComplexListMetadataKind>();
        metadataMap_v2.put("DescriptionLevel", new ComplexListMetadataKind(EnumType.class, false));
        metadataMap_v2.put("Title", new ComplexListMetadataKind(TextType.class, true));
        metadataMap_v2.put("FilePlanPosition", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("SystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("OriginatingSystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("ArchivalAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("OriginatingAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("TransferringAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("Description", new ComplexListMetadataKind(TextType.class, true));
        metadataMap_v2.put("CustodialHistory", new ComplexListMetadataKind(CustodialHistory.class, false));
        metadataMap_v2.put("Type", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("DocumentType", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("Language", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("DescriptionLanguage", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("Status", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("Version", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("Tag", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("Keyword", new ComplexListMetadataKind(Keyword.class, true));
        metadataMap_v2.put("Coverage", new ComplexListMetadataKind(Coverage.class, false));
        metadataMap_v2.put("OriginatingAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap_v2.put("SubmissionAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap_v2.put("Agent", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("AuthorizedAgent", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Writer", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Addressee", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Recipient", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Transmitter", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Sender", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v2.put("Source", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("RelatedObjectReference", new ComplexListMetadataKind(RelatedObjectReference.class, false));
        metadataMap_v2.put("CreatedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("TransactedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("AcquiredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("SentDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("ReceivedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("RegisteredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("StartDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("EndDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v2.put("DateLitteral", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("Event", new ComplexListMetadataKind(Event.class, true));
        metadataMap_v2.put("Signature", new ComplexListMetadataKind(Signature.class, true));
        metadataMap_v2.put("Gps", new ComplexListMetadataKind(Gps.class, false));
        metadataMap_v2.put("OriginatingSystemIdReplyTo", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v2.put("TextContent", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v2.put("DocumentContainer", new ComplexListMetadataKind(DocumentContainer.class, false));
        metadataMap_v2.put("DocumentPack", new ComplexListMetadataKind(DocumentPack.class, false));
        metadataMap_v3 = new LinkedHashMap<String, ComplexListMetadataKind>();
        metadataMap_v3.put("DescriptionLevel", new ComplexListMetadataKind(EnumType.class, false));
        metadataMap_v3.put("Title", new ComplexListMetadataKind(TextType.class, true));
        metadataMap_v3.put("FilePlanPosition", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("SystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("OriginatingSystemId", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("ArchivalAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("OriginatingAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("TransferringAgencyArchiveUnitIdentifier", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("Description", new ComplexListMetadataKind(TextType.class, true));
        metadataMap_v3.put("CustodialHistory", new ComplexListMetadataKind(CustodialHistory.class, false));
        metadataMap_v3.put("Type", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("DocumentType", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("Language", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("DescriptionLanguage", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("Status", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("Version", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("Tag", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("Keyword", new ComplexListMetadataKind(Keyword.class, true));
        metadataMap_v3.put("Coverage", new ComplexListMetadataKind(Coverage.class, false));
        metadataMap_v3.put("OriginatingAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap_v3.put("SubmissionAgency", new ComplexListMetadataKind(AgencyType.class, false));
        metadataMap_v3.put("Agent", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("AuthorizedAgent", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Writer", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Addressee", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Recipient", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Transmitter", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Sender", new ComplexListMetadataKind(AgentType.class, true));
        metadataMap_v3.put("Source", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("RelatedObjectReference", new ComplexListMetadataKind(RelatedObjectReference.class, false));
        metadataMap_v3.put("CreatedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("TransactedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("AcquiredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("SentDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("ReceivedDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("RegisteredDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("StartDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("EndDate", new ComplexListMetadataKind(DateTimeType.class, false));
        metadataMap_v3.put("DateLitteral", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("Event", new ComplexListMetadataKind(Event.class, true));
        metadataMap_v3.put("SigningInformation", new ComplexListMetadataKind(SigningInformation.class, false));
        metadataMap_v3.put("Gps", new ComplexListMetadataKind(Gps.class, false));
        metadataMap_v3.put("OriginatingSystemIdReplyTo", new ComplexListMetadataKind(StringType.class, false));
        metadataMap_v3.put("TextContent", new ComplexListMetadataKind(StringType.class, true));
        metadataMap_v3.put("PersistentIdentifier", new ComplexListMetadataKind(PersistentIdentifier.class, true));
        metadataMap_v3.put("DocumentContainer", new ComplexListMetadataKind(DocumentContainer.class, false));
        metadataMap_v3.put("DocumentPack", new ComplexListMetadataKind(DocumentPack.class, false));
    }
}

