/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonSubTypes;
import com.fasterxml.jackson.annotation.JsonTypeInfo;
import fr.gouv.vitam.tools.sedalib.metadata.content.Event;
import fr.gouv.vitam.tools.sedalib.metadata.content.PersistentIdentifier;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.data.FormatIdentification;
import fr.gouv.vitam.tools.sedalib.metadata.data.Metadata;
import fr.gouv.vitam.tools.sedalib.metadata.data.PhysicalDimensions;
import fr.gouv.vitam.tools.sedalib.metadata.data.Relationship;
import fr.gouv.vitam.tools.sedalib.metadata.data.Weight;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DateTimeType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DateType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.DigestType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.EnumType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.IntegerType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.LinearDimensionType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.TextType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.nio.charset.StandardCharsets;
import java.util.LinkedHashMap;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.lang3.reflect.ConstructorUtils;

@JsonTypeInfo(use=JsonTypeInfo.Id.NAME, property="type")
@JsonSubTypes(value={@JsonSubTypes.Type(value=Relationship.class, name="Relationship"), @JsonSubTypes.Type(value=StringType.class, name="StringType"), @JsonSubTypes.Type(value=PersistentIdentifier.class, name="PersistentIdentifier"), @JsonSubTypes.Type(value=IntegerType.class, name="IntegerType"), @JsonSubTypes.Type(value=DigestType.class, name="DigestType"), @JsonSubTypes.Type(value=FormatIdentification.class, name="FormatIdentification"), @JsonSubTypes.Type(value=FileInfo.class, name="FileInfo"), @JsonSubTypes.Type(value=Metadata.class, name="Metadata"), @JsonSubTypes.Type(value=AnyXMLType.class, name="AnyXMLType"), @JsonSubTypes.Type(value=PhysicalDimensions.class, name="PhysicalDimensions"), @JsonSubTypes.Type(value=LinearDimensionType.class, name="LinearDimensionType"), @JsonSubTypes.Type(value=Weight.class, name="Weight"), @JsonSubTypes.Type(value=AnyXMLListType.class, name="AnyXMLListType"), @JsonSubTypes.Type(value=EnumType.class, name="EnumType"), @JsonSubTypes.Type(value=TextType.class, name="TextType"), @JsonSubTypes.Type(value=DateTimeType.class, name="DateTimeType"), @JsonSubTypes.Type(value=DateType.class, name="DateType"), @JsonSubTypes.Type(value=Event.class, name="Event")})
public abstract class SEDAMetadata {
    public abstract void toSedaXml(SEDAXMLStreamWriter var1) throws SEDALibException;

    public abstract LinkedHashMap<String, String> toCsvList() throws SEDALibException;

    public String toString() {
        String result;
        block13: {
            result = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream();
                 SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2);){
                this.toSedaXml(xmlWriter);
                xmlWriter.flush();
                result = baos.toString("UTF-8");
                if (result.startsWith("\n")) {
                    result = result.substring(1);
                }
            }
            catch (SEDALibException | IOException | XMLStreamException e) {
                if (result != null) break block13;
                result = super.toString();
            }
        }
        return result;
    }

    public abstract boolean fillFromSedaXml(SEDAXMLEventReader var1) throws SEDALibException;

    public static SEDAMetadata fromSedaXml(SEDAXMLEventReader xmlReader, Class<?> target) throws SEDALibException {
        try {
            SEDAMetadata sm;
            boolean needName = target.getName().contains(".namedtype.");
            if (needName) {
                XMLEvent event = xmlReader.peekUsefullEvent();
                sm = (SEDAMetadata)ConstructorUtils.invokeConstructor(target, event.asStartElement().getName().getLocalPart());
            } else {
                sm = (SEDAMetadata)ConstructorUtils.invokeConstructor(target, (Object[])null);
            }
            if (sm.fillFromSedaXml(xmlReader)) {
                return sm;
            }
            Method method = target.getMethod("fromSedaXml", SEDAXMLEventReader.class);
            return (SEDAMetadata)method.invoke(null, xmlReader);
        }
        catch (IllegalAccessException | IllegalArgumentException | InstantiationException | NoSuchMethodException | SecurityException e) {
            throw new SEDALibException("Erreur de construction du " + target.getSimpleName(), e);
        }
        catch (InvocationTargetException te) {
            throw new SEDALibException("Erreur de construction du " + target.getSimpleName(), te.getTargetException());
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture XML dans un \u00e9l\u00e9ment de type " + target.getSimpleName(), e);
        }
    }

    public static SEDAMetadata fromString(String xmlData, Class<?> target) throws SEDALibException {
        SEDAMetadata result;
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xmlData.getBytes(StandardCharsets.UTF_8));
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            result = SEDAMetadata.fromSedaXml(xmlReader, target);
            XMLEvent event = xmlReader.xmlReader.peek();
            if (!event.isEndDocument()) {
                throw new SEDALibException("Il y a des champs ill\u00e9gaux");
            }
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Erreur de lecture de " + target.getSimpleName(), e);
        }
        return result;
    }

    @JsonIgnore
    public abstract String getXmlElementName();
}

