/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.metadata;

import fr.gouv.vitam.tools.sedalib.metadata.SEDAMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.management.AccessRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.AppraisalRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.ClassificationRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.DisseminationRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.HoldRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.ReuseRule;
import fr.gouv.vitam.tools.sedalib.metadata.management.StorageRule;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.AnyXMLType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataMap;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.RuleType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import java.util.LinkedHashMap;
import java.util.Map;

public class ManagementMetadata
extends ComplexListType {
    @ComplexListMetadataMap(isExpandable=true)
    public static final Map<String, ComplexListMetadataKind> metadataMap = new LinkedHashMap<String, ComplexListMetadataKind>();

    public ManagementMetadata() {
        super("ManagementMetadata");
    }

    @Override
    public void addNewMetadata(String elementName, Object ... args) throws SEDALibException {
        ComplexListMetadataKind metadataKind = this.getMetadataMap().get(elementName);
        if (RuleType.class.isAssignableFrom(metadataKind.getMetadataClass())) {
            int ruleIndex = 0;
            for (int i = 0; i < this.metadataList.size(); ++i) {
                if (!((SEDAMetadata)this.metadataList.get(i)).getXmlElementName().equals(elementName)) continue;
                ruleIndex = i;
            }
            if (ruleIndex != 0) {
                ((RuleType)this.metadataList.get(ruleIndex)).addNewMetadata("Rule", args);
                return;
            }
        }
        super.addNewMetadata(elementName, args);
    }

    @Override
    public void addMetadata(SEDAMetadata sedaMetadata) throws SEDALibException {
        ComplexListMetadataKind metadataKind = this.getMetadataMap().get(sedaMetadata.getXmlElementName());
        if (RuleType.class.isAssignableFrom(metadataKind.getMetadataClass())) {
            int ruleIndex = 0;
            for (int i = 0; i < this.metadataList.size(); ++i) {
                if (!((SEDAMetadata)this.metadataList.get(i)).getXmlElementName().equals(sedaMetadata.getXmlElementName())) continue;
                ruleIndex = i;
            }
            if (ruleIndex != 0) {
                RuleType ruleType = (RuleType)this.metadataList.get(ruleIndex);
                for (SEDAMetadata metadata : ((RuleType)sedaMetadata).getMetadataList()) {
                    ruleType.addMetadata(metadata);
                }
                super.addMetadata(ruleType);
                return;
            }
        }
        super.addMetadata(sedaMetadata);
    }

    static {
        metadataMap.put("ArchivalProfile", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("ServiceLevel", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("AcquisitionInformation", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("LegalStatus", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("OriginatingAgencyIdentifier", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("SubmissionAgencyIdentifier", new ComplexListMetadataKind(StringType.class, false));
        metadataMap.put("StorageRule", new ComplexListMetadataKind(StorageRule.class, false));
        metadataMap.put("AppraisalRule", new ComplexListMetadataKind(AppraisalRule.class, false));
        metadataMap.put("AccessRule", new ComplexListMetadataKind(AccessRule.class, false));
        metadataMap.put("DisseminationRule", new ComplexListMetadataKind(DisseminationRule.class, false));
        metadataMap.put("ReuseRule", new ComplexListMetadataKind(ReuseRule.class, false));
        metadataMap.put("ClassificationRule", new ComplexListMetadataKind(ClassificationRule.class, false));
        metadataMap.put("HoldRule", new ComplexListMetadataKind(HoldRule.class, false));
        metadataMap.put("LogBook", new ComplexListMetadataKind(AnyXMLType.class, false));
        metadataMap.put("NeedAuthorization", new ComplexListMetadataKind(StringType.class, false));
    }
}

