/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.compress.archivers.zip.ZipArchiveEntry;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.io.IOUtils;

public class SIPToArchiveTransferImporter {
    private String zipFile;
    private String unCompressDirectory;
    private ArchiveTransfer archiveTransfer;
    Instant start;
    Instant end;
    private SEDALibProgressLogger sedaLibProgressLogger;

    public String unZipSip(String zipFile, String outputFolder) throws SEDALibException, InterruptedException {
        Object manifest = null;
        int counter = 0;
        try (FileInputStream fis = new FileInputStream(zipFile);
             ZipArchiveInputStream zais = new ZipArchiveInputStream(fis);){
            ZipArchiveEntry ze;
            File folder = new File(outputFolder);
            if (!folder.exists()) {
                folder.mkdir();
            }
            while ((ze = zais.getNextEntry()) != null) {
                Object fileName = ze.getName().trim();
                if (((String)fileName).toLowerCase().startsWith("content")) {
                    fileName = "content" + ((String)fileName).substring(7);
                }
                Path newPath = Paths.get(outputFolder + File.separator + (String)fileName, new String[0]);
                if (((String)fileName).endsWith("/")) {
                    if (Files.exists(newPath, new LinkOption[0])) continue;
                    Files.createDirectories(newPath, new FileAttribute[0]);
                    continue;
                }
                if (((String)fileName).toLowerCase().matches("[^/\\\\]*manifest.*\\.xml")) {
                    if (manifest != null) {
                        throw new SEDALibException("SIP mal form\u00e9, plusieurs fichiers manifest potentiels");
                    }
                    manifest = fileName;
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 40, "sedalib: unzip manifest [" + zipFile + "]", null);
                } else {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 40, "sedalib: unzip fichier [" + zipFile + "]", null);
                }
                if (!Files.exists(newPath.getParent(), new LinkOption[0])) {
                    Files.createDirectories(newPath.getParent(), new FileAttribute[0]);
                }
                try (FileOutputStream fos = new FileOutputStream(newPath.toFile());){
                    IOUtils.copy((InputStream)zais, (OutputStream)fos);
                    SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++counter, Integer.toString(counter) + " fichiers extraits");
                }
            }
        }
        catch (IOException ex) {
            throw new SEDALibException("Impossible de d\u00e9compresser le fichier [" + zipFile + "] dans le r\u00e9pertoire [" + outputFolder + "]", ex);
        }
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " fichiers extraits");
        if (manifest == null) {
            throw new SEDALibException("SIP mal form\u00e9, pas de manifest");
        }
        return manifest;
    }

    public SIPToArchiveTransferImporter(String zipFile, String unCompressDirectory, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        Path zipFilePath = Paths.get(zipFile, new String[0]);
        if (!Files.isRegularFile(zipFilePath, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + zipFile + "] pointant vers le SIP ne d\u00e9signe pas un fichier");
        }
        Path unCompressDirectoryPath = Paths.get(unCompressDirectory, new String[0]).toAbsolutePath();
        if (!Files.exists(unCompressDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(unCompressDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SEDALibException("Impossible de cr\u00e9er le r\u00e9pertoire d'extraction [" + unCompressDirectory + "]");
            }
        }
        if (!Files.isDirectory(unCompressDirectoryPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + unCompressDirectory + "] pointant le r\u00e9pertoire d'extraction ne d\u00e9signe pas un r\u00e9pertoire");
        }
        this.zipFile = zipFile;
        this.unCompressDirectory = unCompressDirectoryPath.normalize().toString();
        this.sedaLibProgressLogger = sedaLibProgressLogger;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'import du SIP\n";
        log = (String)log + "en [" + this.zipFile + "]";
        log = (String)log + " date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        String manifest = this.unZipSip(this.zipFile, this.unCompressDirectory);
        try (FileInputStream fis = new FileInputStream(this.unCompressDirectory + File.separator + manifest);
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(fis);){
            this.archiveTransfer = ArchiveTransfer.fromSedaXml(xmlReader, this.unCompressDirectory, this.sedaLibProgressLogger);
        }
        catch (IOException | XMLStreamException e) {
            throw new SEDALibException("Impossible d'importer le fichier [" + manifest + "] comme manifest du SIP", e);
        }
        this.end = Instant.now();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: import du SIP termin\u00e9", null);
    }

    public ArchiveTransfer getArchiveTransfer() {
        return this.archiveTransfer;
    }

    public String getSummary() {
        String result = this.archiveTransfer.getDescription() + "\n";
        if (this.start != null) {
            result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

