/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.PhysicalDataObject;
import fr.gouv.vitam.tools.sedalib.inout.importer.WindowsShortcut;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import java.io.FileInputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.ParseException;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.regex.Pattern;
import java.util.stream.Stream;
import javax.xml.stream.XMLStreamException;

public class DiskToDataObjectPackageImporter {
    private List<Path> onDiskRootPaths = new ArrayList<Path>();
    private DataObjectPackage dataObjectPackage = null;
    private List<Pattern> ignorePatterns = new ArrayList<Pattern>();
    private boolean isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    private HashMap<String, ArchiveUnit> auPathStringMap = new HashMap();
    private HashMap<String, DataObjectGroup> dogPathStringMap = new HashMap();
    private Path lastAnalyzedLinkTarget;
    private int modelVersion = 0;
    private int inCounter;
    private Instant start;
    private Instant end;
    private boolean noLinkFlag;
    private Function<String, String> extractTitleFromFileNameFunction;
    public static final Function<String, String> simpleCopy = s -> s;
    private SEDALibProgressLogger sedaLibProgressLogger;

    private DiskToDataObjectPackageImporter(boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) {
        this.noLinkFlag = noLinkFlag;
        this.extractTitleFromFileNameFunction = extractTitleFromFileNameFunction != null ? extractTitleFromFileNameFunction : simpleCopy;
        this.inCounter = 0;
        this.sedaLibProgressLogger = sedaLibProgressLogger;
    }

    public DiskToDataObjectPackageImporter(String directory, boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        this(noLinkFlag, extractTitleFromFileNameFunction, sedaLibProgressLogger);
        Path path = Paths.get(directory, new String[0]).toAbsolutePath();
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("[" + directory + "] n'est pas un r\u00e9pertoire");
        }
        try (Stream<Path> sp = Files.list(path).sorted(Comparator.comparing(Path::getFileName));){
            Iterator pi = sp.iterator();
            while (pi.hasNext()) {
                this.onDiskRootPaths.add((Path)pi.next());
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de lister les fichiers du r\u00e9pertoire [" + directory + "]", e);
        }
        this.dataObjectPackage = new DataObjectPackage();
    }

    public DiskToDataObjectPackageImporter(List<Path> paths, SEDALibProgressLogger sedaLibProgressLogger) {
        this(paths, false, simpleCopy, sedaLibProgressLogger);
    }

    public DiskToDataObjectPackageImporter(List<Path> paths, boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) {
        this(noLinkFlag, extractTitleFromFileNameFunction, sedaLibProgressLogger);
        this.onDiskRootPaths = paths;
        this.dataObjectPackage = new DataObjectPackage();
    }

    public void addIgnorePattern(String patternString) {
        this.ignorePatterns.add(Pattern.compile(patternString));
    }

    private boolean mustBeIgnored(String fileName) {
        boolean doMatch = false;
        for (Pattern p : this.ignorePatterns) {
            if (!p.matcher(fileName).matches()) continue;
            doMatch = true;
            break;
        }
        return doMatch;
    }

    private boolean analyzeLink(Path path) {
        try {
            if (Files.isSymbolicLink(path)) {
                this.lastAnalyzedLinkTarget = path.toRealPath(new LinkOption[0]);
                return true;
            }
            if (Files.isRegularFile(path, new LinkOption[0]) && path.getFileName().toString().toLowerCase().endsWith(".lnk")) {
                WindowsShortcut ws = new WindowsShortcut(path.toFile());
                this.lastAnalyzedLinkTarget = Paths.get(ws.getRealFilename(), new String[0]);
                return true;
            }
        }
        catch (IOException | ParseException exception) {
            // empty catch block
        }
        this.lastAnalyzedLinkTarget = null;
        return false;
    }

    public static boolean isDataObjectGroupDirectory(Path path) {
        return Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) && path.getFileName().toString().startsWith("##") && path.getFileName().toString().endsWith("##");
    }

    private String processManagementMetadata(Path path) throws SEDALibException {
        String xmlData;
        try (FileInputStream bais = new FileInputStream(path.toFile());
             SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
            xmlReader.nextUsefullEvent();
            xmlData = xmlReader.nextBlockAsStringIfNamed("ManagementMetadata");
        }
        catch (SEDALibException | IOException | XMLStreamException e) {
            throw new SEDALibException("Lecture des m\u00e9tadonn\u00e9es globales \u00e0 partir du fichier [" + path + "] impossible", e);
        }
        return xmlData;
    }

    private ArchiveUnit processPath(Path path) throws SEDALibException, InterruptedException {
        Object au = this.getArchiveUnit(path);
        if (au != null) {
            return au;
        }
        au = this.analyzeLink(path) ? (this.noLinkFlag ? null : this.processSymbolicLink(this.lastAnalyzedLinkTarget)) : (Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS) ? this.processDirectory(path) : this.processFile(path, true));
        return au;
    }

    private boolean isInRootPaths(Path path) {
        boolean isInRootPath = false;
        path = path.toAbsolutePath();
        for (Path rootPath : this.onDiskRootPaths) {
            if (!path.startsWith(rootPath.toAbsolutePath())) continue;
            isInRootPath = true;
            break;
        }
        return isInRootPath;
    }

    private ArchiveUnit processSymbolicLink(Path path) throws SEDALibException, InterruptedException {
        if (!this.isInRootPaths(this.lastAnalyzedLinkTarget)) {
            throw new SEDALibException("La cible du lien [" + path.toString() + "] est hors de la hi\u00e9rarchie \u00e0 importer");
        }
        ArchiveUnit au = this.processPath(this.lastAnalyzedLinkTarget);
        return au;
    }

    public static String extractDataObjectVersion(String filename) {
        filename = filename.substring(2);
        Object result = filename.substring(0, filename.indexOf(95));
        if ((filename = filename.substring(filename.indexOf(95) + 1)).matches("[0-9]+__.*")) {
            result = (String)result + "_" + filename.substring(0, filename.indexOf("__"));
        } else if (filename.matches("[0-9]+_.*")) {
            result = (String)result + "_" + filename.substring(0, filename.indexOf("_"));
        }
        return result;
    }

    private DataObjectGroup addPhysicalDataObjectMetadata(Path path, String filename, ArchiveUnit au, DataObjectGroup dog) throws SEDALibException {
        String dataObjectVersion = DiskToDataObjectPackageImporter.extractDataObjectVersion(filename);
        if (dog == null) {
            dog = new DataObjectGroup(this.dataObjectPackage, null);
            au.addDataObjectById(dog.getInDataObjectPackageId());
        }
        try {
            PhysicalDataObject pdo = new PhysicalDataObject(this.dataObjectPackage, new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
            StringType pdoDataObjectVersion = pdo.getMetadataDataObjectVersion();
            if (pdoDataObjectVersion == null) {
                pdoDataObjectVersion = new StringType("DataObjectVersion", dataObjectVersion);
            } else if (!pdoDataObjectVersion.getValue().equals(dataObjectVersion)) {
                throw new SEDALibException("usage_version incomptabible entre le contenu du fichier [" + path.toString() + "] et son nom");
            }
            dog.addDataObject(pdo);
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + path.toString() + "]");
        }
        catch (SEDALibException e) {
            throw new SEDALibException("Probl\u00e8me \u00e0 la lecture du fichier [" + path.toString() + "]", e);
        }
        return dog;
    }

    private DataObjectGroup addBinaryDataObjectMetadata(Path path, String filename, ArchiveUnit au, DataObjectGroup dog) throws SEDALibException {
        DataObject zdo;
        String dataObjectVersion = DiskToDataObjectPackageImporter.extractDataObjectVersion(filename);
        if (dog == null) {
            dog = new DataObjectGroup(this.dataObjectPackage, null);
            au.addDataObjectById(dog.getInDataObjectPackageId());
        }
        if ((zdo = dog.findDataObjectByDataObjectVersion(dataObjectVersion)) == null) {
            try {
                BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage, new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
                StringType bdoDataObjectVersion = bdo.getMetadataDataObjectVersion();
                if (bdoDataObjectVersion == null) {
                    bdo.addMetadata(new StringType("DataObjectVersion", dataObjectVersion));
                } else if (!bdoDataObjectVersion.getValue().equals(dataObjectVersion)) {
                    throw new SEDALibException("usage_version incomptabible entre le contenu du fichier [" + path.toString() + "] et son nom");
                }
                dog.addDataObject(bdo);
            }
            catch (IOException e) {
                throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + path.toString() + "]");
            }
            catch (SEDALibException e) {
                throw new SEDALibException("Probl\u00e8me \u00e0 la lecture du fichier [" + path.toString() + "]", e);
            }
        } else if (zdo instanceof BinaryDataObject) {
            BinaryDataObject bdo = (BinaryDataObject)zdo;
            try {
                bdo.fromSedaXmlFragments(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
            }
            catch (IOException e) {
                throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + path.toString() + "]");
            }
            catch (SEDALibException e) {
                throw new SEDALibException("Probl\u00e8me \u00e0 la lecture du fichier [" + path.toString() + "]", e);
            }
        } else {
            throw new SEDALibException("Les m\u00e9tadonn\u00e9es du BinaryDataObject en [" + path.toString() + "] s'applique un usage_version utilis\u00e9 par un autre type de DataObject");
        }
        return dog;
    }

    public static DataObjectGroup addBinaryDataObject(DataObjectPackage dataObjectPackage, Path path, String filename, ArchiveUnit au, DataObjectGroup dog) throws SEDALibException {
        DataObject zdo;
        String dataObjectVersion = DiskToDataObjectPackageImporter.extractDataObjectVersion(filename);
        filename = (filename = filename.substring(dataObjectVersion.length() + 2)).startsWith("__") ? filename.substring(2) : filename.substring(1);
        if (dog == null) {
            dog = new DataObjectGroup(dataObjectPackage, null);
            au.addDataObjectById(dog.getInDataObjectPackageId());
        }
        if ((zdo = dog.findDataObjectByDataObjectVersion(dataObjectVersion)) == null) {
            BinaryDataObject bdo = new BinaryDataObject(dataObjectPackage, path, filename, dataObjectVersion);
            dog.addDataObject(bdo);
        } else if (zdo instanceof BinaryDataObject) {
            BinaryDataObject bdo = (BinaryDataObject)zdo;
            if (bdo.getOnDiskPath() != null) {
                throw new SEDALibException("Un autre BinaryDataObject que [" + path.toString() + "] a \u00e9t\u00e9 cr\u00e9\u00e9 avec le m\u00eame usage_version");
            }
            bdo.setOnDiskPath(path);
        } else {
            throw new SEDALibException("Le BinaryDataObject en [" + path.toString() + "] a un usage_version utilis\u00e9 par un autre type de DataObject");
        }
        return dog;
    }

    private ArchiveUnit processDirectory(Path path) throws SEDALibException, InterruptedException {
        DataObjectGroup implicitDog = null;
        boolean auMetadataDefined = false;
        ArchiveUnit au = this.getArchiveUnit(path);
        if (au != null) {
            return au;
        }
        if (DiskToDataObjectPackageImporter.isDataObjectGroupDirectory(path)) {
            throw new SEDALibException("Le chemin [" + path.toString() + "] devrait d\u00e9crire un ArchiveUnit, mais d\u00e9crit un DataObjectGroup");
        }
        ++this.inCounter;
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, this.inCounter, "sedalib: " + this.inCounter + " ArchiveUnits import\u00e9es");
        String dirName = path.getFileName().toString();
        au = new ArchiveUnit(this.dataObjectPackage);
        au.setOnDiskPath(path);
        this.auPathStringMap.put(au.getOnDiskPath().toString(), au);
        try (Stream<Path> sp = Files.list(path).sorted(Comparator.comparing(Path::getFileName));){
            Iterator pi = sp.iterator();
            ArrayList<String> subPathStringList = new ArrayList<String>(100);
            while (pi.hasNext()) {
                subPathStringList.add(((Path)pi.next()).toString());
            }
            Collections.sort(subPathStringList);
            for (String curPathString : subPathStringList) {
                Path curPath = Paths.get(curPathString, new String[0]);
                String fileName = curPath.getFileName().toString();
                if (!Files.isDirectory(curPath, new LinkOption[0]) && this.mustBeIgnored(fileName)) continue;
                if (this.analyzeLink(curPath)) {
                    if (this.noLinkFlag) continue;
                    if (!this.isInRootPaths(this.lastAnalyzedLinkTarget)) {
                        throw new SEDALibException("Le lien [" + curPath.toString() + "] est hors du champ de l'import");
                    }
                    if (DiskToDataObjectPackageImporter.isDataObjectGroupDirectory(this.lastAnalyzedLinkTarget)) {
                        this.modelVersion |= 2;
                        au.addDataObjectById(this.processObjectGroup(this.lastAnalyzedLinkTarget).getInDataObjectPackageId());
                        continue;
                    }
                    ArchiveUnit childAu = this.processPath(this.lastAnalyzedLinkTarget);
                    if (childAu == null) continue;
                    au.addChildArchiveUnit(childAu);
                    continue;
                }
                if (DiskToDataObjectPackageImporter.isDataObjectGroupDirectory(curPath)) {
                    this.modelVersion |= 2;
                    au.addDataObjectById(this.processObjectGroup(curPath).getInDataObjectPackageId());
                    continue;
                }
                if (Files.isDirectory(curPath, new LinkOption[0])) {
                    au.addChildArchiveUnit(this.processDirectory(curPath));
                    continue;
                }
                if (fileName.equals("ArchiveUnitContent.xml")) {
                    this.modelVersion |= 1;
                    try {
                        au.setContentXmlData(new String(Files.readAllBytes(curPath), StandardCharsets.UTF_8));
                        if (au.getContentXmlData().isEmpty()) continue;
                        auMetadataDefined = true;
                        continue;
                    }
                    catch (IOException e) {
                        throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + curPath.toString() + "]", e);
                    }
                }
                if (fileName.equals("ArchiveUnitManagement.xml")) {
                    this.modelVersion |= 1;
                    try {
                        au.setManagementXmlData(new String(Files.readAllBytes(curPath), StandardCharsets.UTF_8));
                        continue;
                    }
                    catch (IOException e) {
                        throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + curPath.toString() + "]", e);
                    }
                }
                if (fileName.equals("__ArchiveUnitMetadata.xml")) {
                    this.modelVersion |= 2;
                    try {
                        au.fromSedaXmlFragments(new String(Files.readAllBytes(curPath), StandardCharsets.UTF_8));
                        if (au.getContentXmlData() == null || au.getContentXmlData().isEmpty()) continue;
                        auMetadataDefined = true;
                        continue;
                    }
                    catch (IOException e) {
                        throw new SEDALibException("Impossible de lire les m\u00e9tadonn\u00e9es de l'ArchiveUnit depuis le fichier [" + curPath.toString() + "]", e);
                    }
                }
                if (fileName.matches("__\\w+(_[0-9]+)?__PhysicalDataObjectMetadata.xml")) {
                    this.modelVersion |= 2;
                    implicitDog = this.addPhysicalDataObjectMetadata(curPath, fileName, au, implicitDog);
                    continue;
                }
                if (fileName.matches("__\\w+(_[0-9]+)?__BinaryDataObjectMetadata.xml")) {
                    this.modelVersion |= 2;
                    implicitDog = this.addBinaryDataObjectMetadata(curPath, fileName, au, implicitDog);
                    continue;
                }
                if (fileName.matches("__\\w+__.+")) {
                    this.modelVersion |= 2;
                    implicitDog = DiskToDataObjectPackageImporter.addBinaryDataObject(this.dataObjectPackage, curPath, fileName, au, implicitDog);
                    continue;
                }
                if (fileName.matches("__\\w+_.+")) {
                    implicitDog = DiskToDataObjectPackageImporter.addBinaryDataObject(this.dataObjectPackage, curPath, fileName, au, implicitDog);
                    continue;
                }
                au.addChildArchiveUnit(this.processFile(curPath, false));
            }
            if (!auMetadataDefined) {
                au.setDefaultContent(this.extractTitleFromFileNameFunction.apply(dirName), "RecordGrp");
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de parcourir le r\u00e9pertoire [" + path.toString() + "]", e);
        }
        return au;
    }

    private ArchiveUnit processFile(Path path, boolean testIgnorePatterns) throws SEDALibException, InterruptedException {
        ArchiveUnit au = this.getArchiveUnit(path);
        if (au != null) {
            return au;
        }
        String filename = path.getFileName().toString();
        if (testIgnorePatterns && this.mustBeIgnored(filename)) {
            return null;
        }
        if (filename.equals("ArchiveUnitContent.xml") || filename.equals("ArchiveUnitManagement.xml") || filename.equals("__ArchiveUnitMetadata.xml") || filename.matches("__\\w+__.+")) {
            throw new SEDALibException("Le chemin [" + path.toString() + "] a la racine de l'import n'a pas de sens");
        }
        ++this.inCounter;
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, this.inCounter, "sedalib: " + this.inCounter + " ArchiveUnits import\u00e9es");
        DataObjectGroup dog = new DataObjectGroup(this.dataObjectPackage, path);
        BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage, path, null, "BinaryMaster_1");
        au = new ArchiveUnit(this.dataObjectPackage);
        au.setOnDiskPath(path);
        au.setDefaultContent(this.extractTitleFromFileNameFunction.apply(path.getFileName().toString()), "Item");
        this.auPathStringMap.put(au.getOnDiskPath().toString(), au);
        this.dogPathStringMap.put(dog.getOnDiskPath().toString(), dog);
        dog.addDataObject(bdo);
        au.addDataObjectById(dog.getInDataObjectPackageId());
        return au;
    }

    private DataObjectGroup processObjectGroup(Path path) throws SEDALibException {
        DataObjectGroup dog = this.getDataObjectGroup(path);
        if (dog != null) {
            return dog;
        }
        dog = new DataObjectGroup(this.dataObjectPackage, path);
        this.dogPathStringMap.put(dog.getOnDiskPath().toString(), dog);
        try (Stream<Path> sp = Files.list(path).sorted(Comparator.comparing(Path::getFileName));){
            Iterator pi = sp.iterator();
            while (pi.hasNext()) {
                Path curPath = (Path)pi.next();
                if (Files.isSymbolicLink(curPath)) {
                    throw new SEDALibException("Le lien [" + path.toString() + "] ne peut pas pointer vers un BinaryDataObject");
                }
                if (Files.isDirectory(curPath, new LinkOption[0])) {
                    throw new SEDALibException("Un r\u00e9pertoire de DataObjectGroup ne peut pas contenir un r\u00e9pertoire [" + path.toString() + "]");
                }
                String fileName = curPath.getFileName().toString();
                if (fileName.matches("__\\w+(_[0-9]+)?__PhysicalDataObjectMetadata.xml")) {
                    this.modelVersion |= 2;
                    this.addPhysicalDataObjectMetadata(curPath, fileName, null, dog);
                    continue;
                }
                if (fileName.matches("__\\w+(_[0-9]+)?__BinaryDataObjectMetadata.xml")) {
                    this.modelVersion |= 2;
                    this.addBinaryDataObjectMetadata(curPath, fileName, null, dog);
                    continue;
                }
                if (fileName.matches("__\\w+__.+")) {
                    DiskToDataObjectPackageImporter.addBinaryDataObject(this.dataObjectPackage, curPath, fileName, null, dog);
                    continue;
                }
                throw new SEDALibException("Le chemin [" + path.toString() + "] ne d\u00e9crit pas un DataObject");
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de parcourir le r\u00e9pertoire [" + path.toString() + "]", e);
        }
        return dog;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Path nextPath = null;
        this.start = Instant.now();
        try (Stream sp = this.onDiskRootPaths.stream();){
            this.inCounter = 0;
            Iterator pi = sp.iterator();
            while (pi.hasNext()) {
                nextPath = (Path)pi.next();
                if (nextPath.getFileName().toString().equals("__ManagementMetadata.xml")) {
                    this.dataObjectPackage.setManagementMetadataXmlData(this.processManagementMetadata(nextPath));
                    continue;
                }
                ArchiveUnit au = this.processPath(nextPath);
                if (au == null) continue;
                this.dataObjectPackage.addRootAu(au);
            }
            SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 20, "sedalib: " + this.inCounter + " m\u00e9tadonn\u00e9es ArchiveUnits import\u00e9es dans le DataObjectPackage", null);
        }
        catch (SEDALibException e) {
            throw new SEDALibException("Impossible d'importer les ressources du r\u00e9pertoire [" + nextPath.toString() + "]", e);
        }
        this.inCounter = 0;
        for (Map.Entry<String, BinaryDataObject> pair : this.dataObjectPackage.getBdoInDataObjectPackageIdMap().entrySet()) {
            FileInfo fileInfo = pair.getValue().getMetadataFileInfo();
            if (fileInfo.getSimpleMetadata("LastModified") == null) {
                pair.getValue().extractTechnicalElements(this.sedaLibProgressLogger);
            }
            ++this.inCounter;
            SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, this.inCounter, "sedalib: " + this.inCounter + " fichiers BinaryDataObject analys\u00e9s");
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 20, "sedalib: " + this.inCounter + " fichiers BinaryDataObject analys\u00e9s et import\u00e9s dans le DataObjectPackage", null);
        this.end = Instant.now();
    }

    public DataObjectPackage getDataObjectPackage() {
        return this.dataObjectPackage;
    }

    public int getModelVersion() {
        return this.modelVersion;
    }

    private ArchiveUnit getArchiveUnit(Path path) {
        return this.auPathStringMap.get(path.toAbsolutePath().normalize().toString());
    }

    private DataObjectGroup getDataObjectGroup(Path path) {
        return this.dogPathStringMap.get(path.toAbsolutePath().normalize().toString());
    }

    public String getSummary() {
        String result = this.dataObjectPackage.getDescription() + "\n";
        switch (this.getModelVersion()) {
            case 0: {
                result = result + "encod\u00e9 selon un mod\u00e8le neutre de la structure\n";
                break;
            }
            case 1: {
                result = result + "encod\u00e9 selon un mod\u00e8le V1 de la structure\n";
                break;
            }
            case 2: {
                result = result + "encod\u00e9 selon un mod\u00e8le V2 de la structure\n";
                break;
            }
            case 3: {
                result = result + "encod\u00e9 selon un mod\u00e8le hybride V1/V2 de la structure\n";
            }
        }
        if (this.start != null && this.end != null) {
            result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

