/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.inout.importer.DiskToDataObjectPackageImporter;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;

public class DiskToArchiveTransferImporter {
    private DiskToDataObjectPackageImporter diskToDataObjectPackageImporter;
    private List<Path> onDiskRootPaths;
    private Path onDiskGlobalMetadataPath = null;
    private ArchiveTransfer archiveTransfer = new ArchiveTransfer();
    private Instant start;
    private Instant end;
    private SEDALibProgressLogger sedaLibProgressLogger;

    public DiskToArchiveTransferImporter(String directory, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        this(directory, false, DiskToDataObjectPackageImporter.simpleCopy, sedaLibProgressLogger);
    }

    public DiskToArchiveTransferImporter(String directory, boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.onDiskRootPaths = new ArrayList<Path>();
        Path path = Paths.get(directory, new String[0]);
        if (!Files.isDirectory(path, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("[" + directory + "] n'est pas un r\u00e9pertoire");
        }
        try (Stream<Path> sp = Files.list(path).sorted(Comparator.comparing(Path::getFileName));){
            Iterator pi = sp.iterator();
            while (pi.hasNext()) {
                path = (Path)pi.next();
                if (path.getFileName().toString().equals("__GlobalMetadata.xml")) {
                    this.onDiskGlobalMetadataPath = path;
                    continue;
                }
                this.onDiskRootPaths.add(path);
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de lister les fichiers du r\u00e9pertoire [" + directory + "]", e);
        }
        this.diskToDataObjectPackageImporter = new DiskToDataObjectPackageImporter(this.onDiskRootPaths, noLinkFlag, extractTitleFromFileNameFunction, sedaLibProgressLogger);
    }

    public DiskToArchiveTransferImporter(List<Path> paths, SEDALibProgressLogger sedaLibProgressLogger) {
        this(paths, false, DiskToDataObjectPackageImporter.simpleCopy, sedaLibProgressLogger);
    }

    public DiskToArchiveTransferImporter(List<Path> paths, boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.onDiskRootPaths = new ArrayList<Path>();
        for (Path path : paths) {
            if (path.getFileName().toString().equals("__GlobalMetadata")) {
                this.onDiskGlobalMetadataPath = path;
                continue;
            }
            this.onDiskRootPaths.add(path);
        }
        this.diskToDataObjectPackageImporter = new DiskToDataObjectPackageImporter(this.onDiskRootPaths, noLinkFlag, extractTitleFromFileNameFunction, sedaLibProgressLogger);
    }

    public void addIgnorePattern(String patternString) {
        this.diskToDataObjectPackageImporter.addIgnorePattern(patternString);
    }

    private GlobalMetadata processGlobalMetadata(Path path) throws SEDALibException {
        GlobalMetadata atgm = new GlobalMetadata();
        try {
            atgm.fromSedaXmlFragments(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
        }
        catch (SEDALibException | IOException e) {
            throw new SEDALibException("Lecture des m\u00e9tadonn\u00e9es globales \u00e0 partir du fichier [" + path + "] impossible\n->" + e.getMessage());
        }
        return atgm;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'import d'un ArchiveTransfer depuis une hi\u00e9rarchie sur disque\n";
        log = (String)log + "avec les racines en [";
        boolean first = true;
        for (Path path : this.onDiskRootPaths) {
            if (path.getFileName().toString().equals("__ManagementMetadata.xml")) continue;
            if (first) {
                first = false;
            } else {
                log = (String)log + ",\n";
            }
            log = (String)log + path.toString();
        }
        log = (String)log + "]\n";
        log = (String)log + "date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        if (this.onDiskGlobalMetadataPath != null) {
            this.archiveTransfer.setGlobalMetadata(this.processGlobalMetadata(this.onDiskGlobalMetadataPath));
        }
        this.diskToDataObjectPackageImporter.doImport();
        this.archiveTransfer.setDataObjectPackage(this.diskToDataObjectPackageImporter.getDataObjectPackage());
        this.end = Instant.now();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: import d'un ArchiveTransfer depuis une hi\u00e9rarchie sur disque termin\u00e9", null);
    }

    public ArchiveTransfer getArchiveTransfer() {
        return this.archiveTransfer;
    }

    public int getModelVersion() {
        return this.diskToDataObjectPackageImporter.getModelVersion();
    }

    public String getSummary() {
        String result = this.archiveTransfer.getDescription() + "\n";
        switch (this.getModelVersion()) {
            case 0: {
                result = result + "encod\u00e9 selon un mod\u00e8le neutre de la structure\n";
                break;
            }
            case 1: {
                result = result + "encod\u00e9 selon un mod\u00e8le V1 de la structure\n";
                break;
            }
            case 2: {
                result = result + "encod\u00e9 selon un mod\u00e8le V2 de la structure\n";
                break;
            }
            case 3: {
                result = result + "encod\u00e9 selon un mod\u00e8le hybride V1/V2 de la structure\n";
            }
        }
        if (this.start != null && this.end != null) {
            result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

