/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.droid.DroidIdentifier;
import fr.gouv.vitam.tools.sedalib.inout.importer.DiskToDataObjectPackageImporter;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Stream;
import org.apache.commons.compress.archivers.ArchiveEntry;
import org.apache.commons.compress.archivers.ArchiveInputStream;
import org.apache.commons.compress.archivers.sevenz.SevenZFile;
import org.apache.commons.compress.archivers.tar.TarArchiveInputStream;
import org.apache.commons.compress.archivers.zip.ZipArchiveInputStream;
import org.apache.commons.compress.compressors.bzip2.BZip2CompressorInputStream;
import org.apache.commons.compress.compressors.gzip.GzipCompressorInputStream;

public class CompressedFileToArchiveTransferImporter {
    private final String compressedFile;
    private String unCompressDirectory;
    private String droidFormat;
    private String encoding;
    private final Function<String, String> extractTitleFromFileNameFunction;
    private final List<String> ignorePatternStrings;
    private ArchiveTransfer archiveTransfer;
    private DiskToDataObjectPackageImporter diskToDataObjectPackageImporter;
    private final List<Path> onDiskRootPaths;
    private Path onDiskGlobalMetadataPath = null;
    Instant start;
    Instant end;
    private final SEDALibProgressLogger sedaLibProgressLogger;
    public static final String ZIP = "x-fmt/263";
    public static final String TAR = "x-fmt/265";
    public static final String GZIP = "x-fmt/266";
    public static final String BZIP2 = "x-fmt/268";
    public static final String SEVENZIP = "fmt/484";

    public static boolean isKnownCompressedDroidFormat(String droidFormat) {
        if (droidFormat != null) {
            switch (droidFormat) {
                case "x-fmt/263": 
                case "x-fmt/265": 
                case "x-fmt/266": 
                case "x-fmt/268": 
                case "fmt/484": {
                    return true;
                }
            }
            return false;
        }
        return false;
    }

    private ArchiveInputStream createArchiveInputStream() throws SEDALibException {
        ArchiveInputStream ais;
        Path onDiskPath = null;
        FileInputStream fis = null;
        try {
            onDiskPath = Paths.get(this.compressedFile, new String[0]);
            switch (this.droidFormat) {
                case "x-fmt/263": {
                    fis = new FileInputStream(this.compressedFile);
                    ais = new ZipArchiveInputStream(fis, this.encoding);
                    break;
                }
                case "x-fmt/265": {
                    fis = new FileInputStream(this.compressedFile);
                    ais = new TarArchiveInputStream((InputStream)fis, this.encoding);
                    break;
                }
                case "x-fmt/266": {
                    fis = new FileInputStream(this.compressedFile);
                    ais = new TarArchiveInputStream((InputStream)new GzipCompressorInputStream(fis), this.encoding);
                    break;
                }
                case "x-fmt/268": {
                    fis = new FileInputStream(this.compressedFile);
                    ais = new TarArchiveInputStream((InputStream)new BZip2CompressorInputStream(fis), this.encoding);
                    break;
                }
                case "fmt/484": {
                    ais = new SevenZWrapper(new SevenZFile(new File(this.compressedFile)));
                    break;
                }
                default: {
                    throw new SEDALibException("Format " + this.droidFormat + " de compression inconnu.");
                }
            }
        }
        catch (IOException e) {
            if (fis != null) {
                try {
                    fis.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SEDALibException("Impossible d'ouvrir le fichier compress\u00e9 [" + onDiskPath.toString() + "]", e);
        }
        return ais;
    }

    private void unCompressContainer() throws SEDALibException, InterruptedException {
        int counter = 0;
        try (ArchiveInputStream archiveInputStream = this.createArchiveInputStream();){
            Object entry;
            while ((entry = archiveInputStream.getNextEntry()) != null) {
                Path target;
                Path parent;
                if (!archiveInputStream.canReadEntryData((ArchiveEntry)entry)) continue;
                String entryName = entry.getName();
                if (entryName.contains("?")) {
                    entryName = entryName.replace("?", "_");
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "Le nom du fichier [" + entryName + "] a un probl\u00e8me d'encodage, le(s) caract\u00e8re(s) probl\u00e9matique \u00e0 \u00e9t\u00e9 rempalc\u00e9 par _ ", null);
                }
                if ((parent = (target = Paths.get(this.unCompressDirectory, entryName)).getParent()) != null && !Files.exists(parent, new LinkOption[0])) {
                    Files.createDirectories(parent, new FileAttribute[0]);
                }
                if (!entry.isDirectory()) {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 40, "D\u00e9compresse le fichier [" + entryName + "]", null);
                    Files.copy(archiveInputStream, target, StandardCopyOption.REPLACE_EXISTING);
                    SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++counter, Integer.toString(counter) + " fichiers extraits");
                    continue;
                }
                if (Files.exists(target, new LinkOption[0])) continue;
                Files.createDirectories(target, new FileAttribute[0]);
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible d'extraire le fichier compress\u00e9 [" + this.compressedFile + "]", e);
        }
    }

    public CompressedFileToArchiveTransferImporter(String compressedFile, String unCompressDirectory, String encoding, Function<String, String> extractTitleFromFileNameFunction, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.extractTitleFromFileNameFunction = extractTitleFromFileNameFunction;
        this.diskToDataObjectPackageImporter = null;
        this.archiveTransfer = null;
        this.compressedFile = compressedFile;
        this.droidFormat = "";
        this.encoding = encoding;
        this.ignorePatternStrings = new ArrayList<String>();
        this.onDiskRootPaths = new ArrayList<Path>();
        Path compressedFilePath = Paths.get(compressedFile, new String[0]);
        if (!Files.isRegularFile(compressedFilePath, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + compressedFile + "] pointant vers le fichier compress\u00e9 ne d\u00e9signe pas un fichier");
        }
        Path unCompressDirectoryPath = Paths.get(unCompressDirectory, new String[0]).toAbsolutePath();
        this.unCompressDirectory = unCompressDirectoryPath.normalize().toString();
        if (!Files.exists(unCompressDirectoryPath, new LinkOption[0])) {
            try {
                Files.createDirectories(unCompressDirectoryPath, new FileAttribute[0]);
            }
            catch (IOException e) {
                throw new SEDALibException("Impossible de cr\u00e9er le r\u00e9pertoire d'extraction [" + unCompressDirectory + "]");
            }
        }
        if (!Files.isDirectory(unCompressDirectoryPath, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + unCompressDirectory + "] pointant le r\u00e9pertoire d'extraction ne d\u00e9signe pas un r\u00e9pertoire");
        }
    }

    public void addIgnorePattern(String patternString) {
        this.ignorePatternStrings.add(patternString);
    }

    private GlobalMetadata processGlobalMetadata(Path path) throws SEDALibException {
        GlobalMetadata atgm = new GlobalMetadata();
        try {
            atgm.fromSedaXmlFragments(new String(Files.readAllBytes(path), StandardCharsets.UTF_8));
        }
        catch (SEDALibException | IOException e) {
            throw new SEDALibException("Lecture des m\u00e9tadonn\u00e9es globales \u00e0 partir du fichier [" + path + "] impossible", e);
        }
        return atgm;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'import du fichier compress\u00e9\n";
        log = (String)log + "en [" + this.compressedFile + "]\n";
        log = (String)log + " date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        this.droidFormat = DroidIdentifier.getFileDroidFormat(this.compressedFile);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: droidFormat=" + this.droidFormat, null);
        if (this.encoding == null) {
            this.encoding = ZIP.equals(this.droidFormat) ? "CP850" : "UTF8";
        }
        this.unCompressContainer();
        Path path = Paths.get(this.unCompressDirectory, new String[0]);
        try (Stream<Path> sp = Files.list(path);){
            Iterator pi = sp.iterator();
            while (pi.hasNext()) {
                path = (Path)pi.next();
                if (path.getFileName().toString().equals("__GlobalMetadata.xml")) {
                    this.onDiskGlobalMetadataPath = path;
                    continue;
                }
                this.onDiskRootPaths.add(path);
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Impossible de lister les fichiers du r\u00e9pertoire [" + this.unCompressDirectory + "]", e);
        }
        this.diskToDataObjectPackageImporter = new DiskToDataObjectPackageImporter(this.onDiskRootPaths, true, this.extractTitleFromFileNameFunction, this.sedaLibProgressLogger);
        this.archiveTransfer = new ArchiveTransfer();
        if (this.onDiskGlobalMetadataPath != null) {
            this.archiveTransfer.setGlobalMetadata(this.processGlobalMetadata(this.onDiskGlobalMetadataPath));
        }
        for (String patternString : this.ignorePatternStrings) {
            this.diskToDataObjectPackageImporter.addIgnorePattern(patternString);
        }
        this.diskToDataObjectPackageImporter.doImport();
        this.archiveTransfer.setDataObjectPackage(this.diskToDataObjectPackageImporter.getDataObjectPackage());
        this.end = Instant.now();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: import d'un ArchiveTransfer depuis un fichier compress\u00e9 sur disque termin\u00e9", null);
    }

    public ArchiveTransfer getArchiveTransfer() {
        return this.archiveTransfer;
    }

    public String getSummary() {
        String result = null;
        if (this.archiveTransfer != null) {
            result = this.archiveTransfer.getDescription() + "\n";
            if (this.start != null) {
                result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
            }
        }
        return result;
    }

    private static class SevenZWrapper
    extends ArchiveInputStream {
        private SevenZFile file;

        private SevenZWrapper(SevenZFile file) {
            this.file = file;
        }

        @Override
        public int read() throws IOException {
            return this.file.read();
        }

        @Override
        public int read(byte[] b) throws IOException {
            return this.file.read(b);
        }

        @Override
        public int read(byte[] b, int off, int len) throws IOException {
            return this.file.read(b, off, len);
        }

        public ArchiveEntry getNextEntry() throws IOException {
            return this.file.getNextEntry();
        }

        @Override
        public void close() throws IOException {
            this.file.close();
        }
    }
}

