/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class CSVTreeToDataObjectPackageImporter {
    private String csvFileName;
    private String encoding;
    private char separator;
    private DataObjectPackage dataObjectPackage;
    private Map<String, List<Line>> linesMap;
    Instant start;
    Instant end;
    private SEDALibProgressLogger sedaLibProgressLogger;

    public CSVTreeToDataObjectPackageImporter(String csvFileName, String encoding, char separator, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        Path pathFile = Paths.get(csvFileName, new String[0]);
        if (!Files.isRegularFile(pathFile, LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + csvFileName + "] pointant vers le fichier csv ne d\u00e9signe pas un fichier");
        }
        this.csvFileName = csvFileName;
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.encoding = encoding;
        this.separator = separator;
    }

    private void readCSVFile() throws SEDALibException, InterruptedException {
        int lineCount = 0;
        this.linesMap = new HashMap<String, List<Line>>();
        CsvMapper mapper = new CsvMapper();
        CsvSchema schema = mapper.schemaFor(String[].class).withColumnSeparator(this.separator);
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.csvFileName), this.encoding);
             MappingIterator it = mapper.readerFor(String[].class).with(schema).readValues(isr);){
            while (it.hasNext()) {
                String[] row = (String[])it.next();
                if (++lineCount == 1) continue;
                if (row.length < 5) {
                    throw new SEDALibException("La ligne " + lineCount + " ne contient pas le nombre minimum de champs attendus (5)");
                }
                Line line = new Line(row[0], row[1], row[2], row[3], row[4]);
                if (line.title.isEmpty()) {
                    throw new SEDALibException("Le titre de la ligne " + lineCount + " ne doit pas \u00eatre vide");
                }
                if (line.suffix.isEmpty()) {
                    throw new SEDALibException("Le suffixe de la ligne " + lineCount + " ne doit pas \u00eatre vide");
                }
                List<Line> value = this.linesMap.get(line.motherId);
                if (value == null) {
                    value = new ArrayList<Line>();
                }
                value.add(line);
                this.linesMap.put(line.motherId, value);
                SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, lineCount, "sedalib: " + lineCount + " lignes interpr\u00e9t\u00e9es");
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Le fichier csv [" + this.csvFileName + "] n'est pas accessible");
        }
    }

    private ArchiveUnit addLineAndChildren(Line line) throws InterruptedException {
        ArchiveUnit au = new ArchiveUnit(this.dataObjectPackage);
        Content content = new Content();
        try {
            content.addNewMetadata("Title", line.title);
            if (!line.description.isEmpty()) {
                content.addNewMetadata("Description", line.description);
            }
            if (line.motherId.isEmpty()) {
                content.addNewMetadata("DescriptionLevel", "Series");
            } else {
                content.addNewMetadata("DescriptionLevel", "Subseries");
            }
            content.addNewMetadata("OriginatingAgencyArchiveUnitIdentifier", line.motherId + line.suffix);
        }
        catch (Exception exception) {
            // empty catch block
        }
        au.setContent(content);
        List<Line> childLines = this.linesMap.get(line.motherId + line.suffix);
        if (childLines != null) {
            for (Line childLine : this.linesMap.get(line.motherId + line.suffix)) {
                ArchiveUnit childAu = this.addLineAndChildren(childLine);
                au.addChildArchiveUnit(childAu);
            }
        }
        this.linesMap.remove(line.motherId + line.suffix);
        int counter = this.dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " ArchiveUnit export\u00e9es");
        return au;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'import du fichier csv d'arbre de plan de classement\n";
        log = (String)log + "en [" + this.csvFileName + "]\n";
        log = (String)log + "date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        this.readCSVFile();
        this.dataObjectPackage = new DataObjectPackage();
        this.dataObjectPackage.resetInOutCounter();
        List<Line> rootLines = this.linesMap.get("");
        if (rootLines == null) {
            throw new SEDALibException("Le fichier csv ne contient pas de ligne d\u00e9crivant de s\u00e9rie (champ s\u00e9rie vide)");
        }
        for (Line rootLine : rootLines) {
            ArchiveUnit rootAu = this.addLineAndChildren(rootLine);
            this.dataObjectPackage.addRootAu(rootAu);
        }
        if (this.linesMap.size() > 1) {
            Object error = "Les lignes ayant les identifiants suivant n'appartiennent pas \u00e0 une s\u00e9rie  [";
            Iterator<String> it = this.linesMap.keySet().iterator();
            while (it.hasNext()) {
                for (Line line : this.linesMap.get(it.next())) {
                    error = (String)error + line.uniqId + ", ";
                }
            }
            error = ((String)error).substring(0, ((String)error).length() - 2) + "]";
            throw new SEDALibException((String)error);
        }
        this.end = Instant.now();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: import du fichier csv d'arbre de plan de classement termin\u00e9", null);
    }

    public DataObjectPackage getDataObjectPackage() {
        return this.dataObjectPackage;
    }

    public String getSummary() {
        String result = this.dataObjectPackage.getDescription() + "\n";
        if (this.start != null) {
            result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }

    private class Line {
        String uniqId;
        String title;
        String description;
        String suffix;
        String motherId;

        protected Line(String uniqId, String title, String description, String suffix, String motherId) {
            this.uniqId = uniqId;
            this.title = title;
            this.description = description;
            this.suffix = suffix;
            this.motherId = motherId;
        }
    }
}

