/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import com.fasterxml.jackson.databind.MappingIterator;
import com.fasterxml.jackson.dataformat.csv.CsvMapper;
import com.fasterxml.jackson.dataformat.csv.CsvParser;
import com.fasterxml.jackson.dataformat.csv.CsvSchema;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.inout.importer.CSVMetadataFormatter;
import fr.gouv.vitam.tools.sedalib.inout.importer.DiskToDataObjectPackageImporter;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.file.DirectoryStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class CSVMetadataToDataObjectPackageImporter {
    private String csvMetadataFileName;
    private Path csvMetadataDirectoryPath;
    private String encoding;
    private boolean isExtendedFormat;
    private char separator;
    private DataObjectPackage dataObjectPackage;
    private Instant start;
    private Instant end;
    private Map<String, Line> linesMap;
    private SEDALibProgressLogger sedaLibProgressLogger;

    public CSVMetadataToDataObjectPackageImporter(String csvMetadataFileName, String encoding, char separator, SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        if (!Files.isRegularFile(Paths.get(csvMetadataFileName, new String[0]), LinkOption.NOFOLLOW_LINKS)) {
            throw new SEDALibException("Le chemin [" + csvMetadataFileName + "] pointant vers le fichier csv ne d\u00e9signe pas un fichier");
        }
        this.csvMetadataFileName = csvMetadataFileName;
        this.csvMetadataDirectoryPath = Paths.get(csvMetadataFileName, new String[0]).getParent();
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.encoding = encoding;
        this.separator = separator;
    }

    private boolean readCSVFile() throws SEDALibException, InterruptedException {
        int lineCount = 0;
        CSVMetadataFormatter metadataFormatter = null;
        this.linesMap = new HashMap<String, Line>();
        CsvMapper mapper = new CsvMapper();
        CsvSchema schema = mapper.schemaFor(String[].class).withColumnSeparator(this.separator);
        mapper.enable(CsvParser.Feature.WRAP_AS_ARRAY);
        try (InputStreamReader isr = new InputStreamReader((InputStream)new FileInputStream(this.csvMetadataFileName), this.encoding);
             MappingIterator it = mapper.readerFor(String[].class).with(schema).readValues(isr);){
            while (it.hasNext()) {
                Line currentLine;
                String[] row = (String[])it.next();
                if (++lineCount == 1) {
                    metadataFormatter = new CSVMetadataFormatter(row, Paths.get(this.csvMetadataFileName, new String[0]).toAbsolutePath().getParent());
                    this.isExtendedFormat = metadataFormatter.isExtendedFormat();
                    continue;
                }
                try {
                    currentLine = new Line(metadataFormatter.getGUID(row), metadataFormatter.getParentGUID(row), metadataFormatter.getFile(row), metadataFormatter.getObjectFiles(row), metadataFormatter.doFormatAndExtractContentXML(row), metadataFormatter.extractManagementXML());
                }
                catch (SEDALibException e) {
                    throw new SEDALibException("Erreur sur la ligne " + lineCount, e);
                }
                this.linesMap.put(metadataFormatter.getGUID(row), currentLine);
                SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, lineCount, "sedalib: " + lineCount + " lignes interpr\u00e9t\u00e9es");
            }
        }
        catch (IOException e) {
            throw new SEDALibException("Le fichier csv [" + this.csvMetadataFileName + "] n'est pas accessible");
        }
        if (metadataFormatter != null) {
            return metadataFormatter.needIdRegeneration();
        }
        return false;
    }

    private Path getAbsolutePath(String file) {
        Path path = Paths.get(file, new String[0]);
        if (!path.isAbsolute()) {
            path = this.csvMetadataDirectoryPath.resolve(path);
        }
        return path;
    }

    private ArchiveUnit createLineAU(Line line) throws SEDALibException, InterruptedException {
        ArchiveUnit au;
        block19: {
            au = new ArchiveUnit();
            au.setInDataObjectPackageId("Import-" + line.guid);
            this.dataObjectPackage.addArchiveUnit(au);
            au.setContentXmlData(line.contentXMLMetadata);
            au.getContent();
            if (!line.managementXMLMetadata.isEmpty()) {
                au.setManagementXmlData(line.managementXMLMetadata);
                au.getManagement();
            }
            Path path = this.getAbsolutePath(line.file);
            DataObjectGroup implicitDog = null;
            if (this.isExtendedFormat) {
                for (String objectFile : line.objectFiles) {
                    Path objectPath = this.getAbsolutePath(objectFile);
                    if (!Files.isRegularFile(objectPath, new LinkOption[0])) {
                        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, "sedalib: la r\u00e9f\u00e9rence sur le disque du fichier objet [" + objectFile + "] n'est plus valable", null);
                        continue;
                    }
                    String fileName = path.getFileName().toString();
                    if (objectFile.matches("__\\w+__.+") || objectFile.matches("__\\w+_.+")) {
                        implicitDog = DiskToDataObjectPackageImporter.addBinaryDataObject(this.dataObjectPackage, objectPath, fileName, au, implicitDog);
                        continue;
                    }
                    BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage, objectPath, path.getFileName().toString(), "BinaryMaster_1");
                    au.addDataObjectById(bdo.getInDataObjectPackageId());
                }
            } else if (Files.isRegularFile(path, new LinkOption[0])) {
                BinaryDataObject bdo = new BinaryDataObject(this.dataObjectPackage, path, path.getFileName().toString(), "BinaryMaster_1");
                au.addDataObjectById(bdo.getInDataObjectPackageId());
            } else {
                if (Files.isDirectory(path, new LinkOption[0])) {
                    try (DirectoryStream<Path> stream = Files.newDirectoryStream(path);){
                        for (Path subPath : stream) {
                            String fileName;
                            if (!Files.isRegularFile(subPath, new LinkOption[0]) || !(fileName = path.getFileName().toString()).matches("__\\w+__.+") && !fileName.matches("__\\w+_.+")) continue;
                            implicitDog = DiskToDataObjectPackageImporter.addBinaryDataObject(this.dataObjectPackage, path, fileName, au, implicitDog);
                        }
                        break block19;
                    }
                    catch (IOException e) {
                        throw new SEDALibException("Les fichiers dans le r\u00e9pertoire [" + path + "] ne sont pas accessibles");
                    }
                }
                if (!line.file.isEmpty()) {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, "sedalib: la r\u00e9f\u00e9rence sur le disque de l'archiveUnit [" + line.guid + "] n'est plus valable", null);
                }
            }
        }
        return au;
    }

    private ArchiveUnit createToRoot(Line line) throws SEDALibException, InterruptedException {
        if (line.au == null) {
            line.au = this.createLineAU(line);
            Line parentLine = this.linesMap.get(line.parentGUID);
            if (parentLine == null || parentLine.equals(line)) {
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, "sedalib: archiveUnit [" + line.guid + "] n'a pas de parent, elle est mise en racine", null);
                this.dataObjectPackage.addRootAu(line.au);
            } else {
                ArchiveUnit parentAU = this.createToRoot(parentLine);
                parentAU.addChildArchiveUnit(line.au);
            }
        }
        return line.au;
    }

    public void doImport() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'import du fichier csv de m\u00e9tadonn\u00e9es\n";
        log = (String)log + "en [" + this.csvMetadataFileName + "]\n";
        log = (String)log + "date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        boolean needIdRegeneration = this.readCSVFile();
        this.dataObjectPackage = new DataObjectPackage();
        int lineCount = 0;
        for (Map.Entry<String, Line> entry : this.linesMap.entrySet()) {
            if (entry.getValue().au != null) continue;
            this.createToRoot(entry.getValue());
            SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++lineCount, "sedalib: " + lineCount + " ArchiveUnits import\u00e9es");
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 20, "sedalib: " + lineCount + " ArchiveUnits import\u00e9es", null);
        this.dataObjectPackage.vitamNormalize(this.sedaLibProgressLogger);
        if (needIdRegeneration) {
            this.dataObjectPackage.regenerateContinuousIds();
        }
        lineCount = 0;
        for (Map.Entry<String, Object> entry : this.dataObjectPackage.getBdoInDataObjectPackageIdMap().entrySet()) {
            FileInfo fileInfo = ((BinaryDataObject)entry.getValue()).getMetadataFileInfo();
            if (fileInfo.getSimpleMetadata("LastModified") == null) {
                ((BinaryDataObject)entry.getValue()).extractTechnicalElements(this.sedaLibProgressLogger);
            }
            SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++lineCount, "sedalib: " + lineCount + " fichiers BinaryDataObject analys\u00e9s");
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 20, "sedalib: " + lineCount + " fichiers BinaryDataObject analys\u00e9s et import\u00e9s dans le DataObjectPackage", null);
        this.end = Instant.now();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: import du fichier csv de m\u00e9tadonn\u00e9es termin\u00e9", null);
    }

    public DataObjectPackage getDataObjectPackage() {
        return this.dataObjectPackage;
    }

    public String getSummary() {
        String result = this.dataObjectPackage.getDescription() + "\n";
        if (this.start != null) {
            result = result + "charg\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }

    private class Line {
        String guid;
        String parentGUID;
        String file;
        List<String> objectFiles;
        String contentXMLMetadata;
        String managementXMLMetadata;
        ArchiveUnit au;

        public Line(String guid, String parentGUID, String file, String objectFiles, String contentXMLMetadata, String managementXMLMetadata) {
            this.guid = guid;
            this.parentGUID = parentGUID;
            this.file = file;
            this.objectFiles = objectFiles.trim().isEmpty() ? Arrays.asList(new String[0]) : Arrays.asList(objectFiles.split("\\|"));
            this.contentXMLMetadata = contentXMLMetadata;
            this.managementXMLMetadata = managementXMLMetadata;
            this.au = null;
        }
    }
}

