/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.importer;

import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.xml.HtmlAndXmlEscape;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashMap;
import java.util.List;

public class CSVMetadataFormatter {
    private static final String ID = "id";
    private static final String FILE = "file";
    private static final String PARENTID = "parentid";
    private static final String PARENTFILE = "parentfile";
    private static final String OBJECTFILES = "objectfiles";
    private static final List<String> MANDATORY_TRAILING_HEADERS = Arrays.asList("id", "file", "parentid", "parentfile", "objectfiles");
    private MetadataTag rootTag;
    private MetadataTag contentTag;
    private MetadataTag managementTag;
    private LinkedHashMap<Integer, ValueAttrMetadataTag> tagHeaderColumnMapping;
    private int numberOfMandatoryHeaderFound;
    private int columnCount;
    private Path baseDir;
    private int guidColumn;
    private int fileColumn;
    private int objectfilesColumn;
    private int parentGUIDColumn;
    private boolean isOnlyFile;

    private void analyseFirstColumns(String[] headerRow) throws SEDALibException {
        String header;
        ArrayList<String> firstsMandatoryHeadersFound = new ArrayList<String>();
        for (int i = 0; i < 4 && MANDATORY_TRAILING_HEADERS.contains(header = headerRow[i].toLowerCase()); ++i) {
            firstsMandatoryHeadersFound.add(header);
        }
        this.numberOfMandatoryHeaderFound = firstsMandatoryHeadersFound.size();
        if (this.numberOfMandatoryHeaderFound == 1 && firstsMandatoryHeadersFound.contains(FILE)) {
            this.isOnlyFile = true;
            this.guidColumn = 0;
            this.fileColumn = 0;
            this.objectfilesColumn = -1;
            this.parentGUIDColumn = -1;
        } else if (this.numberOfMandatoryHeaderFound == 2 && firstsMandatoryHeadersFound.containsAll(List.of(FILE, PARENTFILE))) {
            this.isOnlyFile = false;
            this.fileColumn = this.guidColumn = firstsMandatoryHeadersFound.indexOf(FILE);
            this.objectfilesColumn = -1;
            this.parentGUIDColumn = firstsMandatoryHeadersFound.indexOf(PARENTFILE);
        } else if (this.numberOfMandatoryHeaderFound == 3 && firstsMandatoryHeadersFound.containsAll(List.of(FILE, PARENTFILE, ID))) {
            this.isOnlyFile = false;
            this.guidColumn = firstsMandatoryHeadersFound.indexOf(ID);
            this.fileColumn = firstsMandatoryHeadersFound.indexOf(FILE);
            this.objectfilesColumn = -1;
            this.parentGUIDColumn = firstsMandatoryHeadersFound.indexOf(PARENTFILE);
        } else if (this.numberOfMandatoryHeaderFound == 3 && firstsMandatoryHeadersFound.containsAll(List.of(FILE, PARENTID, ID))) {
            this.isOnlyFile = false;
            this.guidColumn = firstsMandatoryHeadersFound.indexOf(ID);
            this.fileColumn = firstsMandatoryHeadersFound.indexOf(FILE);
            this.objectfilesColumn = -1;
            this.parentGUIDColumn = firstsMandatoryHeadersFound.indexOf(PARENTID);
        } else if (this.numberOfMandatoryHeaderFound == 3 && firstsMandatoryHeadersFound.containsAll(List.of(OBJECTFILES, PARENTID, ID))) {
            this.isOnlyFile = false;
            this.guidColumn = firstsMandatoryHeadersFound.indexOf(ID);
            this.fileColumn = -1;
            this.objectfilesColumn = firstsMandatoryHeadersFound.indexOf(OBJECTFILES);
            this.parentGUIDColumn = firstsMandatoryHeadersFound.indexOf(PARENTID);
        } else if (this.numberOfMandatoryHeaderFound == 4 && firstsMandatoryHeadersFound.containsAll(List.of(FILE, OBJECTFILES, PARENTID, ID))) {
            this.isOnlyFile = false;
            this.guidColumn = firstsMandatoryHeadersFound.indexOf(ID);
            this.objectfilesColumn = firstsMandatoryHeadersFound.indexOf(OBJECTFILES);
            this.fileColumn = firstsMandatoryHeadersFound.indexOf(FILE);
            this.parentGUIDColumn = firstsMandatoryHeadersFound.indexOf(PARENTID);
        } else {
            throw new SEDALibException("Le header [" + String.join((CharSequence)"|", headerRow) + "] est mal formatt\u00e9. Il doit contenir au d\u00e9but soit une colonne File, soit deux colonnes File et ParentFile, soit trois colonnes ID, File et ParentFile ou ID, File , soit quatre colonnes ID, ParentID, File, ObjectFiles et ParentID.");
        }
    }

    private MetadataTag getInSubTagsMap(MetadataTag tag, String name, int rank) throws SEDALibException {
        List<MetadataTag> subTags;
        if (tag.subTags == null) {
            tag.subTags = new LinkedHashMap();
        } else if (tag.subTags.get(rank) != null) {
            for (MetadataTag subTag : tag.subTags.get(rank)) {
                if (!subTag.name.equals(name)) continue;
                return subTag;
            }
        }
        MetadataTag subTag = new MetadataTag(name, tag);
        if (tag.name == null) {
            if (name.equals("Content")) {
                this.contentTag = subTag;
            } else if (name.equals("Management")) {
                this.managementTag = subTag;
            } else {
                throw new SEDALibException("M\u00e9tadonn\u00e9es [" + name + "] non conforme SEDA.");
            }
        }
        if ((subTags = tag.subTags.get(rank)) == null) {
            subTags = new ArrayList<MetadataTag>();
            subTags.add(subTag);
            tag.subTags.put(rank, subTags);
        } else {
            subTags.add(subTag);
        }
        return subTag;
    }

    private MetadataTag getTag(MetadataTag tag, List<String> splittedMetadataName) throws SEDALibException {
        if (splittedMetadataName.isEmpty()) {
            return tag;
        }
        String name = splittedMetadataName.get(0);
        if (splittedMetadataName.size() == 1 && name.equals("attr")) {
            return tag;
        }
        int rank = 0;
        if (splittedMetadataName.size() > 1) {
            try {
                rank = Integer.parseInt(splittedMetadataName.get(1));
                splittedMetadataName.remove(0);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        MetadataTag subTag = this.getInSubTagsMap(tag, name, rank);
        splittedMetadataName.remove(0);
        return this.getTag(subTag, splittedMetadataName);
    }

    private void analyseTags(String[] headerRow) throws SEDALibException {
        MetadataTag currentTag = null;
        if (headerRow.length <= this.numberOfMandatoryHeaderFound) {
            throw new SEDALibException("Pas de colonne de m\u00e9tadonn\u00e9es.");
        }
        if (headerRow[this.numberOfMandatoryHeaderFound].startsWith("Content.") || headerRow[this.numberOfMandatoryHeaderFound].startsWith("Management.")) {
            this.rootTag = new MetadataTag(null, null);
            this.contentTag = null;
        } else {
            this.contentTag = this.rootTag = new MetadataTag("Content", null);
        }
        this.managementTag = null;
        this.tagHeaderColumnMapping = new LinkedHashMap();
        for (int i = this.numberOfMandatoryHeaderFound; i < headerRow.length; ++i) {
            ValueAttrMetadataTag vamt;
            if (headerRow[i].equalsIgnoreCase("attr")) {
                if (currentTag == null) {
                    throw new SEDALibException("Le header attr en colonne n\u00b0" + i + " ne peut pas s'appliquer.");
                }
                vamt = new ValueAttrMetadataTag(false, currentTag);
            } else if (headerRow[i].endsWith(".attr")) {
                currentTag = this.getTag(this.rootTag, new ArrayList<String>(Arrays.asList(headerRow[i].split("\\."))));
                vamt = new ValueAttrMetadataTag(false, currentTag);
            } else {
                currentTag = this.getTag(this.rootTag, new ArrayList<String>(Arrays.asList(headerRow[i].split("\\."))));
                vamt = new ValueAttrMetadataTag(true, currentTag);
            }
            this.tagHeaderColumnMapping.put(i, vamt);
        }
        if (this.contentTag == null) {
            throw new SEDALibException("Pas de colonne de m\u00e9tadonn\u00e9es Content.");
        }
    }

    public CSVMetadataFormatter(String[] headerRow, Path baseDir) throws SEDALibException {
        this.baseDir = baseDir;
        this.analyseFirstColumns(headerRow);
        this.analyseTags(headerRow);
        this.columnCount = headerRow.length;
    }

    private void resetValues() {
        this.tagHeaderColumnMapping.values().stream().forEach(valueAttr -> {
            valueAttr.tag.value = null;
            valueAttr.tag.attr = null;
        });
    }

    private void defineColumnValue(int headerColumn, String cell) {
        ValueAttrMetadataTag vamt = this.tagHeaderColumnMapping.get(headerColumn);
        if (vamt.isValue) {
            vamt.tag.value = cell;
        } else {
            vamt.tag.attr = cell;
        }
    }

    private String getOneSubTagXML(MetadataTag tag, String subTagName) {
        Object result = "";
        for (List<MetadataTag> tagList : tag.subTags.values()) {
            for (MetadataTag mt : tagList) {
                if (!mt.name.equals(subTagName) || mt.value.isEmpty()) continue;
                result = (String)result + "<" + subTagName + ">" + HtmlAndXmlEscape.escapeXml(mt.value) + "</" + subTagName + ">";
                mt.value = null;
            }
        }
        return result;
    }

    private boolean notEmptyValues(MetadataTag tag) {
        boolean result = false;
        if (tag.subTags == null) {
            return tag.value != null && !tag.value.isEmpty();
        }
        for (List<MetadataTag> tagList : tag.subTags.values()) {
            for (MetadataTag subTag : tagList) {
                result = result || this.notEmptyValues(subTag);
            }
        }
        return result;
    }

    private String generateRuleTypeTagXML(MetadataTag tag) throws SEDALibException {
        Object result = "";
        for (List<MetadataTag> tagList : tag.subTags.values()) {
            for (MetadataTag mt : tagList) {
                if (!mt.name.equals("Rule") || mt.value.isEmpty()) continue;
                result = (String)result + "<Rule>" + HtmlAndXmlEscape.escapeXml(mt.value) + "</Rule>";
                mt.value = null;
            }
            for (MetadataTag mt : tagList) {
                if (!mt.name.equals("StartDate") || mt.value.isEmpty()) continue;
                result = (String)result + "<StartDate>" + HtmlAndXmlEscape.escapeXml(mt.value) + "</StartDate>";
                mt.value = null;
            }
        }
        result = (String)result + this.getOneSubTagXML(tag, "PreventInheritance");
        result = (String)result + this.getOneSubTagXML(tag, "RefNonRuleId");
        result = (String)result + this.getOneSubTagXML(tag, "FinalAction");
        if (this.notEmptyValues(tag)) {
            throw new SEDALibException("La r\u00e8gle [" + tag.name + "] contient des champs non conformes SEDA.");
        }
        if (!((String)result).isEmpty()) {
            result = "<" + tag.name + ">" + (String)result + "</" + tag.name + ">";
        }
        return result;
    }

    private String generateHoldRuleTagXML(MetadataTag tag) throws SEDALibException {
        StringBuilder result = new StringBuilder();
        for (List<MetadataTag> tagList : tag.subTags.values()) {
            block19: for (MetadataTag mt : tagList) {
                if (mt.value.isEmpty()) continue;
                switch (mt.name) {
                    case "Rule": {
                        result.append("<Rule>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</Rule>");
                        break;
                    }
                    case "StartDate": {
                        result.append("<StartDate>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</StartDate>");
                        break;
                    }
                    case "HoldEndDate": {
                        result.append("<HoldEndDate>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</HoldEndDate>");
                        break;
                    }
                    case "HoldOwner": {
                        result.append("<HoldOwner>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</HoldOwner>");
                        break;
                    }
                    case "HoldReassessingDate": {
                        result.append("<HoldReassessingDate>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</HoldReassessingDate>");
                        break;
                    }
                    case "HoldReason": {
                        result.append("<HoldReason>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</HoldReason>");
                        break;
                    }
                    case "PreventRearrangement": {
                        result.append("<PreventRearrangement>").append(HtmlAndXmlEscape.escapeXml(mt.value)).append("</PreventRearrangement>");
                        break;
                    }
                    default: {
                        continue block19;
                    }
                }
                mt.value = null;
            }
        }
        result.append(this.getOneSubTagXML(tag, "PreventInheritance"));
        result.append(this.getOneSubTagXML(tag, "RefNonRuleId"));
        if (this.notEmptyValues(tag)) {
            throw new SEDALibException("La r\u00e8gle [" + tag.name + "] contient des champs non conformes SEDA.");
        }
        if (result.length() > 0) {
            result = new StringBuilder("<" + tag.name + ">" + result + "</" + tag.name + ">");
        }
        return result.toString();
    }

    private String generateClassificationRuleTagXML(MetadataTag tag) throws SEDALibException {
        Object result = "";
        for (List<MetadataTag> tagList : tag.subTags.values()) {
            for (MetadataTag mt : tagList) {
                if (!mt.name.equals("Rule") || mt.value.isEmpty()) continue;
                result = (String)result + "<Rule>" + HtmlAndXmlEscape.escapeXml(mt.value) + "</Rule>";
                mt.value = null;
            }
            for (MetadataTag mt : tagList) {
                if (!mt.name.equals("StartDate") || mt.value.isEmpty()) continue;
                result = (String)result + "<StartDate>" + HtmlAndXmlEscape.escapeXml(mt.value) + "</StartDate>";
                mt.value = null;
            }
        }
        result = (String)result + this.getOneSubTagXML(tag, "PreventInheritance");
        result = (String)result + this.getOneSubTagXML(tag, "RefNonRuleId");
        result = (String)result + this.getOneSubTagXML(tag, "FinalAction");
        result = (String)result + this.getOneSubTagXML(tag, "ClassificationLevel");
        result = (String)result + this.getOneSubTagXML(tag, "ClassificationOwner");
        result = (String)result + this.getOneSubTagXML(tag, "ClassificationReassessingDate");
        result = (String)result + this.getOneSubTagXML(tag, "NeedReassessingAuthorization");
        if (this.notEmptyValues(tag)) {
            throw new SEDALibException("La r\u00e8gle [" + tag.name + "] contient des champs non conformes SEDA.");
        }
        if (!((String)result).isEmpty()) {
            result = "<" + tag.name + ">" + (String)result + "</" + tag.name + ">";
        }
        return result;
    }

    /*
     * WARNING - void declaration
     */
    private String generateTagXML(MetadataTag tag) throws SEDALibException {
        Object result;
        void var5_12;
        Object value = "";
        String string = tag.name;
        int n = -1;
        switch (string.hashCode()) {
            case 851397280: {
                if (!string.equals("AccessRule")) break;
                boolean bl = false;
                break;
            }
            case 303346529: {
                if (!string.equals("AppraisalRule")) break;
                boolean bl = true;
                break;
            }
            case -438701889: {
                if (!string.equals("DisseminationRule")) break;
                int n2 = 2;
                break;
            }
            case 1894709104: {
                if (!string.equals("ReuseRule")) break;
                int n3 = 3;
                break;
            }
            case 1142243319: {
                if (!string.equals("StorageRule")) break;
                int n4 = 4;
                break;
            }
            case -351496158: {
                if (!string.equals("ClassificationRule")) break;
                int n5 = 5;
                break;
            }
            case -451154821: {
                if (!string.equals("HoldRule")) break;
                int n6 = 6;
            }
        }
        switch (var5_12) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                return this.generateRuleTypeTagXML(tag);
            }
            case 5: {
                return this.generateClassificationRuleTagXML(tag);
            }
            case 6: {
                return this.generateHoldRuleTagXML(tag);
            }
        }
        if (tag.subTags != null) {
            for (List list : tag.subTags.values()) {
                for (MetadataTag subTag : list) {
                    value = (String)value + this.generateTagXML(subTag);
                }
            }
        }
        if (((String)value).isEmpty() && (tag.value == null || tag.value.isEmpty()) && (tag.attr == null || tag.attr.isEmpty())) {
            return "";
        }
        if (!((String)value).isEmpty() && tag.value != null && !tag.value.isEmpty()) {
            throw new SEDALibException("Il ne peut y avoir une valeur et des sous-\u00e9l\u00e9ments dans un \u00e9l\u00e9ment SEDA [" + tag + "].");
        }
        if (tag.name != null) {
            result = "<" + tag.name;
            if (tag.attr != null && !tag.attr.isEmpty()) {
                result = (String)result + " " + tag.attr;
            }
            result = (String)result + ">";
            result = !((String)value).isEmpty() ? (String)result + (String)value : (String)result + HtmlAndXmlEscape.escapeXml(tag.value);
            result = (String)result + "</" + tag.name + ">";
        } else {
            result = value;
        }
        return result;
    }

    public String doFormatAndExtractContentXML(String[] row) throws SEDALibException {
        if (row.length != this.columnCount) {
            throw new SEDALibException("Il n'y a pas le bon nombre d'\u00e9l\u00e9ments sur la ligne.");
        }
        this.resetValues();
        for (int i = this.numberOfMandatoryHeaderFound; i < row.length; ++i) {
            this.defineColumnValue(i, row[i]);
        }
        return this.generateTagXML(this.contentTag);
    }

    public String extractManagementXML() throws SEDALibException {
        if (this.managementTag == null) {
            return "";
        }
        return this.generateTagXML(this.managementTag);
    }

    public String getGUID(String[] row) {
        if (this.guidColumn == this.fileColumn) {
            return this.getFile(row);
        }
        return row[this.guidColumn];
    }

    public String getParentGUID(String[] row) {
        if (this.isOnlyFile) {
            return Paths.get(this.getFile(row), new String[0]).getParent().toString();
        }
        return row[this.parentGUIDColumn];
    }

    public String getFile(String[] row) {
        return this.baseDir.resolve(row[this.fileColumn]).toAbsolutePath().normalize().toString();
    }

    public String getObjectFiles(String[] row) {
        if (this.objectfilesColumn == -1) {
            return "";
        }
        return row[this.objectfilesColumn];
    }

    public boolean needIdRegeneration() {
        return this.isOnlyFile;
    }

    public boolean isExtendedFormat() {
        return this.objectfilesColumn != -1;
    }

    private class ValueAttrMetadataTag {
        boolean isValue;
        MetadataTag tag;

        public ValueAttrMetadataTag(boolean isValue, MetadataTag tag) {
            this.isValue = isValue;
            this.tag = tag;
        }
    }

    private class MetadataTag {
        String name;
        String value;
        String attr;
        MetadataTag parent;
        LinkedHashMap<Integer, List<MetadataTag>> subTags;

        protected MetadataTag(String name, MetadataTag parent) throws SEDALibException {
            if (name != null && !name.matches("[a-zA-Z0-9_-]+")) {
                throw new SEDALibException("Caract\u00e8re interdit dans le tag XML [" + name + "]");
            }
            this.name = name;
            this.value = null;
            this.attr = null;
            this.subTags = null;
            this.parent = parent;
        }

        public String toString() {
            if (this.parent == null) {
                return this.name;
            }
            return this.parent.toString() + "." + this.name;
        }
    }
}

