/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.exporter;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.DataObjectRefList;
import fr.gouv.vitam.tools.sedalib.core.PhysicalDataObject;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.IndentXMLTool;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import mslinks.ShellLink;

public class DataObjectPackageToDiskExporter {
    static final Path emptyPath = Paths.get("", new String[0]);
    private DataObjectPackage dataObjectPackage = null;
    private boolean isWindows;
    private SEDALibProgressLogger sedaLibProgressLogger;
    private HashMap<ArchiveUnit, Path> auPathStringMap;
    private HashMap<DataObjectGroup, Path> dogPathStringMap;
    private Set<Path> filesPathSet;

    private DataObjectPackageToDiskExporter(SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.auPathStringMap = new HashMap();
        this.dogPathStringMap = new HashMap();
        this.filesPathSet = new HashSet<Path>();
        this.isWindows = System.getProperty("os.name").toLowerCase().contains("win");
    }

    public DataObjectPackageToDiskExporter(DataObjectPackage dataObjectPackage, SEDALibProgressLogger sedaLibProgressLogger) {
        this(sedaLibProgressLogger);
        this.dataObjectPackage = dataObjectPackage;
    }

    private String constructFileName(BinaryDataObject binaryDataObject) {
        StringType dataObjectVersion = binaryDataObject.getMetadataDataObjectVersion();
        Object result = dataObjectVersion == null ? "__undefined__" : "__" + dataObjectVersion.getValue() + "__";
        FileInfo fileInfo = binaryDataObject.getMetadataFileInfo();
        result = fileInfo != null && fileInfo.getSimpleMetadata("Filename") != null ? (String)result + fileInfo.getSimpleMetadata("Filename") : (String)result + "NoName";
        return this.stripFileName((String)result);
    }

    private String constructMetadataFileName(BinaryDataObject binaryDataObject) {
        StringType dataObjectVersion = binaryDataObject.getMetadataDataObjectVersion();
        Object result = dataObjectVersion == null ? "__undefined__BinaryDataObjectMetadata.xml" : "__" + dataObjectVersion.getValue() + "__BinaryDataObjectMetadata.xml";
        return this.stripFileName((String)result);
    }

    private String constructMetadataFileName(PhysicalDataObject physicalDataObject) {
        StringType dataObjectVersion = physicalDataObject.getMetadataDataObjectVersion();
        Object result = dataObjectVersion == null ? "__undefined__PhysicalDataObjectMetadata.xml" : "__" + dataObjectVersion.getValue() + "__PhysicalDataObjectMetadata.xml";
        return this.stripFileName((String)result);
    }

    private String constructDirectoryName(ArchiveUnit au) throws SEDALibException {
        Object result = "";
        if (au.getContent() != null) {
            result = au.getContent().getSimpleMetadata("Title");
            if (result == null) {
                result = "NoTitle";
            } else if (((String)result).length() > 12) {
                result = ((String)result).substring(0, 11);
            }
            result = ((String)result).replaceAll("[^\\p{IsAlphabetic}\\p{Digit}]", "-");
            result = (String)result + "_";
        }
        result = (String)result + au.getInDataObjectPackageId();
        return this.stripFileName((String)result);
    }

    private String stripFileName(String fileName) {
        String filteredName = fileName.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|,]", "_");
        while (filteredName.endsWith(".") || filteredName.endsWith(" ")) {
            filteredName = filteredName.substring(0, filteredName.length() - 1);
        }
        return filteredName;
    }

    public void exportManagementMetadata(String xmlData, Path containerPath) throws SEDALibException {
        Path targetOnDiskPath = containerPath.resolve("__ManagementMetadata.xml");
        this.filesPathSet.add(targetOnDiskPath);
        try (FileOutputStream fos = new FileOutputStream(targetOnDiskPath.toFile());
             OutputStreamWriter rawWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            String identXml;
            try {
                identXml = IndentXMLTool.getInstance(2).indentString(xmlData);
            }
            catch (Exception e) {
                identXml = xmlData;
            }
            rawWriter.write(identXml);
        }
        catch (Exception e) {
            throw new SEDALibException("Ecriture des ManagementMetadata [" + targetOnDiskPath + "] impossible\n->" + e.getMessage());
        }
    }

    private void determineExplicitDataObjectGroupInArchiveUnit(ArchiveUnit archiveUnit) {
        boolean complexDataObjectRefList = archiveUnit.getDataObjectRefList().getDataObjectList().size() > 1;
        for (DataObject zdo : archiveUnit.getDataObjectRefList().getDataObjectList()) {
            if (!(zdo instanceof DataObjectGroup)) continue;
            if (complexDataObjectRefList || this.dataObjectPackage.isTouchedInDataObjectPackageId(zdo.getInDataObjectPackageId())) {
                this.dogPathStringMap.put((DataObjectGroup)zdo, emptyPath);
                continue;
            }
            this.dataObjectPackage.addTouchedInDataObjectPackageId(zdo.getInDataObjectPackageId());
        }
        for (ArchiveUnit childAu : archiveUnit.getChildrenAuList().getArchiveUnitList()) {
            this.determineExplicitDataObjectGroupInArchiveUnit(childAu);
        }
    }

    private void determineExplicitDataObjectGroupMap() {
        this.dataObjectPackage.resetTouchedInDataObjectPackageIdMap();
        for (ArchiveUnit au : this.dataObjectPackage.getGhostRootAu().getChildrenAuList().getArchiveUnitList()) {
            this.determineExplicitDataObjectGroupInArchiveUnit(au);
        }
    }

    public void exportBinaryDataObject(BinaryDataObject bdo, Path containerPath) throws SEDALibException {
        Path targetOnDiskPath = containerPath.resolve(this.constructFileName(bdo));
        if (this.filesPathSet.contains(targetOnDiskPath)) {
            throw new SEDALibException("Collision de fichiers de repr\u00e9sentation [" + targetOnDiskPath.toString() + "] d\u00e9tect\u00e9e sur le BinaryDataObject [" + bdo.getInDataObjectPackageId() + "]");
        }
        this.filesPathSet.add(targetOnDiskPath);
        try {
            Files.copy(bdo.getOnDiskPath(), targetOnDiskPath, StandardCopyOption.REPLACE_EXISTING);
        }
        catch (IOException e) {
            throw new SEDALibException("Ecriture du BinaryDataObject [" + bdo.getInDataObjectPackageId() + "] impossible\n->" + e.getMessage());
        }
        targetOnDiskPath = containerPath.resolve(this.constructMetadataFileName(bdo));
        if (this.filesPathSet.contains(targetOnDiskPath)) {
            throw new SEDALibException("Collision de fichiers de repr\u00e9sentation [" + targetOnDiskPath.toString() + "] d\u00e9tect\u00e9e sur le BinaryDataObject [" + bdo.getInDataObjectPackageId() + "]");
        }
        this.filesPathSet.add(targetOnDiskPath);
        try {
            Files.write(targetOnDiskPath, bdo.toSedaXmlFragments().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Ecriture des m\u00e9tadonn\u00e9es du BinaryDataObject [" + bdo.getInDataObjectPackageId() + "] impossible\n->" + e.getMessage());
        }
    }

    private void exportPhysicalDataObject(PhysicalDataObject pdo, Path containerPath) throws SEDALibException {
        Path targetOnDiskPath = containerPath.resolve(this.constructMetadataFileName(pdo));
        if (this.filesPathSet.contains(targetOnDiskPath)) {
            throw new SEDALibException("Collision de fichiers de repr\u00e9sentation [" + targetOnDiskPath.toString() + "] d\u00e9tect\u00e9e sur le PhysicalDataObject [" + pdo.getInDataObjectPackageId() + "]");
        }
        this.filesPathSet.add(targetOnDiskPath);
        try {
            Files.write(targetOnDiskPath, pdo.toSedaXmlFragments().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Ecriture des m\u00e9tadonn\u00e9es du PhysicalDataObject [" + pdo.getInDataObjectPackageId() + "] impossible\n->" + e.getMessage());
        }
    }

    private void exportDataObjectGroupContent(DataObjectGroup dog, Path containerPath) throws SEDALibException {
        for (BinaryDataObject bdo : dog.getBinaryDataObjectList()) {
            this.exportBinaryDataObject(bdo, containerPath);
        }
        for (PhysicalDataObject pdo : dog.getPhysicalDataObjectList()) {
            this.exportPhysicalDataObject(pdo, containerPath);
        }
    }

    private Path exportDataObjectGroup(DataObjectGroup dog, Path containerPath) throws SEDALibException {
        Path targetOnDiskPath = containerPath.resolve("##DataObjectGroup-" + dog.getInDataObjectPackageId() + "##");
        try {
            Files.createDirectories(targetOnDiskPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire [" + targetOnDiskPath + "] impossible\n->" + e.getMessage());
        }
        this.exportDataObjectGroupContent(dog, targetOnDiskPath);
        return targetOnDiskPath;
    }

    private void exportLink(Path target, Path containerPath, String newLink) throws SEDALibException, InterruptedException {
        Path linkOnDiskPath = containerPath.resolve(newLink);
        if (this.filesPathSet.contains(linkOnDiskPath)) {
            throw new SEDALibException("Collision de fichiers de repr\u00e9sentation [" + linkOnDiskPath.toString() + "] pour la cr\u00e9ation d'un lien");
        }
        this.filesPathSet.add(linkOnDiskPath);
        try {
            if (Files.exists(linkOnDiskPath, LinkOption.NOFOLLOW_LINKS)) {
                Files.delete(linkOnDiskPath);
            }
            Files.createSymbolicLink(linkOnDiskPath, linkOnDiskPath.toAbsolutePath().getParent().relativize(target.toAbsolutePath()), new FileAttribute[0]);
        }
        catch (Exception e) {
            if (this.isWindows) {
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 50, "sedalib: la cr\u00e9ation de lien n'a pas pu avoir lieu, essai de cr\u00e9ation de raccourci sous Windows", e);
                ShellLink sl = new ShellLink();
                sl.setTarget(target.toString());
                try {
                    if (Files.exists(Paths.get(linkOnDiskPath.toString() + ".lnk", new String[0]), LinkOption.NOFOLLOW_LINKS)) {
                        Files.delete(Paths.get(linkOnDiskPath.toString() + ".lnk", new String[0]));
                    }
                    sl.saveTo(linkOnDiskPath.toString() + ".lnk");
                }
                catch (IOException e1) {
                    throw new SEDALibException("Cr\u00e9ation du lien et du raccourci [" + linkOnDiskPath + "] impossible", e1);
                }
            }
            throw new SEDALibException("Cr\u00e9ation du lien [" + linkOnDiskPath + "] impossible\n->" + e.getMessage());
        }
    }

    private void exportDataObjectRefList(DataObjectRefList dorl, Path auPath) throws SEDALibException, InterruptedException {
        for (DataObject zdo : dorl.getDataObjectList()) {
            if (zdo instanceof DataObjectGroup) {
                Path dogPath = this.dogPathStringMap.get(zdo);
                if (dogPath == null) {
                    this.exportDataObjectGroupContent((DataObjectGroup)zdo, auPath);
                    continue;
                }
                if (dogPath == emptyPath) {
                    this.dogPathStringMap.put((DataObjectGroup)zdo, this.exportDataObjectGroup((DataObjectGroup)zdo, auPath));
                    continue;
                }
                this.exportLink(dogPath, auPath, "##DataObjectGroup##");
                continue;
            }
            if (zdo instanceof BinaryDataObject) {
                this.exportBinaryDataObject((BinaryDataObject)zdo, auPath);
                continue;
            }
            if (!(zdo instanceof PhysicalDataObject)) continue;
            this.exportPhysicalDataObject((PhysicalDataObject)zdo, auPath);
        }
    }

    private void exportArchiveUnit(ArchiveUnit au, Path containerPath) throws SEDALibException, InterruptedException {
        if (this.auPathStringMap.containsKey(au)) {
            this.exportLink(this.auPathStringMap.get(au), containerPath, this.constructDirectoryName(au));
        } else {
            Path targetOnDiskPath = containerPath.resolve(this.constructDirectoryName(au));
            try {
                Files.createDirectories(targetOnDiskPath, new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire [" + targetOnDiskPath + "] pour l'ArchiveUnit [" + au.getInDataObjectPackageId() + "] impossible\n->" + e.getMessage());
            }
            Path auPath = targetOnDiskPath;
            targetOnDiskPath = auPath.resolve("__ArchiveUnitMetadata.xml");
            if (this.filesPathSet.contains(targetOnDiskPath)) {
                throw new SEDALibException("Collision de fichiers de repr\u00e9sentation [" + targetOnDiskPath.toString() + "] d\u00e9tect\u00e9e sur l'ArchiveUnit [" + au.getInDataObjectPackageId() + "]");
            }
            this.filesPathSet.add(targetOnDiskPath);
            try {
                Files.write(targetOnDiskPath, au.toSedaXmlFragments().getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (Exception e) {
                throw new SEDALibException("Ecriture des m\u00e9tadonn\u00e9es de l'ArchiveUnit [" + au.getInDataObjectPackageId() + "] impossible\n->" + e.getMessage());
            }
            this.exportDataObjectRefList(au.getDataObjectRefList(), auPath);
            this.auPathStringMap.put(au, auPath);
            for (ArchiveUnit childAu : au.getChildrenAuList().getArchiveUnitList()) {
                this.exportArchiveUnit(childAu, auPath);
            }
            int counter = this.dataObjectPackage.getNextInOutCounter();
            SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, "sedalib: " + counter + " ArchiveUnit export\u00e9es");
        }
    }

    public void doExport(String directoryName) throws SEDALibException, InterruptedException {
        Path exportPath = Paths.get(directoryName, new String[0]);
        try {
            Files.createDirectories(exportPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire d'export [" + exportPath + "] impossible\n->" + e.getMessage());
        }
        this.dataObjectPackage.resetInOutCounter();
        this.determineExplicitDataObjectGroupMap();
        if (this.dataObjectPackage.getManagementMetadataXmlData() != null) {
            this.exportManagementMetadata(this.dataObjectPackage.getManagementMetadataXmlData(), exportPath);
        }
        for (ArchiveUnit au : this.dataObjectPackage.getGhostRootAu().getChildrenAuList().getArchiveUnitList()) {
            this.exportArchiveUnit(au, exportPath);
        }
    }
}

