/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.exporter;

import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.data.FileInfo;
import fr.gouv.vitam.tools.sedalib.metadata.management.Management;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListMetadataKind;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.ComplexListType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.RuleType;
import fr.gouv.vitam.tools.sedalib.metadata.namedtype.StringType;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import java.io.UnsupportedEncodingException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.io.FileUtils;

public class DataObjectPackageToCSVMetadataExporter {
    private DataObjectPackage dataObjectPackage;
    private String encoding;
    private char separator;
    private int usageVersionSelectionMode;
    public static final int FIRST_DATAOBJECT = 1;
    public static final int LAST_DATAOBJECT = 2;
    public static final int ALL_DATAOBJECTS = 3;
    private boolean extendedFormatFlag;
    private int maxNameSize;
    private SEDALibProgressLogger sedaLibProgressLogger;
    private int exportAction;
    private static final int ALL_DISK_EXPORT = 1;
    private static final int METADATA_FILE_EXPORT = 2;
    private static final int ALL_ZIP_EXPORT = 3;
    private Instant start;
    private Instant end;
    private String zipFileName;
    private String csvMetadataFileName;
    private Path rootPath;
    private boolean fileExportFlag;
    private ZipOutputStream zipOS;
    private HashMap<ArchiveUnit, Path> auRelativePathMap;
    private HashSet<String> relativePathStringSet;
    private List<String> headerNames;
    private ByteArrayOutputStream csvBAOS;
    private PrintStream csvPrintStream;

    public DataObjectPackageToCSVMetadataExporter(DataObjectPackage dataObjectPackage, String encoding, char separator, int usageVersionSelectionMode, boolean extendedFormatFlag, int maxNameSize, SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.dataObjectPackage = dataObjectPackage;
        this.encoding = encoding;
        this.separator = separator;
        this.usageVersionSelectionMode = usageVersionSelectionMode;
        this.extendedFormatFlag = extendedFormatFlag;
        this.maxNameSize = maxNameSize;
    }

    private int getMaxRank(Set<String> headerNames, String name) {
        if (headerNames.contains(name)) {
            return 0;
        }
        int pos = name.split("\\.").length;
        int maxRank = -1;
        for (String tmp : headerNames) {
            String[] splittedTmp;
            if (!tmp.startsWith(name)) continue;
            if (maxRank == -1) {
                maxRank = 0;
            }
            if ((splittedTmp = tmp.split("\\.")).length <= pos) continue;
            try {
                maxRank = Math.max(maxRank, Integer.parseInt(splittedTmp[pos]) + 1);
            }
            catch (NumberFormatException numberFormatException) {}
        }
        return maxRank;
    }

    private List<String> getRuleTypeHeaderNames(Set<String> headerNames, String ruleName) {
        ArrayList<String> ruleHeaderNames = new ArrayList<String>();
        int rank = 0;
        while (headerNames.contains(ruleName + ".Rule." + rank)) {
            ruleHeaderNames.add(ruleName + ".Rule." + rank);
            List<String> ruleMetadataKindList = Arrays.asList("StartDate", "HoldEndDate", "HoldOwner", "HoldReassessingDate", "HoldReason", "PreventRearrangement");
            for (String ruleHeaderName : ruleMetadataKindList) {
                if (!headerNames.contains(ruleName + "." + ruleHeaderName + "." + rank)) continue;
                ruleHeaderNames.add(ruleName + "." + ruleHeaderName + "." + rank);
            }
            ++rank;
        }
        if (headerNames.contains(ruleName + ".PreventInheritance")) {
            ruleHeaderNames.add(ruleName + ".PreventInheritance");
        }
        if (headerNames.contains(ruleName + ".ClassificationLevel")) {
            ruleHeaderNames.add(ruleName + ".ClassificationLevel");
        }
        if (headerNames.contains(ruleName + ".ClassificationOwner")) {
            ruleHeaderNames.add(ruleName + ".ClassificationOwner");
        }
        if (headerNames.contains(ruleName + ".ClassificationReassessingDate")) {
            ruleHeaderNames.add(ruleName + ".ClassificationReassessingDate");
        }
        if (headerNames.contains(ruleName + ".NeedReassessingAuthorization")) {
            ruleHeaderNames.add(ruleName + ".NeedReassessingAuthorization");
        }
        rank = 0;
        while (headerNames.contains(ruleName + ".RefNonRuleId." + rank)) {
            ruleHeaderNames.add(ruleName + ".RefNonRuleId." + rank);
            ++rank;
        }
        if (headerNames.contains(ruleName + ".FinalAction")) {
            ruleHeaderNames.add(ruleName + ".FinalAction");
        }
        return ruleHeaderNames;
    }

    private List<String> getSortedHeaderNames(List<String> sortedHeaderNames, Set<String> headerNames, String prefixHeaderName, String xmlElementName, Class<?> metadataClass) throws SEDALibException {
        String currentName = prefixHeaderName + (prefixHeaderName.isEmpty() ? "" : ".") + xmlElementName;
        int maxRank = this.getMaxRank(headerNames, currentName);
        if (maxRank != -1) {
            Object infix = maxRank == 0 ? "" : ".0";
            int i = 0;
            do {
                if (RuleType.class.isAssignableFrom(metadataClass)) {
                    List<String> ruleHeaderNames = this.getRuleTypeHeaderNames(headerNames, currentName + (String)infix);
                    sortedHeaderNames.addAll(ruleHeaderNames);
                    headerNames.removeAll(ruleHeaderNames);
                } else if (ComplexListType.class.isAssignableFrom(metadataClass)) {
                    for (Map.Entry entry : ComplexListType.getMetadataMap(metadataClass).entrySet()) {
                        this.getSortedHeaderNames(sortedHeaderNames, headerNames, currentName + (String)infix, (String)entry.getKey(), ((ComplexListMetadataKind)entry.getValue()).getMetadataClass());
                    }
                    TreeSet<String> extensions = new TreeSet<String>();
                    for (String header : headerNames) {
                        if (!header.startsWith(currentName + ".")) continue;
                        extensions.add(header);
                    }
                    headerNames.removeAll(extensions);
                    sortedHeaderNames.addAll(extensions);
                } else {
                    sortedHeaderNames.add(currentName + (String)infix);
                    headerNames.remove(currentName + (String)infix);
                    if (headerNames.contains(currentName + (String)infix + ".attr")) {
                        sortedHeaderNames.add(currentName + (String)infix + ".attr");
                        headerNames.remove(currentName + (String)infix + ".attr");
                    }
                }
                infix = "." + ++i;
            } while (i < maxRank);
        }
        return sortedHeaderNames;
    }

    private void computeCsvHeader() throws SEDALibException {
        HashSet<String> curHeaderNames = new HashSet<String>();
        for (ArchiveUnit au : this.dataObjectPackage.getAuInDataObjectPackageIdMap().values()) {
            Management management = au.getManagement();
            if (management != null) {
                curHeaderNames.addAll(management.externToCsvList().keySet());
            }
            curHeaderNames.addAll(au.getContent().externToCsvList(this.dataObjectPackage.getExportMetadataList()).keySet());
        }
        List<String> sortedHeaderNames = this.getSortedHeaderNames(new ArrayList<String>(), curHeaderNames, "", "Content", Content.class);
        sortedHeaderNames.addAll(this.getSortedHeaderNames(new ArrayList<String>(), curHeaderNames, "", "Management", Management.class));
        this.headerNames = sortedHeaderNames;
    }

    private List<String> getSimplifiedHeaderNames() {
        ArrayList<String> simplifiedHeaderNames = new ArrayList<String>(this.headerNames);
        for (int i = 0; i < simplifiedHeaderNames.size(); ++i) {
            String header = (String)simplifiedHeaderNames.get(i);
            int pos = 0;
            while (header.indexOf(".0", pos) != -1) {
                pos = header.indexOf(".0", pos);
                String headerRoot = header.substring(0, pos);
                boolean onlyZero = true;
                for (int j = i + 1; j < simplifiedHeaderNames.size(); ++j) {
                    if (!((String)simplifiedHeaderNames.get(j)).startsWith(headerRoot + ".1")) continue;
                    onlyZero = false;
                    break;
                }
                if (onlyZero) {
                    for (int k = i; k < simplifiedHeaderNames.size(); ++k) {
                        Object toSimplifyheader = (String)simplifiedHeaderNames.get(k);
                        if (!((String)toSimplifyheader).startsWith(headerRoot + ".")) continue;
                        toSimplifyheader = headerRoot + ((String)toSimplifyheader).substring(headerRoot.length() + 2);
                        simplifiedHeaderNames.set(k, (String)toSimplifyheader);
                    }
                }
                ++pos;
                header = (String)simplifiedHeaderNames.get(i);
            }
        }
        return simplifiedHeaderNames;
    }

    private void printCsvHeader() {
        List<String> simplifiedHeaderNames = this.getSimplifiedHeaderNames();
        if (this.extendedFormatFlag) {
            this.csvPrintStream.print("Id" + this.separator);
            this.csvPrintStream.print("ParentId" + this.separator);
        }
        this.csvPrintStream.print("File");
        if (this.extendedFormatFlag) {
            this.csvPrintStream.print(this.separator + "ObjectFiles");
        }
        for (String header : simplifiedHeaderNames) {
            this.csvPrintStream.print(this.separator + header);
        }
        this.csvPrintStream.println();
    }

    private String getSimplifiedPath(Path path) {
        if (path == null) {
            return "";
        }
        if (path.isAbsolute()) {
            try {
                path = this.rootPath.relativize(path);
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return path.toString().replace("\"", "\"\"");
    }

    private void generateCsvLine(ArchiveUnit au, ArchiveUnit parentAu, Path auRelativePath) throws SEDALibException {
        Object value;
        LinkedHashMap<String, String> managementMetadataHashMap = null;
        if (this.extendedFormatFlag) {
            this.csvPrintStream.print("\"" + au.getInDataObjectPackageId() + "\"" + this.separator);
            if (parentAu == null) {
                this.csvPrintStream.print("\"\"" + this.separator);
            } else {
                this.csvPrintStream.print("\"" + parentAu.getInDataObjectPackageId() + "\"" + this.separator);
            }
        }
        if (this.fileExportFlag) {
            value = "\"" + auRelativePath.toString().replace("\"", "\"\"") + "\"";
            this.csvPrintStream.print((String)value);
        } else {
            this.csvPrintStream.print("\"" + this.getSimplifiedPath(au.getOnDiskPath()) + "\"");
        }
        if (this.extendedFormatFlag) {
            value = "";
            DataObjectGroup dog = au.getTheDataObjectGroup();
            if (dog != null) {
                List<BinaryDataObject> bdoList = dog.getBinaryDataObjectList();
                if (au.getChildrenAuList().getArchiveUnitList().isEmpty() && bdoList.size() == 1) {
                    value = this.fileExportFlag ? this.getSimplifiedPath(auRelativePath) : this.getSimplifiedPath(bdoList.get(0).getOnDiskPath());
                } else {
                    for (BinaryDataObject bdo : bdoList) {
                        Path objectPath = this.fileExportFlag ? auRelativePath.resolve(this.constructObjectFileName(auRelativePath, bdo, bdoList.size() == 1, false)) : bdo.getOnDiskPath();
                        value = (String)value + "|" + this.getSimplifiedPath(objectPath);
                    }
                    if (!((String)value).isEmpty()) {
                        value = ((String)value).substring(1);
                    }
                }
            }
            this.csvPrintStream.print(this.separator + "\"" + (String)value + "\"");
        }
        LinkedHashMap<String, String> contentMetadataHashMap = au.getContent().externToCsvList(this.dataObjectPackage.getExportMetadataList());
        Management management = au.getManagement();
        if (management != null) {
            managementMetadataHashMap = management.externToCsvList();
        }
        for (String header : this.headerNames) {
            value = contentMetadataHashMap.get(header);
            if (value == null && managementMetadataHashMap != null) {
                value = managementMetadataHashMap.get(header);
            }
            value = value == null ? "" : "\"" + ((String)value).replace("\"", "\"\"") + "\"";
            this.csvPrintStream.print(this.separator + (String)value);
        }
        this.csvPrintStream.println();
    }

    private BinaryDataObject getBestUsageVersionObject(List<BinaryDataObject> objectList, boolean firstFlag) throws InterruptedException {
        int rank;
        TreeMap<Integer, BinaryDataObject> rankMap = new TreeMap<Integer, BinaryDataObject>();
        for (BinaryDataObject bdo : objectList) {
            int version2;
            StringType dataObjectVersion = bdo.getMetadataDataObjectVersion();
            if (dataObjectVersion == null || dataObjectVersion.getValue().isEmpty()) {
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 50, "Un objet binaire n'a pas d'usage_version, il ne peut \u00eatre choisi pour l'extraction", null);
                continue;
            }
            String[] usageVersion = dataObjectVersion.getValue().split("_");
            switch (usageVersion[0]) {
                case "BinaryMaster": {
                    rank = 0;
                    break;
                }
                case "Dissemination": {
                    rank = 1;
                    break;
                }
                case "TextContent": {
                    rank = 2;
                    break;
                }
                case "Thumbnail": {
                    rank = 3;
                    break;
                }
                default: {
                    rank = 4;
                }
            }
            if (usageVersion.length == 1) {
                version2 = 1;
            } else {
                try {
                    version2 = Integer.parseInt(usageVersion[1]);
                }
                catch (NumberFormatException e) {
                    SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 50, "Un objet binaire n'a pas d'usage_version, il ne peut \u00eatre choisi pour l'extraction", e);
                    continue;
                }
            }
            rankMap.put(rank * 1000 + version2, bdo);
        }
        if (rankMap.size() == 0) {
            return null;
        }
        if (firstFlag) {
            return (BinaryDataObject)rankMap.firstEntry().getValue();
        }
        rank = (Integer)rankMap.firstKey() / 1000;
        BinaryDataObject bdo = null;
        for (Map.Entry e : rankMap.entrySet()) {
            if (rank != (Integer)e.getKey() / 1000) break;
            bdo = (BinaryDataObject)e.getValue();
        }
        return bdo;
    }

    private List<BinaryDataObject> getArchiveUnitObjectList(ArchiveUnit au) throws InterruptedException {
        if (au.getDataObjectRefList() == null || au.getDataObjectRefList().getCount() == 0) {
            return null;
        }
        ArrayList<BinaryDataObject> objectList = new ArrayList<BinaryDataObject>();
        for (DataObject dataObject : au.getDataObjectRefList().getDataObjectList()) {
            if (dataObject instanceof BinaryDataObject) {
                objectList.add((BinaryDataObject)dataObject);
                continue;
            }
            if (!(dataObject instanceof DataObjectGroup)) continue;
            objectList.addAll(((DataObjectGroup)dataObject).getBinaryDataObjectList());
        }
        if (this.usageVersionSelectionMode == 3) {
            return objectList;
        }
        return Collections.singletonList(this.getBestUsageVersionObject(objectList, this.usageVersionSelectionMode == 1));
    }

    private String stripFileName(String fileName) {
        String filteredName = fileName.replaceAll("[\\/|\\\\|\\*|\\:|\\||\"|'|\\<|\\>|\\{|\\}|\\?|\\%|,]", "_");
        while (filteredName.endsWith(".") || filteredName.endsWith(" ")) {
            filteredName = filteredName.substring(0, filteredName.length() - 1);
        }
        return filteredName;
    }

    private String constructArchiveUnitDirectoryName(Path auRrelativePath, ArchiveUnit au) throws SEDALibException {
        Object dirName = "";
        if (au.getContent() != null) {
            dirName = au.getContent().getSimpleMetadata("Title");
            if (dirName == null) {
                dirName = "NoTitle";
            }
            if (this.maxNameSize > 0 && ((String)dirName).length() > this.maxNameSize) {
                dirName = ((String)dirName).substring(0, this.maxNameSize);
            }
            dirName = this.stripFileName((String)dirName);
            if (this.fileExists(auRrelativePath.resolve((String)(dirName = ((String)dirName).trim())))) {
                String id = this.stripFileName("-" + au.getInDataObjectPackageId());
                dirName = this.maxNameSize <= 0 ? (String)dirName + id : (id.length() >= this.maxNameSize ? id : (id.length() + ((String)dirName).length() <= this.maxNameSize ? (String)dirName + id : ((String)dirName).substring(0, this.maxNameSize - id.length()) + id));
            }
        }
        return dirName;
    }

    private String constructObjectFileName(Path auRrelativePath, BinaryDataObject bdo, boolean uniqFlag, boolean firstTime) {
        String ext;
        Object name;
        int point;
        String filename = null;
        FileInfo fileInfo = bdo.getMetadataFileInfo();
        if (fileInfo != null) {
            filename = fileInfo.getSimpleMetadata("Filename");
        }
        if (filename == null) {
            filename = "undefined";
        }
        if ((point = filename.lastIndexOf(46)) == -1) {
            name = filename;
            ext = "";
        } else {
            name = filename.substring(0, point);
            ext = filename.substring(point);
        }
        if (!uniqFlag) {
            StringType dataObjectVersion = bdo.getMetadataDataObjectVersion();
            String usageVersion = dataObjectVersion == null ? "undefined_1" : dataObjectVersion.getValue();
            name = "__" + usageVersion + "__" + (String)name;
        }
        if (firstTime) {
            filename = this.stripFileName((String)name + ext);
            if (this.fileExists(auRrelativePath.resolve(filename))) {
                filename = this.stripFileName((String)name + "-" + bdo.getInDataObjectPackageId() + ext);
            }
        } else {
            filename = this.stripFileName((String)name + "-" + bdo.getInDataObjectPackageId() + ext);
            if (!this.fileExists(auRrelativePath.resolve(filename))) {
                filename = this.stripFileName((String)name + ext);
            }
        }
        return filename;
    }

    private boolean fileExists(Path relativePath) {
        return this.relativePathStringSet.contains(relativePath.toString());
    }

    private void createDirectories(Path relativePath) throws SEDALibException {
        if (this.zipOS == null) {
            try {
                Files.createDirectories(relativePath == null ? this.rootPath : this.rootPath.resolve(relativePath), new FileAttribute[0]);
            }
            catch (Exception e) {
                throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire [" + (relativePath == null ? this.rootPath : this.rootPath.resolve(relativePath)) + "] impossible", e);
            }
        }
        if (relativePath != null && !this.relativePathStringSet.contains(relativePath.toString())) {
            try {
                ZipEntry e = new ZipEntry((relativePath.toString() + File.separator).replace('\\', '/'));
                this.zipOS.putNextEntry(e);
                this.zipOS.closeEntry();
            }
            catch (IOException e) {
                throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire [" + relativePath.toString() + "] dans le zip [" + this.rootPath.resolve(this.zipFileName).toString() + "] impossible", e);
            }
        }
        if (relativePath != null) {
            this.relativePathStringSet.add(relativePath.toString());
        }
    }

    private void writeString(Path relativePath, String content) throws SEDALibException {
        if (this.zipOS == null) {
            try {
                Files.write(this.rootPath.resolve(relativePath), content.getBytes(StandardCharsets.UTF_8), new OpenOption[0]);
            }
            catch (IOException e) {
                throw new SEDALibException("Ecriture du fichier  [" + this.rootPath.resolve(relativePath).toString() + "] impossible", e);
            }
        }
        try {
            ZipEntry e = new ZipEntry(relativePath.toString().replace('\\', '/'));
            this.zipOS.putNextEntry(e);
            this.zipOS.write(content.getBytes(StandardCharsets.UTF_8));
            this.zipOS.closeEntry();
        }
        catch (IOException e) {
            throw new SEDALibException("Ecriture du fichier [" + relativePath.toString() + "] dans le zip [" + this.rootPath.resolve(this.zipFileName).toString() + "] impossible", e);
        }
        this.relativePathStringSet.add(relativePath.toString());
    }

    private void copyFile(Path originPath, Path relativePath) throws SEDALibException {
        if (this.zipOS == null) {
            try {
                Files.copy(originPath, this.rootPath.resolve(relativePath), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new SEDALibException("Ecriture du fichier  [" + this.rootPath.resolve(relativePath).toString() + "] impossible", e);
            }
        }
        try {
            ZipEntry e = new ZipEntry(relativePath.toString().replace('\\', '/'));
            this.zipOS.putNextEntry(e);
            try (FileInputStream fis = new FileInputStream(originPath.toFile());){
                int l;
                byte[] buffer = new byte[65536];
                while ((l = fis.read(buffer)) != -1) {
                    this.zipOS.write(buffer, 0, l);
                }
            }
            this.zipOS.closeEntry();
        }
        catch (IOException e) {
            throw new SEDALibException("Ecriture du fichier [" + relativePath.toString() + "] dans le zip [" + this.rootPath.resolve(this.zipFileName).toString() + "] impossible", e);
        }
        this.relativePathStringSet.add(relativePath.toString());
    }

    private void exportLink(ArchiveUnit au, Path auRelativePath) throws SEDALibException, InterruptedException {
        Path originAURelativePath = this.auRelativePathMap.get(au);
        Path auPath = this.rootPath.resolve(auRelativePath).resolve(originAURelativePath.getFileName().toString() + ".link");
        boolean linkFlag = false;
        if (this.zipOS == null) {
            try {
                this.createDirectories(auPath.getParent());
                Files.createSymbolicLink(auPath.toAbsolutePath(), auPath.getParent().relativize(this.rootPath.resolve(originAURelativePath)), new FileAttribute[0]);
                linkFlag = true;
            }
            catch (IOException e) {
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 50, "Lien vers [" + this.rootPath.resolve(originAURelativePath).toString() + "] n'a pas pu \u00eatre cr\u00e9\u00e9", e);
            }
        }
        if (!linkFlag) {
            this.writeString(this.rootPath.toAbsolutePath().relativize(auPath), "Link to " + originAURelativePath.toString());
        }
    }

    private String exportObjectList(Path auRelativePath, List<BinaryDataObject> objectList) throws SEDALibException {
        String filename = null;
        if (this.fileExportFlag) {
            this.createDirectories(auRelativePath);
        }
        if (objectList != null && !objectList.isEmpty()) {
            for (BinaryDataObject bdo : objectList) {
                filename = this.constructObjectFileName(auRelativePath, bdo, objectList.size() == 1, true);
                if (!this.fileExportFlag) continue;
                this.copyFile(bdo.getOnDiskPath(), auRelativePath.resolve(filename));
            }
        }
        return filename;
    }

    private void exportArchiveUnit(ArchiveUnit au, ArchiveUnit parentAu, Path relativePath) throws SEDALibException, InterruptedException {
        if (this.auRelativePathMap.containsKey(au)) {
            if (this.fileExportFlag) {
                this.exportLink(au, relativePath);
            }
            return;
        }
        List<BinaryDataObject> objectList = this.getArchiveUnitObjectList(au);
        Path auRelativePath = au.getChildrenAuList() != null && au.getChildrenAuList().getCount() != 0 || objectList == null || objectList.size() != 1 ? relativePath.resolve(this.constructArchiveUnitDirectoryName(relativePath, au)) : relativePath;
        String filename = this.exportObjectList(auRelativePath, objectList);
        if (auRelativePath == relativePath) {
            auRelativePath = auRelativePath.resolve(filename);
        }
        this.auRelativePathMap.put(au, auRelativePath);
        if (au.getChildrenAuList() != null && au.getChildrenAuList().getCount() != 0) {
            for (ArchiveUnit childAU : au.getChildrenAuList().getArchiveUnitList()) {
                this.exportArchiveUnit(childAU, au, auRelativePath);
            }
        }
        this.generateCsvLine(au, parentAu, auRelativePath);
        int counter = this.dataObjectPackage.getNextInOutCounter();
        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, counter, "sedalib: " + Integer.toString(counter) + " ArchiveUnit export\u00e9es");
    }

    private String getDescription(Date d) {
        Object log = "D\u00e9but de l'export csv simplifi\u00e9";
        log = !this.fileExportFlag ? (String)log + " (csv seul)\n" : (String)log + " (csv et fichiers)\n";
        log = this.zipFileName != null ? (String)log + "dans le zip [" + this.rootPath.resolve(this.zipFileName).toString() + "]" : (String)log + "dans le r\u00e9pertoire [" + this.rootPath.toString() + "]";
        log = (String)log + " date=" + DateFormat.getDateTimeInstance().format(d);
        return log;
    }

    private void defineZipOutputStreamOrNull(Path rootPath, String zipFileName) throws SEDALibException {
        if (zipFileName == null) {
            this.zipOS = null;
        } else {
            try {
                this.zipOS = new ZipOutputStream(new FileOutputStream(rootPath.resolve(zipFileName).toFile()));
            }
            catch (IOException e) {
                throw new SEDALibException("Cr\u00e9ation du conteneur zip [" + rootPath.resolve(zipFileName).toString() + "] impossible", e);
            }
        }
    }

    private void createCsvBAOSPrintScream() throws SEDALibException {
        try {
            this.csvBAOS = new ByteArrayOutputStream();
            this.csvPrintStream = new PrintStream((OutputStream)this.csvBAOS, true, this.encoding);
        }
        catch (UnsupportedEncodingException e) {
            throw new SEDALibException("Encodage [" + this.encoding + "] inconnu", e);
        }
    }

    private void finaliseWithCsvMetadataFile() throws SEDALibException {
        this.csvPrintStream.flush();
        if (this.zipOS != null) {
            try {
                ZipEntry e = new ZipEntry(this.csvMetadataFileName);
                this.zipOS.putNextEntry(e);
                this.zipOS.write(this.csvBAOS.toByteArray());
                this.zipOS.closeEntry();
                this.zipOS.close();
                this.zipOS = null;
            }
            catch (IOException e) {
                throw new SEDALibException("Finalisation du conteneur zip [" + this.rootPath.resolve(this.zipFileName).toString() + "] avec sauvegarde du fichier de m\u00e9tadonn\u00e9es [" + this.csvMetadataFileName + "] impossible", e);
            }
        }
        try {
            FileUtils.writeByteArrayToFile(this.rootPath.resolve(this.csvMetadataFileName).toFile(), this.csvBAOS.toByteArray());
        }
        catch (IOException e) {
            throw new SEDALibException("Finalisation de l'export en [" + this.rootPath.toString() + "] avec sauvegarde du fichier de m\u00e9tadonn\u00e9es [" + this.csvMetadataFileName + "] impossible", e);
        }
        this.csvPrintStream.close();
        this.csvPrintStream = null;
        this.csvBAOS = null;
    }

    private void exportAll() throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        String log = "sedalib: d\u00e9but de l'export d'un csv " + (this.fileExportFlag ? "et de sa hi\u00e9rarchie" : "") + (this.zipFileName == null ? " dans un zip" : "") + "\n";
        log = log + "en [" + (this.fileExportFlag ? (this.zipFileName == null ? this.rootPath : this.rootPath.resolve(this.zipFileName)) : this.rootPath.resolve(this.csvMetadataFileName)) + "] date=";
        log = log + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, log, null);
        this.auRelativePathMap = new HashMap();
        this.relativePathStringSet = new HashSet();
        this.createDirectories(null);
        this.defineZipOutputStreamOrNull(this.rootPath, this.zipFileName);
        this.createCsvBAOSPrintScream();
        this.computeCsvHeader();
        this.printCsvHeader();
        this.dataObjectPackage.resetInOutCounter();
        for (ArchiveUnit au : this.dataObjectPackage.getGhostRootAu().getChildrenAuList().getArchiveUnitList()) {
            this.exportArchiveUnit(au, null, Paths.get("", new String[0]));
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 30, "sedalib: " + this.dataObjectPackage.getInOutCounter() + " ArchiveUnit export\u00e9es", null);
        this.finaliseWithCsvMetadataFile();
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: export csv simplifi\u00e9 termin\u00e9", null);
        this.end = Instant.now();
    }

    public void doExportToCSVMetadataFile(String csvMetadataFilePathName) throws SEDALibException, InterruptedException {
        this.rootPath = Paths.get(csvMetadataFilePathName, new String[0]).toAbsolutePath().getParent().normalize();
        this.zipFileName = null;
        this.csvMetadataFileName = Paths.get(csvMetadataFilePathName, new String[0]).getFileName().toString();
        this.fileExportFlag = false;
        this.exportAll();
        this.exportAction = 2;
    }

    public void doExportToCSVDiskHierarchy(String dirPathName, String csvMetadataFileName) throws SEDALibException, InterruptedException {
        this.rootPath = Paths.get(dirPathName, new String[0]).toAbsolutePath().normalize();
        this.zipFileName = null;
        this.csvMetadataFileName = csvMetadataFileName;
        this.fileExportFlag = true;
        this.exportAll();
        this.exportAction = 1;
    }

    public void doExportToCSVZip(String zipFilePathName, String csvMetadataFileName) throws SEDALibException, InterruptedException {
        this.rootPath = Paths.get(zipFilePathName, new String[0]).toAbsolutePath().getParent().normalize();
        this.zipFileName = Paths.get(zipFilePathName, new String[0]).getFileName().toString();
        this.csvMetadataFileName = csvMetadataFileName;
        this.fileExportFlag = true;
        this.exportAll();
        this.exportAction = 3;
    }

    public String getSummary() {
        Object result = "Export d'un DataObjectPackage en ";
        switch (this.exportAction) {
            case 1: {
                result = (String)result + "hi\u00e9rarchie disque simplifi\u00e9e avec le fichier csv des m\u00e9tadonn\u00e9es\n";
                break;
            }
            case 3: {
                result = (String)result + "zip contenant hi\u00e9rarchie simplifi\u00e9e avec le fichier csv des m\u00e9tadonn\u00e9es\n";
                break;
            }
            case 2: {
                result = (String)result + "fichier csv des m\u00e9tadonn\u00e9es\n";
                break;
            }
            default: {
                result = (String)result + "???\n";
            }
        }
        if (this.start != null && this.end != null) {
            result = (String)result + "effectu\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

