/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.exporter;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectGroup;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayOutputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.xml.stream.XMLStreamException;
import org.apache.commons.io.IOUtils;

public class ArchiveTransferToSIPExporter {
    protected ArchiveTransfer archiveTransfer;
    private Path exportPath;
    private boolean hierarchicalFlag;
    private boolean indentedFlag;
    protected SEDAXMLStreamWriter xmlWriter;
    private Instant start;
    private Instant end;
    private SEDALibProgressLogger sedaLibProgressLogger;
    private boolean manifestOnly;

    public ArchiveTransferToSIPExporter(ArchiveTransfer archiveTransfer, SEDALibProgressLogger sedaLibProgressLogger) {
        this.archiveTransfer = archiveTransfer;
        this.sedaLibProgressLogger = sedaLibProgressLogger;
    }

    public void exportManifestOutputStream(OutputStream os, boolean hierarchicalFlag, boolean indentedFlag) throws SEDALibException, InterruptedException {
        try (SEDAXMLStreamWriter ixsw = new SEDAXMLStreamWriter(os, indentedFlag ? 2 : 0);){
            this.xmlWriter = ixsw;
            this.archiveTransfer.toSedaXml(this.xmlWriter, hierarchicalFlag, this.sedaLibProgressLogger);
        }
        catch (XMLStreamException e) {
            throw new SEDALibException("Echec d'\u00e9criture XML du manifest", e);
        }
    }

    public void doExportToSEDAXMLManifest(String fileName, boolean hierarchicalFlag, boolean indentedFlag) throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'export d'un ArchiveTransfer dans un manifest SEDA\n";
        log = (String)log + "en [" + fileName + "] date=";
        log = (String)log + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        this.exportPath = Paths.get(fileName, new String[0]);
        this.hierarchicalFlag = hierarchicalFlag;
        this.indentedFlag = indentedFlag;
        this.manifestOnly = true;
        try (FileOutputStream fos = new FileOutputStream(fileName);){
            this.exportManifestOutputStream(fos, hierarchicalFlag, indentedFlag);
        }
        catch (SEDALibException | IOException e) {
            throw new SEDALibException("Echec de l'export du manifest dans le fichier [" + fileName + "]", e);
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: export termin\u00e9", null);
        this.end = Instant.now();
    }

    public String getSEDAXMLManifest(boolean hierarchicalFlag, boolean indentedFlag) throws SEDALibException, InterruptedException {
        String result;
        Date d = new Date();
        this.start = Instant.now();
        Object log = "sedalib: d\u00e9but de l'export d'un ArchiveTransfer dans un manifest SEDA\n";
        log = (String)log + "en cha\u00eene de caract\u00e8res interne date=";
        log = (String)log + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        this.hierarchicalFlag = hierarchicalFlag;
        this.indentedFlag = indentedFlag;
        this.manifestOnly = true;
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            this.exportManifestOutputStream(baos, hierarchicalFlag, indentedFlag);
            result = baos.toString("UTF8");
        }
        catch (SEDALibException | IOException e) {
            throw new SEDALibException("Echec de l'export du manifest", e);
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: export termin\u00e9", null);
        this.end = Instant.now();
        return result;
    }

    public void doExportToSEDASIP(String fileName, boolean hierarchicalFlag, boolean indentedFlag) throws SEDALibException, InterruptedException {
        block16: {
            int counter = 0;
            Date d = new Date();
            this.start = Instant.now();
            Object log = "sedalib: d\u00e9but de l'export d'un ArchiveTransfer dans un SIP\n";
            log = (String)log + "en [" + fileName + "] date=";
            log = (String)log + DateFormat.getDateTimeInstance().format(d);
            SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
            this.exportPath = Paths.get(fileName, new String[0]);
            this.hierarchicalFlag = hierarchicalFlag;
            this.indentedFlag = indentedFlag;
            this.manifestOnly = false;
            try {
                Files.createDirectories(Paths.get(fileName, new String[0]).toAbsolutePath().getParent(), new FileAttribute[0]);
            }
            catch (IOException e1) {
                throw new SEDALibException("Impossible de cr\u00e9er le r\u00e9pertoire [" + Paths.get(fileName, new String[0]).toAbsolutePath().getParent().toString() + "]", e1);
            }
            try (ZipOutputStream zipout = new ZipOutputStream(new FileOutputStream(fileName));){
                ZipEntry e = new ZipEntry("manifest.xml");
                zipout.putNextEntry(e);
                this.exportManifestOutputStream(zipout, hierarchicalFlag, indentedFlag);
                zipout.closeEntry();
                SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: manifest export\u00e9", null);
                if (this.archiveTransfer.getDataObjectPackage().getDataObjectGroupCount() <= 0) break block16;
                for (Map.Entry<String, DataObjectGroup> pair : this.archiveTransfer.getDataObjectPackage().getDogInDataObjectPackageIdMap().entrySet()) {
                    DataObjectGroup og = pair.getValue();
                    if (og.getBinaryDataObjectList() == null) continue;
                    for (BinaryDataObject bo : og.getBinaryDataObjectList()) {
                        e = new ZipEntry(bo.getMetadataUri().getValue());
                        zipout.putNextEntry(e);
                        try (FileInputStream fis = new FileInputStream(bo.getOnDiskPath().toFile());){
                            IOUtils.copy((InputStream)fis, (OutputStream)zipout);
                        }
                        zipout.closeEntry();
                        SEDALibProgressLogger.doProgressLogIfStep(this.sedaLibProgressLogger, 30, ++counter, "sedalib: " + counter + " fichiers BinaryDataObject export\u00e9s");
                    }
                }
            }
            catch (SEDALibException | IOException e) {
                throw new SEDALibException("Echec de l'export du SIP dans le fichier [" + fileName + "]", e);
            }
        }
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: export d'un ArchiveTransfer dans un SIP termin\u00e9", null);
        this.end = Instant.now();
    }

    public String getSummary() {
        Object result = "Export d'un ArchiveTransfer dans un ";
        result = this.manifestOnly ? (String)result + "manifest SEDA\n" : (String)result + "SIP\n";
        result = (String)result + "en [" + this.exportPath + "]\n";
        result = this.hierarchicalFlag ? (String)result + "avec une structure imbriqu\u00e9e " : (String)result + "avec une structure \u00e0 plat ";
        result = this.indentedFlag ? (String)result + "en XML ident\u00e9\n" : (String)result + "en XML continu\n";
        if (this.start != null && this.end != null) {
            result = (String)result + "effectu\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

