/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout.exporter;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.inout.exporter.DataObjectPackageToDiskExporter;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.text.DateFormat;
import java.time.Duration;
import java.time.Instant;
import java.util.Date;

public class ArchiveTransferToDiskExporter {
    private DataObjectPackageToDiskExporter dataObjectPackageToDiskExporter;
    private Path exportPath;
    private final ArchiveTransfer archiveTransfer;
    private Instant start;
    private Instant end;
    private final SEDALibProgressLogger sedaLibProgressLogger;

    public ArchiveTransferToDiskExporter(ArchiveTransfer archiveTransfer, SEDALibProgressLogger sedaLibProgressLogger) {
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.archiveTransfer = archiveTransfer;
        this.dataObjectPackageToDiskExporter = new DataObjectPackageToDiskExporter(archiveTransfer.getDataObjectPackage(), sedaLibProgressLogger);
    }

    public void exportArchiveTransferGlobalMetadata(GlobalMetadata globalMetadata, Path containerPath) throws SEDALibException {
        Path targetOnDiskPath = containerPath.resolve("__GlobalMetadata.xml");
        try (FileOutputStream fos = new FileOutputStream(targetOnDiskPath.toFile());
             OutputStreamWriter rawWriter = new OutputStreamWriter((OutputStream)fos, StandardCharsets.UTF_8);){
            rawWriter.write(globalMetadata.toSedaXmlFragments());
        }
        catch (Exception e) {
            throw new SEDALibException("Ecriture des m\u00e9tadonn\u00e9es globales [" + targetOnDiskPath + "] impossible\n->" + e.getMessage());
        }
    }

    public void doExport(String directoryName) throws SEDALibException, InterruptedException {
        Date d = new Date();
        this.start = Instant.now();
        Object log = "D\u00e9but de l'export d'un ArchiveTransfer dans une hi\u00e9rarchie sur disque\n";
        log = (String)log + "en [" + directoryName + "]";
        log = (String)log + " date=" + DateFormat.getDateTimeInstance().format(d);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, (String)log, null);
        this.exportPath = Paths.get(directoryName, new String[0]);
        try {
            Files.createDirectories(this.exportPath, new FileAttribute[0]);
        }
        catch (Exception e) {
            throw new SEDALibException("Cr\u00e9ation du r\u00e9pertoire d'export [" + this.exportPath + "] impossible\n->" + e.getMessage());
        }
        if (this.archiveTransfer.getGlobalMetadata() != null) {
            this.exportArchiveTransferGlobalMetadata(this.archiveTransfer.getGlobalMetadata(), this.exportPath);
        }
        this.dataObjectPackageToDiskExporter.doExport(directoryName);
        SEDALibProgressLogger.doProgressLog(this.sedaLibProgressLogger, 10, "sedalib: export d'un ArchiveTransfer dans une hi\u00e9rarchie sur disque termin\u00e9", null);
        this.end = Instant.now();
    }

    public String getSummary() {
        Object result = "Export d'un ArchiveTransfer dans une hi\u00e9rarchie sur disque\n";
        result = (String)result + "en [" + this.exportPath + "]\n";
        result = (String)result + "encod\u00e9 selon un mod\u00e8le V2 de la structure\n";
        if (this.start != null && this.end != null) {
            result = (String)result + "effectu\u00e9 en " + Duration.between(this.start, this.end).toString().substring(2) + "\n";
        }
        return result;
    }
}

