/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.inout;

import fr.gouv.vitam.tools.sedalib.core.ArchiveTransfer;
import fr.gouv.vitam.tools.sedalib.core.ArchiveUnit;
import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.GlobalMetadata;
import fr.gouv.vitam.tools.sedalib.inout.exporter.ArchiveTransferToSIPExporter;
import fr.gouv.vitam.tools.sedalib.inout.importer.CSVMetadataToDataObjectPackageImporter;
import fr.gouv.vitam.tools.sedalib.inout.importer.DiskToDataObjectPackageImporter;
import fr.gouv.vitam.tools.sedalib.metadata.ArchiveUnitProfile;
import fr.gouv.vitam.tools.sedalib.metadata.ManagementMetadata;
import fr.gouv.vitam.tools.sedalib.metadata.content.Content;
import fr.gouv.vitam.tools.sedalib.metadata.management.Management;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.File;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.UUID;
import java.util.function.Function;

public class SIPBuilder
implements AutoCloseable {
    private SEDALibProgressLogger sedaLibProgressLogger;
    private ArchiveTransfer archiveTransfer;
    private ManagementMetadata managementMetadata;
    private String sipPathString;

    public SIPBuilder(String sipPathString, SEDALibProgressLogger sedaLibProgressLogger) {
        GlobalMetadata gm = new GlobalMetadata();
        ManagementMetadata mm = new ManagementMetadata();
        this.sipPathString = sipPathString;
        this.archiveTransfer = new ArchiveTransfer();
        gm.comment = "SIPBuilder generated";
        gm.messageIdentifier = "SIP " + UUID.randomUUID().toString();
        gm.setNowFlag(true);
        gm.archivalAgreement = null;
        gm.transferRequestReplyIdentifier = null;
        gm.archivalAgencyIdentifier = null;
        gm.archivalAgencyOrganizationDescriptiveMetadataXmlData = null;
        gm.transferringAgencyIdentifier = null;
        gm.transferringAgencyOrganizationDescriptiveMetadataXmlData = null;
        gm.codeListVersionsXmlData = "  <CodeListVersions>\n    <ReplyCodeListVersion>ReplyCodeListVersion</ReplyCodeListVersion>\n    <MessageDigestAlgorithmCodeListVersion>MessageDigestAlgorithmCodeListVersion</MessageDigestAlgorithmCodeListVersion>\n    <MimeTypeCodeListVersion>MimeTypeCodeListVersion</MimeTypeCodeListVersion>\n    <EncodingCodeListVersion>EncodingCodeListVersion</EncodingCodeListVersion>\n    <FileFormatCodeListVersion>FileFormatCodeListVersion</FileFormatCodeListVersion>\n    <CompressionAlgorithmCodeListVersion>CompressionAlgorithmCodeListVersion</CompressionAlgorithmCodeListVersion>\n    <DataObjectVersionCodeListVersion>DataObjectVersionCodeListVersion</DataObjectVersionCodeListVersion>\n    <StorageRuleCodeListVersion>StorageRuleCodeListVersion</StorageRuleCodeListVersion>\n    <AppraisalRuleCodeListVersion>AppraisalRuleCodeListVersion</AppraisalRuleCodeListVersion>\n    <AccessRuleCodeListVersion>AccessRuleCodeListVersion</AccessRuleCodeListVersion>\n    <DisseminationRuleCodeListVersion>DisseminationRuleCodeListVersion</DisseminationRuleCodeListVersion>\n    <ReuseRuleCodeListVersion>ReuseRuleCodeListVersion</ReuseRuleCodeListVersion>\n    <ClassificationRuleCodeListVersion>ClassificationRuleCodeListVersion</ClassificationRuleCodeListVersion>\n    <AuthorizationReasonCodeListVersion>AuthorizationReasonCodeListVersion</AuthorizationReasonCodeListVersion>\n    <RelationshipCodeListVersion>RelationshipCodeListVersion</RelationshipCodeListVersion>\n  </CodeListVersions>";
        this.archiveTransfer.setGlobalMetadata(gm);
        this.sedaLibProgressLogger = sedaLibProgressLogger;
        this.managementMetadata = mm;
    }

    public ArchiveTransfer getArchiveTransfer() {
        return this.archiveTransfer;
    }

    public void setComment(String comment) {
        this.archiveTransfer.getGlobalMetadata().comment = comment;
    }

    public void setMessageIdentifier(String messageIdentifier) {
        this.archiveTransfer.getGlobalMetadata().messageIdentifier = messageIdentifier;
    }

    public void setAgencies(String archivalAgencyIdentifier, String transferringAgencyIdentifier, String originatingAgencyIdentifier, String submissionAgencyIdentifier) {
        this.archiveTransfer.getGlobalMetadata().archivalAgencyIdentifier = archivalAgencyIdentifier;
        this.archiveTransfer.getGlobalMetadata().transferringAgencyIdentifier = transferringAgencyIdentifier;
        try {
            this.managementMetadata.addNewMetadata("OriginatingAgencyIdentifier", originatingAgencyIdentifier);
            this.managementMetadata.addNewMetadata("SubmissionAgencyIdentifier", submissionAgencyIdentifier);
        }
        catch (SEDALibException sEDALibException) {
            // empty catch block
        }
        this.archiveTransfer.getDataObjectPackage().setManagementMetadataXmlData(this.managementMetadata.toString());
    }

    public void setArchivalAgreement(String archivalAgreement) {
        this.archiveTransfer.getGlobalMetadata().archivalAgreement = archivalAgreement;
    }

    public ArchiveUnit createRootArchiveUnit(String archiveUnitID) throws SEDALibException {
        ArchiveUnit au = new ArchiveUnit();
        au.setInDataObjectPackageId(archiveUnitID);
        au.setDataObjectPackage(this.archiveTransfer.getDataObjectPackage());
        this.archiveTransfer.getDataObjectPackage().addArchiveUnit(au);
        this.archiveTransfer.getDataObjectPackage().addRootAu(au);
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: cr\u00e9ation d'une ArchiveUnit racine [" + archiveUnitID + "]", null);
        return au;
    }

    public ArchiveUnit createRootArchiveUnit(String archiveUnitID, String descriptionLevel, String title, String description) throws SEDALibException {
        ArchiveUnit au = this.createRootArchiveUnit(archiveUnitID);
        Content c = new Content();
        try {
            c.addNewMetadata("DescriptionLevel", descriptionLevel);
            c.addNewMetadata("Title", title);
            c.addNewMetadata("Description", description);
        }
        catch (SEDALibException sEDALibException) {
            // empty catch block
        }
        au.setContent(c);
        return au;
    }

    public ArchiveUnit createSystemExistingRootArchiveUnit(String archiveUnitID, String systemId) throws SEDALibException {
        ArchiveUnit au = this.createRootArchiveUnit(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        Management m = new Management();
        m.addNewMetadata("UpdateOperation", systemId);
        au.setManagement(m);
        return au;
    }

    public ArchiveUnit createSystemExistingRootArchiveUnit(String archiveUnitID, String metadataName, String metadataValue, String descriptionLevel, String title) throws SEDALibException {
        ArchiveUnit au = this.createRootArchiveUnit(archiveUnitID);
        Management m = new Management();
        m.addNewMetadata("UpdateOperation", metadataName, metadataValue);
        au.setManagement(m);
        Content c = new Content();
        c.addNewMetadata("DescriptionLevel", descriptionLevel);
        c.addNewMetadata("Title", title);
        au.setContent(c);
        return au;
    }

    public ArchiveUnit addSubArchiveUnit(String archiveUnitID, String childArchiveUnitID) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        ArchiveUnit childAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(childArchiveUnitID);
        if (childAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        parentAU.addChildArchiveUnit(childAU);
        return childAU;
    }

    public ArchiveUnit addNewSubArchiveUnit(String archiveUnitID, String childArchiveUnitID, String descriptionLevel, String title, String description) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        ArchiveUnit au = new ArchiveUnit();
        au.setInDataObjectPackageId(childArchiveUnitID);
        this.archiveTransfer.getDataObjectPackage().addArchiveUnit(au);
        Content c = new Content();
        c.addNewMetadata("DescriptionLevel", descriptionLevel);
        c.addNewMetadata("Title", title);
        c.addNewMetadata("Description", description);
        au.setContent(c);
        parentAU.addChildArchiveUnit(au);
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: cr\u00e9ation d'une sous ArchiveUnit [" + childArchiveUnitID + "] de [" + archiveUnitID + "]", null);
        return au;
    }

    public void addArchiveUnitSubTree(String archiveUnitID, String fromArchiveUnitID) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        ArchiveUnit fromAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(fromArchiveUnitID);
        if (fromAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        for (ArchiveUnit au : fromAU.getChildrenAuList().getArchiveUnitList()) {
            parentAU.addChildArchiveUnit(au);
        }
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: ajout d'un sous-arbre \u00e0 [" + archiveUnitID + "]", null);
    }

    public ArchiveUnit addFileSubArchiveUnit(String archiveUnitID, String onDiskPath, String childArchiveUnitID, String descriptionLevel, String title, String description) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        ArchiveUnit au = new ArchiveUnit();
        au.setInDataObjectPackageId(childArchiveUnitID);
        this.archiveTransfer.getDataObjectPackage().addArchiveUnit(au);
        Content c = new Content();
        c.addNewMetadata("DescriptionLevel", descriptionLevel);
        c.addNewMetadata("Title", title);
        if (description != null) {
            c.addNewMetadata("Description", description);
        }
        au.setContent(c);
        parentAU.addChildArchiveUnit(au);
        Path path = Paths.get(onDiskPath, new String[0]);
        BinaryDataObject bdo = new BinaryDataObject(this.archiveTransfer.getDataObjectPackage(), path, path.getFileName().toString(), "BinaryMaster_1");
        bdo.extractTechnicalElements(this.sedaLibProgressLogger);
        au.addDataObjectById(bdo.getInDataObjectPackageId());
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: cr\u00e9ation d'une sous ArchiveUnit [" + childArchiveUnitID + "] de [" + archiveUnitID + "]", null);
        return au;
    }

    public void addDiskSubTree(String archiveUnitID, String onDiskPathString, String ... ignorePatterString) throws SEDALibException {
        this.addDiskSubTree(archiveUnitID, onDiskPathString, false, null, ignorePatterString);
    }

    public void addDiskSubTree(String archiveUnitID, String onDiskPathString, boolean noLinkFlag, Function<String, String> extractTitleFromFileNameFunction, String ... ignorePatterString) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        DiskToDataObjectPackageImporter di = new DiskToDataObjectPackageImporter(onDiskPathString, noLinkFlag, extractTitleFromFileNameFunction, this.sedaLibProgressLogger);
        for (String ip : ignorePatterString) {
            di.addIgnorePattern(ip);
        }
        try {
            di.doImport();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        parentAU.getDataObjectPackage().moveContentFromDataObjectPackage(di.getDataObjectPackage(), parentAU);
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: ajout d'un sous-arbre \u00e0 [" + archiveUnitID + "]", null);
    }

    public void addCSVMetadataSubTree(String archiveUnitID, String encoding, char separator, String onDiskPathString) throws SEDALibException {
        ArchiveUnit parentAU = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (parentAU == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        CSVMetadataToDataObjectPackageImporter cmi = new CSVMetadataToDataObjectPackageImporter(onDiskPathString, encoding, separator, this.sedaLibProgressLogger);
        try {
            cmi.doImport();
        }
        catch (InterruptedException ignored) {
            Thread.currentThread().interrupt();
        }
        parentAU.getDataObjectPackage().moveContentFromDataObjectPackage(cmi.getDataObjectPackage(), parentAU);
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 40, "sedalib: ajout d'un sous-arbre \u00e0 [" + archiveUnitID + "]", null);
    }

    public void addFileToArchiveUnit(String archiveUnitID, String onDiskPathString, String usageVersion) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        Path path = Paths.get(onDiskPathString, new String[0]);
        String filename = path.getFileName().toString();
        BinaryDataObject bdo = new BinaryDataObject(this.archiveTransfer.getDataObjectPackage(), path, filename, usageVersion);
        bdo.extractTechnicalElements(this.sedaLibProgressLogger);
        au.addDataObjectById(bdo.getInDataObjectPackageId());
    }

    public String findArchiveUnitSimpleDescriptiveMetadata(String archiveUnitID, String metadataName) throws SEDALibException {
        Content c = this.getContent(archiveUnitID);
        if (c == null) {
            return null;
        }
        return c.getSimpleMetadata(metadataName);
    }

    public ArchiveUnit findArchiveUnitBySimpleDescriptiveMetadata(String metadataName, String metadataValue) throws SEDALibException {
        for (ArchiveUnit au : this.archiveTransfer.getDataObjectPackage().getAuInDataObjectPackageIdMap().values()) {
            String auValue = au.getContent().getSimpleMetadata(metadataName);
            if (auValue == null || !auValue.equals(metadataValue)) continue;
            return au;
        }
        return null;
    }

    public ArchiveUnit findArchiveUnit(String archiveUnitID) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        return au;
    }

    public ArchiveUnitProfile getArchiveUnitProfile(String archiveUnitID) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        ArchiveUnitProfile aup = au.getArchiveUnitProfile();
        if (aup == null) {
            aup = new ArchiveUnitProfile();
            au.setArchiveUnitProfile(aup);
        }
        return aup;
    }

    public void setArchiveUnitProfile(String archiveUnitID, ArchiveUnitProfile archiveUnitProfile) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        au.setArchiveUnitProfile(archiveUnitProfile);
    }

    public Content getContent(String archiveUnitID) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        Content c = au.getContent();
        if (c == null) {
            c = new Content();
            au.setContent(c);
        }
        return c;
    }

    public void setContent(String archiveUnitID, Content content) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        au.setContent(content);
    }

    public Management getManagement(String archiveUnitID) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        Management m = au.getManagement();
        if (m == null) {
            m = new Management();
            au.setManagement(m);
        }
        return m;
    }

    public void setManagement(String archiveUnitID, Management management) throws SEDALibException {
        ArchiveUnit au = this.archiveTransfer.getDataObjectPackage().getArchiveUnitById(archiveUnitID);
        if (au == null) {
            throw new SEDALibException("Pas d'ArchiveUnit avec l'identifiant [" + archiveUnitID + "]");
        }
        au.setManagement(management);
    }

    public void addNewContentMetadataInArchiveUnit(String archiveUnitID, String elementName, Object ... args) throws SEDALibException {
        Content c = this.getContent(archiveUnitID);
        c.addNewMetadata(elementName, args);
        this.setContent(archiveUnitID, c);
    }

    public void addNewManagementMetadataInArchiveUnit(String archiveUnitID, String elementName, Object ... args) throws SEDALibException {
        Management m = this.getManagement(archiveUnitID);
        m.addNewMetadata(elementName, args);
        this.setManagement(archiveUnitID, m);
    }

    public void sedaSchemaValidate() throws SEDALibException {
        try {
            this.archiveTransfer.sedaSchemaValidate(this.sedaLibProgressLogger);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    public void sedaProfileValidate(String profileFileName) throws SEDALibException {
        try {
            this.archiveTransfer.sedaProfileValidate(profileFileName, this.sedaLibProgressLogger);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
    }

    private void verifyContext() throws SEDALibException {
        if (this.archiveTransfer.getGlobalMetadata().archivalAgencyIdentifier == null) {
            throw new SEDALibException("Element ArchivalAgencyIdentifier non d\u00e9fini");
        }
        if (this.archiveTransfer.getGlobalMetadata().transferringAgencyIdentifier == null) {
            throw new SEDALibException("Element TransferringAgencyIdentifier non d\u00e9fini");
        }
        if (this.managementMetadata.isMetadataLacking("OriginatingAgencyIdentifier")) {
            throw new SEDALibException("Element OriginatingAgencyIdentifier non d\u00e9fini");
        }
        if (this.managementMetadata.isMetadataLacking("SubmissionAgencyIdentifier")) {
            throw new SEDALibException("Element SubmissionAgencyIdentifier non d\u00e9fini");
        }
        if (this.archiveTransfer.getGlobalMetadata().archivalAgreement == null) {
            throw new SEDALibException("Element ArchivalAgreement non d\u00e9fini");
        }
    }

    public void generateSIP() throws SEDALibException {
        this.generateSIP(false, false);
    }

    public void generateSIP(boolean hierarchicalArchiveUnitsFlag, boolean indentedFlag) throws SEDALibException {
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 10, "sedalib: lancement de la g\u00e9n\u00e9ration du SIP", null);
        try {
            this.archiveTransfer.getDataObjectPackage().vitamNormalize(this.sedaLibProgressLogger);
            this.verifyContext();
            this.archiveTransfer.getDataObjectPackage().regenerateContinuousIds();
        }
        catch (SEDALibException e) {
            throw new SEDALibException("Le paquet SIP n'est pas constructible", e);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SEDALibException("La construction du paquet SIP est interrompue", e);
        }
        ArchiveTransferToSIPExporter sm = new ArchiveTransferToSIPExporter(this.archiveTransfer, this.sedaLibProgressLogger);
        try {
            sm.doExportToSEDASIP(this.sipPathString, hierarchicalArchiveUnitsFlag, indentedFlag);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
        }
        SEDALibProgressLogger.doProgressLogWithoutInterruption(this.sedaLibProgressLogger, 10, "sedalib: fichier sauvegard\u00e9 (" + SEDALibProgressLogger.readableFileSize(new File(this.sipPathString).length()) + ")", null);
    }

    @Override
    public void close() {
    }
}

