/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.droid;

import fr.gouv.vitam.tools.sedalib.droid.ContainerDroidIdentifier;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequestFactory;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureSaxParser;
import uk.gov.nationalarchives.droid.container.TriggerPuid;
import uk.gov.nationalarchives.droid.container.ole2.Ole2IdentifierEngine;
import uk.gov.nationalarchives.droid.container.zip.ZipIdentifierEngine;
import uk.gov.nationalarchives.droid.core.BinarySignatureIdentifier;
import uk.gov.nationalarchives.droid.core.SignatureParseException;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResult;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.RequestIdentifier;
import uk.gov.nationalarchives.droid.core.interfaces.resource.FileSystemIdentificationRequest;
import uk.gov.nationalarchives.droid.core.interfaces.resource.RequestMetaData;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.FileFormatCollection;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;

public class DroidIdentifier {
    private static final String DROID_SIGNATURE_FILE = "DROID_SignatureFile_V120.xml";
    private static final String CONTAINER_SIGNATURE_FILE = "container-signature-20240715.xml";
    private static DroidIdentifier instance = null;
    private String configDir;
    private FFSignatureFile binarySignatureFile;
    private ContainerSignatureDefinitions containerSignatureDefinitions;
    private BinarySignatureIdentifier binarySignatureIdentifier;
    private HashMap<String, ContainerDroidIdentifier> containerContentIdentierMap;
    private static final String OLE2_CONTAINER = "OLE2";
    private static final String ZIP_CONTAINER = "ZIP";

    private DroidIdentifier(SEDALibProgressLogger sedaLibProgressLogger, String configDir) throws SEDALibException {
        this.configDir = configDir;
        this.initSignatureDroid(sedaLibProgressLogger);
        this.initContainerDroid(sedaLibProgressLogger);
    }

    public static DroidIdentifier init(SEDALibProgressLogger sedaLibProgressLogger, String configDir) throws SEDALibException {
        instance = new DroidIdentifier(sedaLibProgressLogger, configDir);
        return instance;
    }

    public static DroidIdentifier getInstance() {
        if (instance == null) {
            try {
                instance = new DroidIdentifier(null, "./config");
            }
            catch (SEDALibException e) {
                System.err.println(SEDALibProgressLogger.getAllJavaStackString(e));
                System.exit(1);
            }
        }
        return instance;
    }

    private String getBinarySignatureFileName(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        String[] fileList;
        String result = null;
        FilenameFilter droidFilter = (dir, name) -> {
            if (name.startsWith("DROID_SignatureFile_V") && name.endsWith(".xml")) {
                String serial = name.substring(21, name.lastIndexOf(".xml"));
                try {
                    Integer.parseInt(serial);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
            return false;
        };
        File dir2 = new File(this.configDir);
        if (dir2.isFile()) {
            throw new SEDALibException("Panic! Can't create config directory");
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        if ((fileList = dir2.list(droidFilter)) == null || fileList.length == 0) {
            SEDALibProgressLogger.doProgressLogWithoutInterruption(sedaLibProgressLogger, 10, "sedalib: can't find a DROID signature file, copy from ressource to file DROID_SignatureFile_V120.xml", null);
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(DROID_SIGNATURE_FILE);){
                File targetFile = new File("." + File.separator + "config" + File.separator + DROID_SIGNATURE_FILE);
                Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new SEDALibException("Panic! Can't extract a DROID signature file, stop");
            }
            result = DROID_SIGNATURE_FILE;
        } else {
            int serialNum = -1;
            for (String name2 : fileList) {
                int j = Integer.parseInt(name2.substring(21, name2.lastIndexOf(".xml")));
                if (j <= serialNum) continue;
                serialNum = j;
                result = name2;
            }
        }
        return "." + File.separator + "config" + File.separator + result;
    }

    private void initSignatureDroid(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        this.binarySignatureIdentifier = new BinarySignatureIdentifier();
        String sigFileName = this.getBinarySignatureFileName(sedaLibProgressLogger);
        this.binarySignatureIdentifier.setSignatureFile(sigFileName);
        try {
            this.binarySignatureIdentifier.init();
        }
        catch (SignatureParseException x) {
            System.err.println("Panic: Can't parse file: '" + sigFileName + "'");
            System.exit(1);
        }
        this.binarySignatureFile = this.binarySignatureIdentifier.getSigFile();
    }

    private String getContainerSignatureFileName(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        String[] fileList;
        String result = null;
        FilenameFilter droidFilter = (dir, name) -> {
            if (name.startsWith("container-signature-") && name.endsWith(".xml")) {
                String serial = name.substring(20, name.lastIndexOf(".xml"));
                try {
                    Integer.parseInt(serial);
                }
                catch (NumberFormatException e) {
                    return false;
                }
                return true;
            }
            return false;
        };
        File dir2 = new File(this.configDir);
        if (dir2.isFile()) {
            throw new SEDALibException("Panic! Can't create config directory");
        }
        if (!dir2.exists()) {
            dir2.mkdirs();
        }
        if ((fileList = dir2.list(droidFilter)) == null || fileList.length == 0) {
            SEDALibProgressLogger.doProgressLogWithoutInterruption(sedaLibProgressLogger, 10, "sedalib: can't find a DROID container signature file, copy from ressource to file container-signature-20240715.xml", null);
            try (InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream(CONTAINER_SIGNATURE_FILE);){
                File targetFile = new File("." + File.separator + "config" + File.separator + CONTAINER_SIGNATURE_FILE);
                Files.copy(is, targetFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
            }
            catch (IOException e) {
                throw new SEDALibException("Panic! Can't extract a DROID signature file, stop");
            }
            result = CONTAINER_SIGNATURE_FILE;
        } else {
            int serialNum = -1;
            for (String name2 : fileList) {
                int j = Integer.parseInt(name2.substring(21, name2.lastIndexOf(".xml")));
                if (j <= serialNum) continue;
                serialNum = j;
                result = name2;
            }
        }
        return "." + File.separator + "config" + File.separator + result;
    }

    private void initContainerDroid(SEDALibProgressLogger sedaLibProgressLogger) throws SEDALibException {
        String containerSigFileName = this.getContainerSignatureFileName(sedaLibProgressLogger);
        try (FileInputStream in = new FileInputStream(containerSigFileName);){
            ContainerSignatureSaxParser parser2 = new ContainerSignatureSaxParser();
            this.containerSignatureDefinitions = parser2.parse(in);
        }
        catch (SignatureParseException e) {
            throw new SEDALibException("Panic! Can't parse container signature file", e);
        }
        catch (Exception e) {
            throw new SEDALibException("Panic! Can't open container signature file", e);
        }
        this.containerContentIdentierMap = new HashMap();
        ContainerFileIdentificationRequestFactory ole2RequestFactory = new ContainerFileIdentificationRequestFactory();
        ContainerDroidIdentifier ole2Identifier = new ContainerDroidIdentifier(this.containerSignatureDefinitions, this.binarySignatureFile, OLE2_CONTAINER);
        Ole2IdentifierEngine ole2IdentifierEngine = new Ole2IdentifierEngine();
        ole2IdentifierEngine.setRequestFactory(ole2RequestFactory);
        ole2Identifier.setIdentifierEngine(ole2IdentifierEngine);
        this.containerContentIdentierMap.put(OLE2_CONTAINER, ole2Identifier);
        ContainerFileIdentificationRequestFactory zipRequestFactory = new ContainerFileIdentificationRequestFactory();
        ContainerDroidIdentifier zipIdentifier = new ContainerDroidIdentifier(this.containerSignatureDefinitions, this.binarySignatureFile, ZIP_CONTAINER);
        ZipIdentifierEngine zipIdentifierEngine = new ZipIdentifierEngine();
        zipIdentifierEngine.setRequestFactory(zipRequestFactory);
        zipIdentifier.setIdentifierEngine(zipIdentifierEngine);
        this.containerContentIdentierMap.put(ZIP_CONTAINER, zipIdentifier);
    }

    public TriggerPuid getTriggerPuidByPuid(String puid) {
        for (TriggerPuid tp : this.containerSignatureDefinitions.getTiggerPuids()) {
            if (!tp.getPuid().equals(puid)) continue;
            return tp;
        }
        return null;
    }

    public boolean canAnalyzeContainer() {
        return this.containerSignatureDefinitions != null;
    }

    public IdentificationResult getIdentificationResult(Path path) throws SEDALibException {
        IdentificationResultCollection resultsContainerCollection;
        String filename = path.normalize().toString();
        FileSystemIdentificationRequest request = null;
        try {
            RequestMetaData metaData = new RequestMetaData(Files.size(path), Files.getLastModifiedTime(path, new LinkOption[0]).toMillis(), filename);
            RequestIdentifier identifier = new RequestIdentifier(path.toUri());
            identifier.setParentId(1L);
            request = new FileSystemIdentificationRequest(metaData, identifier);
            request.open(path);
        }
        catch (IOException e) {
            if (request != null) {
                try {
                    request.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            throw new SEDALibException("Impossible d'acc\u00e9der au fichier [" + filename + "]");
        }
        IdentificationResultCollection resultsSignatureCollection = this.getSignatureResults(request);
        try {
            resultsContainerCollection = this.getContainerResults(resultsSignatureCollection, request);
        }
        catch (SEDALibException e) {
            try {
                request.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw new SEDALibException("Erreur dans l'identification par container du fichier [" + filename + "]");
        }
        List<IdentificationResult> irl = resultsContainerCollection != null && !resultsContainerCollection.getResults().isEmpty() ? resultsContainerCollection.getResults() : (!resultsSignatureCollection.getResults().isEmpty() ? resultsSignatureCollection.getResults() : this.getExtensionResults(request).getResults());
        try {
            request.close();
        }
        catch (IOException e) {
            throw new SEDALibException("Erreur dans l'identification droid du fichier [" + filename + "], impossible de fermer la requ\u00eate");
        }
        if (irl != null && !irl.isEmpty()) {
            String fileExtension = "";
            if (filename.lastIndexOf(46) != -1) {
                fileExtension = filename.substring(filename.lastIndexOf(46) + 1);
            }
            return this.selectBestResult(irl, fileExtension);
        }
        return null;
    }

    IdentificationResultCollection getSignatureResults(IdentificationRequest request) {
        IdentificationResultCollection results = this.binarySignatureIdentifier.matchBinarySignatures(request);
        this.binarySignatureIdentifier.checkForExtensionsMismatches(results, request.getExtension());
        return results;
    }

    IdentificationResultCollection getExtensionResults(IdentificationRequest request) {
        return this.binarySignatureIdentifier.matchExtensions(request, true);
    }

    IdentificationResultCollection getContainerResults(IdentificationResultCollection signatureResults, IdentificationRequest request) throws SEDALibException {
        IdentificationResultCollection containerResults = new IdentificationResultCollection(request);
        if (!signatureResults.getResults().isEmpty() && this.canAnalyzeContainer()) {
            for (IdentificationResult identResult : signatureResults.getResults()) {
                String containerType;
                ContainerDroidIdentifier cci;
                TriggerPuid containerPuid;
                String filePuid = identResult.getPuid();
                if (filePuid == null || (containerPuid = this.getTriggerPuidByPuid(filePuid)) == null || (cci = this.containerContentIdentierMap.get(containerType = containerPuid.getContainerType())) == null) continue;
                try {
                    containerResults = cci.getContainerIdentification(request.getSourceInputStream(), containerResults);
                }
                catch (IOException e) {
                    throw new SEDALibException("Impossible d'analyser en conteneur le format du fichier [" + request.getFileName() + "]");
                }
            }
        }
        return containerResults;
    }

    protected IdentificationResult selectBestResult(List<IdentificationResult> irl, String fileExtension) {
        int i;
        int numResults = irl.size();
        if (numResults == 0) {
            return null;
        }
        if (numResults == 1) {
            return irl.get(0);
        }
        FileFormatCollection allFormats = this.binarySignatureFile.getFileFormatCollection();
        HashSet<Integer> lowerPriorityIDs = new HashSet<Integer>();
        for (int i2 = 0; i2 < numResults; ++i2) {
            IdentificationResult result = irl.get(i2);
            String resultPUID = result.getPuid();
            FileFormat format = allFormats.getFormatForPUID(resultPUID);
            lowerPriorityIDs.addAll(format.getFormatIdsHasPriorityOver());
        }
        ArrayList<IdentificationResult> lowerPriorityResults = new ArrayList<IdentificationResult>();
        for (i = 0; i < numResults; ++i) {
            IdentificationResult tmp = irl.get(i);
            String resultPUID = tmp.getPuid();
            FileFormat format = allFormats.getFormatForPUID(resultPUID);
            if (!lowerPriorityIDs.contains(format.getID())) continue;
            lowerPriorityResults.add(tmp);
        }
        numResults = lowerPriorityResults.size();
        for (i = 0; i < numResults; ++i) {
            irl.remove(lowerPriorityResults.get(i));
        }
        numResults = irl.size();
        if (numResults == 0) {
            return null;
        }
        if (numResults == 1) {
            return irl.get(0);
        }
        for (i = 0; i < numResults; ++i) {
            FileFormat format = allFormats.getFormatForPUID(irl.get(i).getPuid());
            if (!format.hasMatchingExtension(fileExtension)) continue;
            return irl.get(i);
        }
        return irl.get(0);
    }

    public static String getFileDroidFormat(String filename) throws SEDALibException {
        String droidFormat;
        Path onDiskPath = null;
        try {
            onDiskPath = Paths.get(filename, new String[0]);
            IdentificationResult ir = DroidIdentifier.getInstance().getIdentificationResult(onDiskPath);
            droidFormat = ir.getPuid();
        }
        catch (SEDALibException e) {
            throw new SEDALibException("Impossible de faire l'identification de format Droid pour le fichier [" + onDiskPath + "]", e);
        }
        return droidFormat;
    }
}

