/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.droid;

import java.io.IOException;
import java.io.InputStream;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import uk.gov.nationalarchives.droid.container.ContainerFileIdentificationRequest;
import uk.gov.nationalarchives.droid.container.ContainerIdentifierInit;
import uk.gov.nationalarchives.droid.container.ContainerSignatureDefinitions;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatch;
import uk.gov.nationalarchives.droid.container.ContainerSignatureMatchCollection;
import uk.gov.nationalarchives.droid.container.FileFormatMapping;
import uk.gov.nationalarchives.droid.container.IdentifierEngine;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationMethod;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultCollection;
import uk.gov.nationalarchives.droid.core.interfaces.IdentificationResultImpl;
import uk.gov.nationalarchives.droid.core.signature.FileFormat;
import uk.gov.nationalarchives.droid.core.signature.droid6.FFSignatureFile;

public class ContainerDroidIdentifier {
    private ContainerIdentifierInit containerIdentifierInit;
    private FFSignatureFile binarySignatureFile;
    private IdentifierEngine identifierEngine;
    private Map<Integer, List<FileFormatMapping>> formats = new HashMap<Integer, List<FileFormatMapping>>();

    public ContainerDroidIdentifier(ContainerSignatureDefinitions defs, FFSignatureFile binarySignatureFile, String containerType) {
        this.containerIdentifierInit = new ContainerIdentifierInit();
        this.containerIdentifierInit.init(defs, containerType, this.formats, null);
        this.binarySignatureFile = binarySignatureFile;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdentificationResultCollection getContainerIdentification(InputStream inputStream, IdentificationResultCollection identificationResults) throws IOException {
        try (ContainerFileIdentificationRequest request = new ContainerFileIdentificationRequest(null);){
            request.open(inputStream);
            int maxBytesToScan = -1;
            ContainerSignatureMatchCollection matches = new ContainerSignatureMatchCollection(this.getContainerIdentifierInit().getContainerSignatures(), this.getContainerIdentifierInit().getUniqueFileEntries(), maxBytesToScan);
            this.identifierEngine.process(request, matches);
            HashMap<String, String> puidMap = new HashMap<String, String>();
            for (ContainerSignatureMatch match : matches.getContainerSignatureMatches()) {
                if (!match.isMatch()) continue;
                List<FileFormatMapping> mappings = this.getFormats().get(match.getSignature().getId());
                for (FileFormatMapping mapping : mappings) {
                    IdentificationResultImpl result = new IdentificationResultImpl();
                    result.setMethod(IdentificationMethod.CONTAINER);
                    result.setRequestMetaData(request.getRequestMetaData());
                    String puid = mapping.getPuid();
                    result.setPuid(mapping.getPuid());
                    FileFormat ff = this.binarySignatureFile.getFileFormat(puid);
                    result.setName(ff.getName());
                    result.setMimeType(ff.getMimeType());
                    result.setVersion(ff.getVersion());
                    if (puidMap.containsKey(puid)) continue;
                    puidMap.put(puid, "");
                    identificationResults.addResult(result);
                }
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
        }
        return identificationResults;
    }

    public ContainerIdentifierInit getContainerIdentifierInit() {
        return this.containerIdentifierInit;
    }

    public Map<Integer, List<FileFormatMapping>> getFormats() {
        return this.formats;
    }

    public void setIdentifierEngine(IdentifierEngine identifierEngine) {
        this.identifierEngine = identifierEngine;
    }
}

