/*
 * Decompiled with CFR 0.152.
 */
package fr.gouv.vitam.tools.sedalib.core.seda;

import fr.gouv.vitam.tools.sedalib.core.BinaryDataObject;
import fr.gouv.vitam.tools.sedalib.core.DataObjectPackage;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaContext;
import fr.gouv.vitam.tools.sedalib.core.seda.SedaVersion;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibException;
import fr.gouv.vitam.tools.sedalib.utils.SEDALibProgressLogger;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLEventReader;
import fr.gouv.vitam.tools.sedalib.xml.SEDAXMLStreamWriter;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Map;
import javax.xml.stream.XMLStreamException;

public class SedaVersionConverter {
    private final SEDALibProgressLogger progressLogger;

    public SedaVersionConverter(SEDALibProgressLogger progressLogger) {
        this.progressLogger = progressLogger;
    }

    public DataObjectPackage convert(DataObjectPackage originalPackage, SedaVersion sourceSedaVersion, SedaVersion targetSedaVersion) throws SEDALibException, InterruptedException {
        if (sourceSedaVersion.equals((Object)targetSedaVersion)) {
            throw new SEDALibException("Source and target SEDA versions are identical: " + sourceSedaVersion);
        }
        if (!sourceSedaVersion.equals((Object)SedaContext.getVersion())) {
            throw new SEDALibException("Source and context SEDA versions are different: (source: " + sourceSedaVersion + ", context: " + SedaContext.getVersion());
        }
        this.logGlobal("Conversion from " + sourceSedaVersion + " to " + targetSedaVersion);
        String sedaXml = this.serializeToSedaXml(originalPackage, sourceSedaVersion);
        SedaContext.setVersion(targetSedaVersion);
        try {
            DataObjectPackage convertedPackage = this.deserializeFromSedaXml(sedaXml);
            this.restoreBinaryObjectPaths(originalPackage, convertedPackage);
            return convertedPackage;
        }
        catch (Exception e) {
            SedaContext.setVersion(sourceSedaVersion);
            throw new SEDALibException("Failed to convert DataObjectPackage to " + targetSedaVersion, e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private String serializeToSedaXml(DataObjectPackage dataObjectPackage, SedaVersion sedaVersion) throws SEDALibException, InterruptedException {
        this.logStep("-> Serializing DataObjectPackage to " + sedaVersion.displayString() + " XML");
        try (ByteArrayOutputStream baos = new ByteArrayOutputStream();){
            String string;
            try (SEDAXMLStreamWriter xmlWriter = new SEDAXMLStreamWriter(baos, 2);){
                dataObjectPackage.toSedaXml(xmlWriter, true, this.progressLogger);
                string = baos.toString(StandardCharsets.UTF_8);
            }
            return string;
        }
        catch (IOException | XMLStreamException e) {
            throw new SEDALibException("Failed to serialize DataObjectPackage to " + sedaVersion.displayString() + " XML", e);
        }
    }

    /*
     * Enabled aggressive exception aggregation
     */
    private DataObjectPackage deserializeFromSedaXml(String xml) throws SEDALibException, InterruptedException {
        this.logStep("-> Deserializing XML to DataObjectPackage");
        try (ByteArrayInputStream bais = new ByteArrayInputStream(xml.getBytes(StandardCharsets.UTF_8));){
            DataObjectPackage dataObjectPackage;
            try (SEDAXMLEventReader xmlReader = new SEDAXMLEventReader(bais, true);){
                xmlReader.xmlReader.nextEvent();
                dataObjectPackage = DataObjectPackage.fromSedaXml(xmlReader, "unknown", this.progressLogger);
            }
            return dataObjectPackage;
        }
        catch (IOException | XMLStreamException e) {
            throw new SEDALibException("Failed to deserialize XML to DataObjectPackage", e);
        }
    }

    private void restoreBinaryObjectPaths(DataObjectPackage source, DataObjectPackage target) {
        for (Map.Entry<String, BinaryDataObject> entry : source.getBdoInDataObjectPackageIdMap().entrySet()) {
            String id = entry.getKey();
            BinaryDataObject sourceBdo = entry.getValue();
            BinaryDataObject targetBdo = target.getBdoInDataObjectPackageIdMap().get(id);
            if (targetBdo == null) continue;
            targetBdo.setOnDiskPath(sourceBdo.getOnDiskPath());
        }
    }

    private void logStep(String message) throws InterruptedException {
        SEDALibProgressLogger.doProgressLog(this.progressLogger, 20, message, null);
    }

    private void logGlobal(String message) throws InterruptedException {
        SEDALibProgressLogger.doProgressLog(this.progressLogger, 10, message, null);
    }
}

